/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver.options;

import com.xceptance.xlt.engine.xltdriver.options.BrowserVersionTraitNames;
import com.xceptance.xlt.engine.xltdriver.options.OptionEnum;
import com.xceptance.xlt.engine.xltdriver.options.TypeCodec;
import java.util.Map;
import java.util.TimeZone;
import org.htmlunit.BrowserVersion;

public enum BrowserVersionTrait implements BrowserVersionTraitNames,
OptionEnum
{
    NUMERIC_CODE("numericCode", (Class)Integer.TYPE, (Object)0){

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getBrowserVersionNumeric();
        }
    }
    ,
    NICKNAME("nickname", (Class)String.class, (Object)null){

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getNickname();
        }
    }
    ,
    APPLICATION_VERSION("applicationVersion", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setApplicationVersion(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getApplicationVersion();
        }
    }
    ,
    USER_AGENT("userAgent", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setUserAgent(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getUserAgent();
        }
    }
    ,
    APPLICATION_NAME("applicationName", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setApplicationName(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getApplicationName();
        }
    }
    ,
    APPLICATION_CODE_NAME("applicationCodeName", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setApplicationCodeName(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getApplicationCodeName();
        }
    }
    ,
    APPLICATION_MINOR_VERSION("applicationMinorVersion", (Class)String.class, (Object)"0"){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setApplicationMinorVersion(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getApplicationMinorVersion();
        }
    }
    ,
    VENDOR("vendor", (Class)String.class, (Object)""){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setVendor(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getVendor();
        }
    }
    ,
    BROWSER_LANGUAGE("browserLanguage", (Class)String.class, (Object)"en-US"){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setBrowserLanguage(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getBrowserLanguage();
        }
    }
    ,
    IS_ONLINE("isOnline", (Class)Boolean.TYPE, (Object)true){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setOnLine(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.isOnLine();
        }
    }
    ,
    PLATFORM("platform", (Class)String.class, (Object)"Win32"){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setPlatform(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getPlatform();
        }
    }
    ,
    SYSTEM_TIMEZONE("systemTimezone", (Class)TimeZone.class, (Object)TimeZone.getTimeZone("America/New_York")){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setSystemTimezone(TypeCodec.decodeTimeZone(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getSystemTimezone();
        }
    }
    ,
    ACCEPT_ENCODING_HEADER("acceptEncodingHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setAcceptEncodingHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getAcceptEncodingHeader();
        }
    }
    ,
    ACCEPT_LANGUAGE_HEADER("acceptLanguageHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setAcceptLanguageHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getAcceptLanguageHeader();
        }
    }
    ,
    HTML_ACCEPT_HEADER("htmlAcceptHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setHtmlAcceptHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getHtmlAcceptHeader();
        }
    }
    ,
    IMG_ACCEPT_HEADER("imgAcceptHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setImgAcceptHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getImgAcceptHeader();
        }
    }
    ,
    CSS_ACCEPT_HEADER("cssAcceptHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setCssAcceptHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getCssAcceptHeader();
        }
    }
    ,
    SCRIPT_ACCEPT_HEADER("scriptAcceptHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setScriptAcceptHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getScriptAcceptHeader();
        }
    }
    ,
    XML_HTTP_REQUEST_ACCEPT_HEADER("xmlHttpRequestAcceptHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setXmlHttpRequestAcceptHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getXmlHttpRequestAcceptHeader();
        }
    }
    ,
    SEC_CLIENT_HINT_USER_AGENT_HEADER("secClientHintUserAgentHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setSecClientHintUserAgentHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getSecClientHintUserAgentHeader();
        }
    }
    ,
    SEC_CLIENT_HINT_USER_AGENT_PLATFORM_HEADER("secClientHintUserAgentPlatformHeader", (Class)String.class, (Object)null){

        @Override
        public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
            builder.setSecClientHintUserAgentPlatformHeader(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(BrowserVersion version) {
            return version.getSecClientHintUserAgentPlatformHeader();
        }
    };

    private final String capabilityKey_;
    private final String propertyName_;
    private final Class<?> optionType_;
    private final Object defaultValue_;

    private BrowserVersionTrait(String key, Class<?> type, Object initial) {
        this.capabilityKey_ = key;
        this.propertyName_ = "webdriver.htmlunit.browserVersionTrait." + key;
        this.optionType_ = type;
        this.defaultValue_ = initial;
    }

    @Override
    public String getCapabilityKey() {
        return this.capabilityKey_;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName_;
    }

    @Override
    public Class<?> getOptionType() {
        return this.optionType_;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue_;
    }

    @Override
    public boolean isDefaultValue(Object value) {
        if (this.defaultValue_ == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        return value.equals(this.defaultValue_);
    }

    @Override
    public void applyPropertyTo(Map<String, Object> optionsMap) {
        String value = System.getProperty(this.propertyName_);
        if (value != null) {
            optionsMap.put(this.capabilityKey_, this.decode(value));
            System.clearProperty(this.capabilityKey_);
        }
    }

    @Override
    public Object encode(Object value) {
        switch (this.optionType_.getName()) {
            case "boolean": 
            case "int": 
            case "java.lang.String": {
                return value;
            }
            case "java.util.TimeZone": {
                return TypeCodec.encodeTimeZone(value);
            }
        }
        throw new IllegalStateException(String.format("Unsupported type '%s' specified for option [%s]; value is of type: %s", this.optionType_.getName(), this.toString(), TypeCodec.getClassName(value)));
    }

    @Override
    public Object decode(Object value) {
        switch (this.optionType_.getName()) {
            case "boolean": {
                return TypeCodec.decodeBoolean(value);
            }
            case "int": {
                return TypeCodec.decodeInt(value);
            }
            case "java.lang.String": {
                return TypeCodec.decodeString(value);
            }
            case "java.util.TimeZone": {
                return TypeCodec.decodeTimeZone(value);
            }
        }
        throw new IllegalStateException(String.format("Unsupported type '%s' specified for option [%s]; value is of type: %s", this.optionType_.getName(), this.toString(), TypeCodec.getClassName(value)));
    }

    public void apply(Object value, BrowserVersion.BrowserVersionBuilder builder) {
        throw new UnsupportedOperationException(String.format("Trait '%s' does not support value insertion", this.toString()));
    }

    public Object obtain(BrowserVersion version) {
        return null;
    }

    public static BrowserVersionTrait fromCapabilityKey(String key) {
        for (BrowserVersionTrait trait : BrowserVersionTrait.values()) {
            if (!trait.capabilityKey_.equals(key)) continue;
            return trait;
        }
        return null;
    }

    public static BrowserVersionTrait fromPropertyName(String name) {
        for (BrowserVersionTrait trait : BrowserVersionTrait.values()) {
            if (!trait.propertyName_.equals(name)) continue;
            return trait;
        }
        return null;
    }
}

