/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.xceptance.xlt.engine.xltdriver.HtmlUnitAlert;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitWebElement;
import java.util.List;
import org.htmlunit.Page;
import org.htmlunit.WebWindow;
import org.htmlunit.WebWindowNotFoundException;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlHtml;
import org.htmlunit.html.HtmlPage;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.WrapsElement;
import org.w3c.dom.NodeList;

public class HtmlUnitTargetLocator
implements WebDriver.TargetLocator {
    private final HtmlUnitDriver driver_;

    public HtmlUnitTargetLocator(HtmlUnitDriver driver) {
        this.driver_ = driver;
    }

    public WebDriver newWindow(WindowType typeHint) {
        this.driver_.openNewWindow();
        return this.driver_;
    }

    public WebDriver frame(int index) {
        Page page = this.driver_.getCurrentWindow().lastPage();
        if (page instanceof HtmlPage) {
            try {
                this.driver_.setCurrentWindow(((HtmlPage)page).getFrames().get(index));
            }
            catch (IndexOutOfBoundsException ignored) {
                throw new NoSuchFrameException("Cannot find frame: " + index);
            }
        }
        return this.driver_;
    }

    public WebDriver frame(String nameOrId) {
        Page page = this.driver_.getCurrentWindow().lastPage();
        if (page instanceof HtmlPage) {
            for (FrameWindow frameWindow : ((HtmlPage)page).getFrames()) {
                if (!frameWindow.getName().equals(nameOrId)) continue;
                this.driver_.setCurrentWindow(frameWindow);
                return this.driver_;
            }
        }
        try {
            HtmlUnitWebElement element = (HtmlUnitWebElement)this.driver_.findElement(By.id((String)nameOrId));
            DomElement domElement = element.getElement();
            if (domElement instanceof BaseFrameElement) {
                this.driver_.setCurrentWindow(((BaseFrameElement)domElement).getEnclosedWindow());
                return this.driver_;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        throw new NoSuchFrameException("Unable to locate frame with name or ID: " + nameOrId);
    }

    public WebDriver frame(WebElement frameElement) {
        while (frameElement instanceof WrapsElement) {
            frameElement = ((WrapsElement)frameElement).getWrappedElement();
        }
        HtmlUnitWebElement webElement = (HtmlUnitWebElement)frameElement;
        webElement.assertElementNotStale();
        DomElement domElement = webElement.getElement();
        if (!(domElement instanceof BaseFrameElement)) {
            throw new NoSuchFrameException(webElement.getTagName() + " is not a frame element.");
        }
        this.driver_.setCurrentWindow(((BaseFrameElement)domElement).getEnclosedWindow());
        return this.driver_;
    }

    public WebDriver parentFrame() {
        this.driver_.setCurrentWindow(this.driver_.getCurrentWindow().getWebWindow().getParentWindow());
        return this.driver_;
    }

    public WebDriver window(String windowId) {
        try {
            WebWindow window = this.driver_.getWebClient().getWebWindowByName(windowId);
            return this.finishSelecting(window);
        }
        catch (WebWindowNotFoundException e) {
            List<WebWindow> allWindows = this.driver_.getWebClient().getWebWindows();
            for (WebWindow current : allWindows) {
                WebWindow top = current.getTopWindow();
                if (!String.valueOf(System.identityHashCode(top)).equals(windowId)) continue;
                return this.finishSelecting(top);
            }
            throw new NoSuchWindowException("Cannot find window: " + windowId);
        }
    }

    private WebDriver finishSelecting(WebWindow window) {
        this.driver_.getWebClient().setCurrentWindow(window);
        this.driver_.setCurrentWindow(window);
        this.driver_.getAlert().setAutoAccept(false);
        return this.driver_;
    }

    public WebDriver defaultContent() {
        this.driver_.switchToDefaultContentOfWindow(this.driver_.getCurrentWindow().getWebWindow().getTopWindow());
        return this.driver_;
    }

    public WebElement activeElement() {
        Page page = this.driver_.getCurrentWindow().lastPage();
        if (page instanceof HtmlPage) {
            DomElement element = ((HtmlPage)page).getFocusedElement();
            if (element == null || element instanceof HtmlHtml) {
                NodeList allBodies = ((HtmlPage)page).getDocumentElement().getElementsByTagName("body");
                if (!allBodies.isEmpty()) {
                    return this.driver_.toWebElement((DomElement)allBodies.get(0));
                }
            } else {
                return this.driver_.toWebElement(element);
            }
        }
        throw new NoSuchElementException("Unable to locate element with focus or body tag");
    }

    public Alert alert() {
        WebWindow currentWindow;
        WebWindow alertWindow;
        HtmlUnitAlert alert = this.driver_.getAlert();
        if (!alert.isLocked()) {
            for (int i = 0; i < 5; ++i) {
                if (alert.isLocked()) continue;
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!alert.isLocked()) {
                this.driver_.getCurrentWindow();
                throw new NoAlertPresentException();
            }
        }
        if ((alertWindow = alert.getWebWindow()) != (currentWindow = this.driver_.getCurrentWindow().getWebWindow()) && !HtmlUnitTargetLocator.isChild(currentWindow, alertWindow) && !HtmlUnitTargetLocator.isChild(alertWindow, currentWindow)) {
            throw new TimeoutException();
        }
        return alert;
    }

    private static boolean isChild(WebWindow parent, WebWindow potentialChild) {
        for (WebWindow child = potentialChild; child != null; child = child.getParentWindow()) {
            if (child == parent) {
                return true;
            }
            if (child == child.getTopWindow()) break;
        }
        return false;
    }
}

