/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.webdriver;

import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.scripting.PageLoadTimeoutException;
import com.xceptance.xlt.engine.scripting.util.CommandsInvocationHandler;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverScriptCommands;
import java.lang.reflect.Method;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.slf4j.Logger;

public final class WebDriverScriptCommandsInvocationHandler
extends CommandsInvocationHandler<WebDriverScriptCommands> {
    private static final String PROP_PREFIX_SCRIPTING = "com.xceptance.xlt.scripting.";
    private final int commandRetryCount;
    private final boolean ignorePageLoadTimeouts;

    public WebDriverScriptCommandsInvocationHandler(WebDriverScriptCommands commands, Logger logger) {
        super(commands, logger);
        XltProperties props = XltProperties.getInstance();
        this.commandRetryCount = props.getProperty("com.xceptance.xlt.scripting.commandRetries", 1);
        this.ignorePageLoadTimeouts = props.getProperty("com.xceptance.xlt.scripting.ignorePageLoadTimeouts", false);
    }

    @Override
    protected Object doInvokeMethod(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            int retryCount = this.commandRetryCount;
            while (true) {
                try {
                    return super.doInvokeMethod(proxy, method, args);
                }
                catch (StaleElementReferenceException e) {
                    if (retryCount <= 0) {
                        throw e;
                    }
                    --retryCount;
                    this.getLogger().debug("Retry command because element was stale: " + e.getMessage());
                    continue;
                }
                break;
            }
        }
        catch (PageLoadTimeoutException | TimeoutException e) {
            if (this.ignorePageLoadTimeouts) {
                this.getLogger().debug("Ignoring timeout exception: " + String.valueOf(e));
                return null;
            }
            throw e;
        }
    }
}

