/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.htmlunit;

import com.xceptance.xlt.engine.scripting.ScriptException;
import com.xceptance.xlt.engine.scripting.TestContext;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitElementUtils;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitFinder;
import com.xceptance.xlt.engine.scripting.htmlunit.IllegalLocatorException;
import com.xceptance.xlt.engine.scripting.htmlunit.NoSuchElementException;
import com.xceptance.xlt.engine.scripting.util.ReplayUtils;
import com.xceptance.xlt.engine.scripting.util.TextMatchingUtils;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.htmlunit.ScriptResult;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomNodeList;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.host.html.HTMLElement;

public class ElementFinder {
    private final Strategy CSS_STRATEGY = new CssStrategy(this);
    private final Strategy DOM_STRATEGY = new DomStrategy(this);
    private final Strategy ID_STRATEGY = new IdStrategy();
    private final Strategy IDENTIFIER_STRATEGY = new IdentifierStrategy();
    private final Strategy IMPLICIT_STRATEGY = new ImplicitStrategy();
    private final Strategy LINK_STRATEGY = new LinkStrategy(this);
    private final Strategy NAME_STRATEGY = new NameStrategy(this);
    private final Strategy XPATH_STRATEGY = new XPathStrategy(this);
    private final Map<String, Strategy> strategies = new HashMap<String, Strategy>();
    private final boolean visibleOnly;

    ElementFinder(boolean visibleOnly) {
        this.visibleOnly = visibleOnly;
        this.strategies.put("css", this.CSS_STRATEGY);
        this.strategies.put("link", this.LINK_STRATEGY);
        this.strategies.put("dom", this.DOM_STRATEGY);
        this.strategies.put("xpath", this.XPATH_STRATEGY);
        this.strategies.put("name", this.NAME_STRATEGY);
        this.strategies.put("id", this.ID_STRATEGY);
        this.strategies.put("identifier", this.IDENTIFIER_STRATEGY);
        this.strategies.put("implicit", this.IMPLICIT_STRATEGY);
    }

    public HtmlElement find(HtmlPage page, String locator) {
        String value;
        String strategyName;
        Matcher m = HtmlUnitFinder.STRATEGY_PATTERN.matcher(locator);
        if (m.matches()) {
            strategyName = m.group(1);
            value = m.group(2);
        } else {
            strategyName = "implicit";
            value = locator;
        }
        Strategy strategy = this.strategies.get(strategyName);
        if (strategy == null) {
            throw new IllegalLocatorException("Unknown element locator strategy: " + strategyName);
        }
        long timeout = TestContext.getCurrent().getImplicitTimeout();
        long startTime = TimerUtils.get().getStartTime();
        do {
            HtmlElement e;
            if ((e = strategy.find(page, value)) != null) {
                return e;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                throw new NoSuchElementException("Interrupted while implicitly waiting for an element", ie);
            }
        } while (TimerUtils.get().getElapsedTime(startTime) < timeout);
        throw new NoSuchElementException("No element found for locator: " + locator);
    }

    List<HtmlElement> findAll(HtmlPage page, String locator) {
        String value;
        String strategyName;
        Matcher m = HtmlUnitFinder.STRATEGY_PATTERN.matcher(locator);
        if (m.matches()) {
            strategyName = m.group(1);
            value = m.group(2);
        } else {
            strategyName = "implicit";
            value = locator;
        }
        Strategy strategy = this.strategies.get(strategyName);
        if (strategy == null) {
            throw new IllegalLocatorException("Unknown element locator strategy: " + strategyName);
        }
        return strategy.findAll(page, value);
    }

    private class CssStrategy
    extends Strategy {
        private CssStrategy(ElementFinder elementFinder) {
        }

        @Override
        protected HtmlElement find(HtmlPage page, String cssSelector) {
            DomNodeList<DomNode> found = page.querySelectorAll(cssSelector);
            for (DomNode domNode : found) {
                HtmlElement e = (HtmlElement)domNode;
                if (!this.isAcceptable(e)) continue;
                return e;
            }
            return null;
        }

        @Override
        protected List<HtmlElement> findAll(HtmlPage page, String cssLocator) {
            ArrayList<HtmlElement> result = new ArrayList<HtmlElement>();
            DomNodeList<DomNode> found = page.querySelectorAll(cssLocator);
            for (DomNode domNode : found) {
                HtmlElement e = (HtmlElement)domNode;
                if (!this.isAcceptable(e)) continue;
                result.add(e);
            }
            return result;
        }
    }

    private abstract class Strategy {
        private Strategy() {
        }

        protected abstract HtmlElement find(HtmlPage var1, String var2);

        protected boolean isAcceptable(HtmlElement htmlElement) {
            if (ElementFinder.this.visibleOnly) {
                return HtmlUnitElementUtils.isVisible(htmlElement);
            }
            return true;
        }

        protected abstract List<HtmlElement> findAll(HtmlPage var1, String var2);
    }

    private class DomStrategy
    extends Strategy {
        private DomStrategy(ElementFinder elementFinder) {
        }

        @Override
        protected HtmlElement find(HtmlPage page, String domExpression) {
            HtmlElement e;
            Object o;
            if (!page.getWebClient().isJavaScriptEnabled()) {
                throw new ScriptException("JavaScript needs to be enabled when using DOM locator strategy");
            }
            ScriptResult r = page.executeJavaScript("(function(){return " + domExpression + "})();");
            if (!ScriptResult.isUndefined(r) && (o = r.getJavaScriptResult()) instanceof HTMLElement && this.isAcceptable(e = ((HTMLElement)o).getDomNodeOrDie())) {
                return e;
            }
            return null;
        }

        @Override
        protected List<HtmlElement> findAll(HtmlPage page, String domExpression) {
            ArrayList<HtmlElement> result = new ArrayList<HtmlElement>();
            HtmlElement e = this.find(page, domExpression);
            if (e != null) {
                result.add(e);
            }
            return result;
        }
    }

    private class IdStrategy
    extends Strategy {
        private IdStrategy() {
        }

        @Override
        protected HtmlElement find(HtmlPage page, String id) {
            return ElementFinder.this.XPATH_STRATEGY.find(page, this.toXPath(id));
        }

        @Override
        protected List<HtmlElement> findAll(HtmlPage page, String id) {
            return ElementFinder.this.XPATH_STRATEGY.findAll(page, this.toXPath(id));
        }

        private String toXPath(String id) {
            return "//*[@id='" + id + "']";
        }
    }

    private class IdentifierStrategy
    extends Strategy {
        private IdentifierStrategy() {
        }

        @Override
        protected HtmlElement find(HtmlPage page, String idOrName) {
            HtmlElement e = ElementFinder.this.ID_STRATEGY.find(page, idOrName);
            if (e == null) {
                e = ElementFinder.this.XPATH_STRATEGY.find(page, String.format("//*[@name='%s']", idOrName));
            }
            return e;
        }

        @Override
        protected List<HtmlElement> findAll(HtmlPage page, String idOrName) {
            ArrayList<HtmlElement> result = new ArrayList<HtmlElement>();
            result.addAll(ElementFinder.this.ID_STRATEGY.findAll(page, idOrName));
            result.addAll(ElementFinder.this.XPATH_STRATEGY.findAll(page, String.format("//*[@name='%s']", idOrName)));
            return result;
        }
    }

    private class ImplicitStrategy
    extends Strategy {
        private ImplicitStrategy() {
        }

        @Override
        protected HtmlElement find(HtmlPage page, String locator) {
            if (locator.startsWith("document.")) {
                return ElementFinder.this.DOM_STRATEGY.find(page, locator);
            }
            if (locator.startsWith("//")) {
                return ElementFinder.this.XPATH_STRATEGY.find(page, locator);
            }
            return ElementFinder.this.IDENTIFIER_STRATEGY.find(page, locator);
        }

        @Override
        protected List<HtmlElement> findAll(HtmlPage page, String locator) {
            if (locator.startsWith("document.")) {
                return ElementFinder.this.DOM_STRATEGY.findAll(page, locator);
            }
            if (locator.startsWith("//")) {
                return ElementFinder.this.XPATH_STRATEGY.findAll(page, locator);
            }
            return ElementFinder.this.IDENTIFIER_STRATEGY.findAll(page, locator);
        }
    }

    private class LinkStrategy
    extends Strategy {
        private LinkStrategy(ElementFinder elementFinder) {
        }

        @Override
        protected HtmlElement find(HtmlPage page, String linkText) {
            List<HtmlAnchor> anchors = page.getAnchors();
            for (HtmlAnchor a : anchors) {
                String text = HtmlUnitElementUtils.computeText(a);
                if (!this.isAcceptable(a) || !TextMatchingUtils.isAMatch(text, linkText, true, true)) continue;
                return a;
            }
            return null;
        }

        @Override
        protected List<HtmlElement> findAll(HtmlPage page, String linkText) {
            ArrayList<HtmlElement> result = new ArrayList<HtmlElement>();
            List<HtmlAnchor> anchors = page.getAnchors();
            for (HtmlAnchor a : anchors) {
                String text = HtmlUnitElementUtils.computeText(a);
                if (!this.isAcceptable(a) || !TextMatchingUtils.isAMatch(text, linkText, true, true)) continue;
                result.add(a);
            }
            return result;
        }
    }

    private class NameStrategy
    extends Strategy {
        private final String INDEX_KEY = "index";
        private final String NAME_KEY = "name";
        private final String VALUE_KEY = "value";

        private NameStrategy(ElementFinder elementFinder) {
        }

        @Override
        protected HtmlElement find(HtmlPage page, String name) {
            HtmlElement e;
            Map<String, String> attributes = ReplayUtils.parseAttributes(name);
            List found = page.getByXPath(String.format("//*[@name='%s']", attributes.get("name")));
            List<HtmlElement> elements = new ArrayList<HtmlElement>();
            for (Object o : found) {
                if (!(o instanceof HtmlElement) || !this.isAcceptable(e = (HtmlElement)o)) continue;
                elements.add(e);
            }
            if (attributes.containsKey("value")) {
                String value = attributes.get("value");
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    e = (HtmlElement)it.next();
                    String elementValue = e.getAttribute("value");
                    boolean keep = false;
                    if (value.length() > 0) {
                        if (value.equals(elementValue)) {
                            keep = true;
                        }
                    } else if (elementValue.length() == 0 && elementValue != DomElement.ATTRIBUTE_NOT_DEFINED) {
                        keep = true;
                    }
                    if (keep) continue;
                    it.remove();
                }
            }
            if (attributes.containsKey("index")) {
                String index = attributes.get("index");
                try {
                    int idx = Integer.parseInt(index);
                    if (idx >= 0 && idx < elements.size()) {
                        elements = Collections.singletonList((HtmlElement)elements.get(idx));
                    }
                }
                catch (Exception e2) {
                    return null;
                }
            }
            if (elements.isEmpty()) {
                return null;
            }
            return (HtmlElement)elements.get(0);
        }

        @Override
        protected List<HtmlElement> findAll(HtmlPage page, String name) {
            HtmlElement e;
            Map<String, String> attributes = ReplayUtils.parseAttributes(name);
            List found = page.getByXPath(String.format("//*[@name='%s']", attributes.get("name")));
            List<HtmlElement> elements = new ArrayList<HtmlElement>();
            for (Object o : found) {
                if (!(o instanceof HtmlElement) || !this.isAcceptable(e = (HtmlElement)o)) continue;
                elements.add(e);
            }
            if (attributes.containsKey("value")) {
                String value = attributes.get("value");
                Iterator it = elements.iterator();
                while (it.hasNext()) {
                    e = (HtmlElement)it.next();
                    String elementValue = e.getAttribute("value");
                    boolean keep = false;
                    if (value.length() > 0) {
                        if (value.equals(elementValue)) {
                            keep = true;
                        }
                    } else if (elementValue.length() == 0 && elementValue != DomElement.ATTRIBUTE_NOT_DEFINED) {
                        keep = true;
                    }
                    if (keep) continue;
                    it.remove();
                }
            }
            if (attributes.containsKey("index")) {
                String index = attributes.get("index");
                try {
                    int idx = Integer.parseInt(index);
                    if (idx >= 0 && idx < elements.size()) {
                        elements = Collections.singletonList(elements.get(idx));
                    }
                }
                catch (Exception e2) {
                    elements = Collections.emptyList();
                }
            }
            return elements;
        }
    }

    private class XPathStrategy
    extends Strategy {
        private XPathStrategy(ElementFinder elementFinder) {
        }

        @Override
        protected HtmlElement find(HtmlPage page, String xpath) {
            List found = page.getByXPath(xpath);
            for (Object o : found) {
                HtmlElement e;
                if (!(o instanceof HtmlElement) || !this.isAcceptable(e = (HtmlElement)o)) continue;
                return e;
            }
            return null;
        }

        @Override
        protected List<HtmlElement> findAll(HtmlPage page, String xpath) {
            ArrayList<HtmlElement> result = new ArrayList<HtmlElement>();
            List found = page.getByXPath(xpath);
            for (Object o : found) {
                HtmlElement e;
                if (!(o instanceof HtmlElement) || !this.isAcceptable(e = (HtmlElement)o)) continue;
                result.add(e);
            }
            return result;
        }
    }
}

