/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.docgen;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.ProductInformation;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.engine.scripting.MacroProcessor;
import com.xceptance.xlt.engine.scripting.ScriptException;
import com.xceptance.xlt.engine.scripting.TestDataUtils;
import com.xceptance.xlt.engine.scripting.docgen.BaseInfo;
import com.xceptance.xlt.engine.scripting.docgen.JavaModuleInfo;
import com.xceptance.xlt.engine.scripting.docgen.ModuleScriptInfo;
import com.xceptance.xlt.engine.scripting.docgen.PackageInfo;
import com.xceptance.xlt.engine.scripting.docgen.ScriptDocGeneratorConfiguration;
import com.xceptance.xlt.engine.scripting.docgen.ScriptInfo;
import com.xceptance.xlt.engine.scripting.docgen.Step;
import com.xceptance.xlt.engine.scripting.docgen.TestScriptInfo;
import com.xceptance.xlt.engine.scripting.docgen.TestSuiteInfo;
import com.xceptance.xlt.engine.util.ScriptingUtils;
import com.xceptance.xlt.report.util.TaskManager;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ScriptDocGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptDocGenerator.class);
    private static final Pattern VAR_EXPR_PATTERN = Pattern.compile("(?<!\\$)\\$\\{[^\\s{}$]+\\}");
    private static final String SUITE_DESCRIPTOR_FILENAME = "suite.xml";
    private final Configuration freeMarkerConfig;
    private final File outputDir;
    private final File scriptDir;
    private final String scriptDirPath;
    private PackageTree pkgTree;
    private TestSuiteInfo suiteInfo;
    private List<Step> worklist;
    private Set<String> calls;
    private final ScriptDocGeneratorConfiguration config;

    public ScriptDocGenerator(File testSuiteDirectory, File outputDirectory, Properties commandLineProperties) throws IOException {
        ParameterCheckUtils.isNotNull(testSuiteDirectory, "testSuiteDirectory");
        ParameterCheckUtils.isNotNull(outputDirectory, "outputDirectory");
        if (!(testSuiteDirectory.exists() && testSuiteDirectory.canRead() && testSuiteDirectory.isDirectory())) {
            throw new IllegalArgumentException("Test suite path '" + testSuiteDirectory.getAbsolutePath() + "' does not denote an existent and readable directory.");
        }
        File scriptsDirectory = new File(testSuiteDirectory, "scripts");
        if (!scriptsDirectory.canRead()) {
            throw new IllegalArgumentException("Failed to access directory 'scripts' in test suite '" + testSuiteDirectory.getAbsolutePath() + "'. Please make sure it exists and can be read.");
        }
        if (outputDirectory.exists()) {
            if (!outputDirectory.isDirectory()) {
                throw new IllegalArgumentException("Cannot write to '" + outputDirectory.getAbsolutePath() + "' because it already exists and is not a directory.");
            }
            if (!outputDirectory.canWrite()) {
                throw new IllegalArgumentException("Directory '" + outputDirectory.getAbsolutePath() + "' already exists and is read-only.");
            }
        }
        this.outputDir = outputDirectory;
        this.scriptDir = scriptsDirectory;
        this.scriptDirPath = this.scriptDir.getAbsolutePath();
        this.config = new ScriptDocGeneratorConfiguration(commandLineProperties);
        this.freeMarkerConfig = new Configuration(Configuration.VERSION_2_3_21);
        this.freeMarkerConfig.setDefaultEncoding("UTF-8");
        this.freeMarkerConfig.setDirectoryForTemplateLoading(this.config.getTemplateDir());
        this.freeMarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    public void run() throws Exception {
        File suitePath = this.scriptDir.getParentFile().getCanonicalFile();
        this.suiteInfo = new TestSuiteInfo(suitePath);
        PackageInfo pkgInfo = new PackageInfo();
        pkgInfo.setTestData(TestDataUtils.getPackageTestData(null, this.scriptDir.getAbsolutePath(), pkgInfo.name));
        this.suiteInfo.addPackage(pkgInfo);
        this.pkgTree = new PackageTree(pkgInfo);
        final Pattern scriptFilePattern = Pattern.compile("^.+(?<!_data(sets)?)\\.xml$");
        File[] allFiles = com.xceptance.common.io.FileUtils.listFiles(this.scriptDir, true, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String pkgName = StringUtils.defaultString((String)ScriptDocGenerator.this.getPkgName(dir.getAbsolutePath()));
                if (pkgName.length() > 0) {
                    ScriptDocGenerator.this._addPackageToTree(pkgName);
                }
                return scriptFilePattern.matcher(name).matches();
            }
        });
        this.worklist = new LinkedList<Step>();
        this.calls = new HashSet<String>();
        ArrayList<File> failures = new ArrayList<File>();
        for (File f : allFiles) {
            try {
                BaseInfo info = this.parseScriptFile(f);
                if (info == null) continue;
                this.suiteInfo.addScript(info);
            }
            catch (Exception e) {
                LOG.error("Failed to parse script", (Throwable)e);
                failures.add(f);
            }
        }
        this.readInfoFromSuiteFile(suitePath);
        this.postProcess();
        this.dumpToDisk();
        this.pkgTree = null;
        if (!failures.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following files could not be parsed successfully:\n");
            for (File f : failures) {
                sb.append(" - ").append(f.getAbsolutePath()).append('\n');
            }
            sb.append("\nPlease see the log for details.");
            throw new ScriptException(sb.toString());
        }
    }

    private void _addPackageToTree(String pkgName) {
        if (this.pkgTree.getNodeForName(pkgName) == null) {
            String superPkgName = ScriptingUtils.getParentPackageName(pkgName);
            PackageTreeNode parent = this.pkgTree.getNodeForName(superPkgName);
            if (parent == null) {
                this._addPackageToTree(superPkgName);
                parent = this.pkgTree.getNodeForName(superPkgName);
            }
            PackageInfo info = new PackageInfo(pkgName);
            info.setTestData(TestDataUtils.getPackageTestData(null, this.scriptDir.getAbsolutePath(), info.name));
            parent.addChildPackage(info);
            this.suiteInfo.addPackage(info);
        }
    }

    private void postProcess() {
        block0: while (!this.worklist.isEmpty()) {
            Step step = this.worklist.remove(0);
            String stepName = step.getName();
            String packageName = ScriptingUtils.getScriptPackage(stepName);
            PackageTreeNode pkgNode = this.pkgTree.getNodeForName(packageName);
            if (pkgNode == null) {
                LOG.error("No such script package '" + packageName + "'");
                continue;
            }
            if (pkgNode._info == null) {
                LOG.error("Script package '" + packageName + "' was found but no information about it.");
                continue;
            }
            for (BaseInfo info : pkgNode._info.getModules()) {
                if (!info.name.equals(stepName)) continue;
                step.setDescription(info.description);
                continue block0;
            }
        }
        block2: for (String call : this.calls) {
            PackageTreeNode node = this.pkgTree.getNodeForName(ScriptingUtils.getScriptPackage(call));
            if (node == null || node._info == null) continue;
            for (BaseInfo info : node._info.getModules()) {
                if (!info.name.equals(call)) continue;
                if (info instanceof ModuleScriptInfo) {
                    ((ModuleScriptInfo)info).setCalled(true);
                    continue block2;
                }
                if (!(info instanceof JavaModuleInfo)) continue block2;
                ((JavaModuleInfo)info).setCalled(true);
                continue block2;
            }
        }
    }

    private String getPkgName(String absolutePath) {
        String s = StringUtils.substringAfter((String)absolutePath, (String)this.scriptDirPath);
        return (s = s.replace('\\', '/').replace('/', '.')).startsWith(".") ? s.substring(1) : s;
    }

    private void dumpToDisk() throws Exception {
        FileUtils.forceMkdir((File)this.outputDir);
        this.processTemplates();
        com.xceptance.common.io.FileUtils.copyDirectory(this.config.getResourceDir(), this.outputDir, true);
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outputDir, "doc.xml")), "UTF-8");){
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xstream.autodetectAnnotations(true);
            xstream.setMode(1001);
            xstream.toXML((Object)this.suiteInfo, (Writer)osw);
        }
    }

    private void processTemplates() throws InterruptedException {
        final HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("suite", this.suiteInfo);
        dataModel.put("xlt_version", ProductInformation.getProductInformation().getVersion());
        final List<Throwable> failures = Collections.synchronizedList(new ArrayList());
        TaskManager taskMgr = TaskManager.getInstance();
        for (final Map.Entry<String, String> entry : this.config.getTemplates().entrySet()) {
            taskMgr.addTask(new Runnable(){

                @Override
                public void run() {
                    try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(ScriptDocGenerator.this.outputDir, (String)entry.getValue())), "UTF-8");){
                        Template template = ScriptDocGenerator.this.freeMarkerConfig.getTemplate((String)entry.getKey());
                        template.process((Object)dataModel, (Writer)osw);
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to process template", t);
                        failures.add(t);
                    }
                }
            });
        }
        taskMgr.waitForAllTasksToComplete();
        if (!failures.isEmpty()) {
            StringBuilder sb = new StringBuilder("Template processing has failed:");
            for (Throwable t : failures) {
                sb.append("\n - ").append(t.getMessage());
            }
            throw new ScriptException(sb.toString());
        }
    }

    private void readInfoFromSuiteFile(File pathToSuite) throws Exception {
        String schemaFileName = "scriptdeveloper-project.xsd";
        File descriptorFile = new File(pathToSuite, SUITE_DESCRIPTOR_FILENAME);
        if (descriptorFile.exists() && descriptorFile.isFile() && descriptorFile.canRead()) {
            LOG.info("Parsing suite descriptor file: " + String.valueOf(descriptorFile));
            Document document = this.parseXMLFile(descriptorFile, TestDataUtils.class.getResource("scriptdeveloper-project.xsd"));
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (!(n instanceof Element)) continue;
                String tagName = ((Element)n).getTagName();
                String content = n.getTextContent();
                if ("description".equals(tagName)) {
                    this.suiteInfo.description = content;
                    continue;
                }
                if ("name".equals(tagName)) {
                    this.suiteInfo.name = content;
                    continue;
                }
                LOG.info("Don't know how to handle '" + tagName + "' elements");
            }
        }
    }

    private BaseInfo parseScriptFile(File scriptFile) throws Exception {
        String schemaFileName = "xlt-script.xsd";
        LOG.info("Parsing script file: " + String.valueOf(scriptFile));
        String content = FileUtils.readFileToString((File)scriptFile, (String)"UTF-8");
        String rootElementTagName = RegExUtils.getFirstMatch(content, "<\\?xml.+?\\?>\\s*<(\\S+)[^>]*?>", 1);
        if (rootElementTagName == null) {
            throw new ScriptException("Failed to parse document element tag name of script file '" + String.valueOf(scriptFile) + "'");
        }
        Document document = this.parseXMLFile(scriptFile, TestDataUtils.class.getResource("xlt-script.xsd"));
        Element rootElement = document.getDocumentElement();
        String rootElemName = rootElement.getTagName();
        BaseInfo info = null;
        if ("javamodule".equals(rootElemName)) {
            info = this.processJavaModule(rootElement, scriptFile);
        } else if ("testcase".equals(rootElemName)) {
            info = this.processTestCase(rootElement, scriptFile);
        } else if ("scriptmodule".equals(rootElemName)) {
            info = this.processModule(rootElement, scriptFile);
        }
        return info;
    }

    private ScriptInfo processModule(Element rootElement, File scriptFile) throws Exception {
        Object name = StringUtils.substringBefore((String)scriptFile.getName(), (String)".xml");
        String pkgName = this.getPkgName(scriptFile.getParentFile().getAbsolutePath());
        if (StringUtils.isNotEmpty((CharSequence)pkgName)) {
            name = pkgName + "." + (String)name;
        }
        ModuleScriptInfo info = rootElement.hasAttribute("id") ? new ModuleScriptInfo((String)name, rootElement.getAttribute("id")) : new ModuleScriptInfo((String)name);
        return this.processCommandScript(rootElement, info, scriptFile);
    }

    private ScriptInfo processTestCase(Element rootElement, File scriptFile) throws Exception {
        Object name = StringUtils.substringBefore((String)scriptFile.getName(), (String)".xml");
        String pkgName = this.getPkgName(scriptFile.getParentFile().getAbsolutePath());
        if (StringUtils.isNotEmpty((CharSequence)pkgName)) {
            name = pkgName + "." + (String)name;
        }
        String baseURL = rootElement.getAttribute("baseURL");
        boolean isDisabled = "true".equals(rootElement.getAttribute("disabled"));
        TestScriptInfo info = rootElement.hasAttribute("id") ? new TestScriptInfo((String)name, rootElement.getAttribute("id")) : new TestScriptInfo((String)name);
        info.disabled = isDisabled;
        info.baseUrl = baseURL;
        return this.processCommandScript(rootElement, info, scriptFile);
    }

    private JavaModuleInfo processJavaModule(Element rootElement, File scriptFile) throws Exception {
        Object name = StringUtils.substringBefore((String)scriptFile.getName(), (String)".xml");
        String pkgName = this.getPkgName(scriptFile.getParentFile().getAbsolutePath());
        if (StringUtils.isNotEmpty((CharSequence)pkgName)) {
            name = pkgName + "." + (String)name;
        }
        String implClassName = rootElement.getAttribute("class");
        JavaModuleInfo info = rootElement.hasAttribute("id") ? new JavaModuleInfo((String)name, rootElement.getAttribute("id"), implClassName) : new JavaModuleInfo((String)name, implClassName);
        NodeList children = rootElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            String tagName = e.getTagName();
            if ("tags".equals(tagName)) {
                info.tags = n.getTextContent();
                continue;
            }
            if ("description".equals(tagName)) {
                info.description = n.getTextContent();
                continue;
            }
            if (!"parameter".equals(tagName)) continue;
            info.addParameter(e.getAttribute("name"), e.getAttribute("desc"));
        }
        return info;
    }

    private ScriptInfo processCommandScript(Element rootElement, ScriptInfo info, File scriptFile) {
        boolean isModule = info instanceof ModuleScriptInfo;
        PackageTreeNode pkgNode = this.pkgTree.getNodeForName(ScriptingUtils.getScriptPackage(info.name));
        info.setTestData(TestDataUtils.getTestData(scriptFile));
        NodeList children = rootElement.getChildNodes();
        block24: for (int i = 0; i < children.getLength(); ++i) {
            String tagName;
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            switch (tagName = e.getTagName()) {
                case "description": {
                    info.description = e.getTextContent();
                    continue block24;
                }
                case "tags": {
                    info.tags = e.getTextContent();
                    continue block24;
                }
                case "parameter": {
                    if (!isModule) continue block24;
                    ((ModuleScriptInfo)info).addParameter(e.getAttribute("name"), e.getAttribute("desc"));
                    continue block24;
                }
                case "module": 
                case "action": 
                case "command": {
                    this.handleScriptElement(e, info, pkgNode, false);
                    continue block24;
                }
                case "postSteps": {
                    if (isModule) {
                        throw new ScriptException("Only test case scripts can have post-steps.");
                    }
                    NodeList postStepItems = e.getChildNodes();
                    block25: for (int j = 0; j < postStepItems.getLength(); ++j) {
                        Node postStepItem = postStepItems.item(j);
                        if (!(postStepItem instanceof Element)) continue;
                        Element postStep = (Element)postStepItem;
                        switch (postStep.getTagName()) {
                            case "module": 
                            case "action": 
                            case "command": {
                                this.handleScriptElement(postStep, info, pkgNode, true);
                                continue block25;
                            }
                        }
                    }
                    continue block24;
                }
            }
        }
        return info;
    }

    private void handleScriptElement(Element scriptElement, ScriptInfo info, PackageTreeNode pkgNode, boolean insidePostSteps) {
        String tagName = scriptElement.getTagName();
        boolean isDisabled = "true".equals(scriptElement.getAttribute("disabled"));
        String haystack = null;
        if ("module".equals(tagName)) {
            stepName = scriptElement.getAttribute("name");
            comment = null;
            String conditionExpression = null;
            boolean conditionDisabled = false;
            if (isDisabled) {
                info.addCall(stepName);
            }
            NodeList moduleChilds = scriptElement.getChildNodes();
            for (int j = 0; j < moduleChilds.getLength(); ++j) {
                Node moduleChild = moduleChilds.item(j);
                if (!(moduleChild instanceof Element)) continue;
                Element _el = (Element)moduleChild;
                String moduleChildName = _el.getTagName();
                if ("parameter".equals(moduleChildName)) {
                    if (isDisabled) continue;
                    haystack = StringUtils.defaultString((String)haystack) + _el.getAttribute("value");
                    continue;
                }
                if ("comment".equals(moduleChildName)) {
                    comment = _el.getTextContent();
                    continue;
                }
                if (!"condition".equals(moduleChildName)) continue;
                conditionExpression = _el.getTextContent();
                conditionDisabled = Boolean.valueOf(_el.getAttribute("disabled"));
                if (conditionDisabled) continue;
                haystack = StringUtils.defaultString((String)haystack) + conditionExpression;
            }
            Step step = new Step(stepName, comment, isDisabled, true, conditionDisabled, conditionExpression);
            if (insidePostSteps) {
                ((TestScriptInfo)info).addPostStep(step);
            } else {
                info.addStep(step);
            }
            if (StringUtils.isBlank(comment)) {
                this.worklist.add(step);
            }
            this.calls.add(stepName);
        } else if ("command".equals(tagName)) {
            if (!isDisabled) {
                NodeList valueElements;
                String value;
                NodeList targetElements;
                String target;
                String cmdName = scriptElement.getAttribute("name");
                String string = target = scriptElement.hasAttribute("target") ? scriptElement.getAttribute("target") : null;
                if (target == null && (targetElements = scriptElement.getElementsByTagName("target")).getLength() > 0) {
                    target = targetElements.item(0).getTextContent();
                }
                String string2 = value = scriptElement.hasAttribute("value") ? scriptElement.getAttribute("value") : null;
                if (value == null && (valueElements = scriptElement.getElementsByTagName("value")).getLength() > 0) {
                    value = valueElements.item(0).getTextContent();
                }
                if (cmdName.startsWith("store") && StringUtils.isNotBlank((CharSequence)value)) {
                    info.addStore(value);
                }
                haystack = StringUtils.defaultString((String)target) + StringUtils.defaultString((String)value);
            }
        } else if ("action".equals(tagName)) {
            stepName = scriptElement.getAttribute("name");
            comment = null;
            NodeList stepChildren = scriptElement.getChildNodes();
            for (int j = 0; j < stepChildren.getLength(); ++j) {
                Node stepChild = stepChildren.item(j);
                if (!(stepChild instanceof Element) || !"comment".equals(((Element)stepChild).getTagName())) continue;
                comment = stepChild.getTextContent();
                break;
            }
            Step step = new Step(stepName, comment, isDisabled);
            if (insidePostSteps) {
                ((TestScriptInfo)info).addPostStep(step);
            } else {
                info.addStep(step);
            }
        }
        if (StringUtils.isNotBlank(haystack)) {
            for (String match : RegExUtils.getAllMatches(haystack, VAR_EXPR_PATTERN)) {
                String varName = match.substring(2, match.length() - 1);
                if (info.getTestData().containsKey(varName) || info.hasStore(varName) || MacroProcessor.getInstance().isMacro(varName)) continue;
                Map<String, String> pkgData = pkgNode.getEffectiveTestData();
                String value = pkgData.get(varName);
                if (value == null) {
                    value = this.suiteInfo.getGlobalTestData().get(varName);
                }
                info.addExternalParam(varName, value);
            }
        }
    }

    private Document parseXMLFile(File xmlFile, URL schemaLocation) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaLocation);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        saxFactory.setSchema(schema);
        SAXParser saxParser = saxFactory.newSAXParser();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        DefaultHandler handler = new DefaultHandler(document);
        saxParser.parse(xmlFile, (org.xml.sax.helpers.DefaultHandler)handler);
        if (handler.errors > 0) {
            throw new SAXException(String.format("Parsing the XML file '%s' produced %d error(s) and %d warning(s)", xmlFile.toString(), handler.errors, handler.warnings));
        }
        if (handler.warnings > 0 && LOG.isWarnEnabled()) {
            LOG.warn(String.format("Parsing the XML file '%s' produced %d warning(s)", xmlFile.toString(), handler.warnings));
        }
        return document;
    }

    private static class PackageTree {
        private final PackageTreeNode _root;

        private PackageTree(PackageInfo rootInfo) {
            this._root = new PackageTreeNode(rootInfo);
        }

        private PackageTreeNode getNodeForName(String packageName) {
            String name = StringUtils.defaultString((String)packageName);
            PackageTreeNode node = this._root;
            if (node._info.name.equals(name)) {
                return node;
            }
            node = this.getNodeForName(ScriptingUtils.getParentPackageName(name));
            if (node != null) {
                for (PackageTreeNode c : node._children) {
                    if (!c._info.name.equals(packageName)) continue;
                    return c;
                }
            }
            return null;
        }
    }

    private static class PackageTreeNode {
        private final PackageTreeNode _parent;
        private final List<PackageTreeNode> _children = new ArrayList<PackageTreeNode>();
        private final PackageInfo _info;

        private PackageTreeNode(PackageInfo info) {
            this._parent = null;
            this._info = info;
        }

        private PackageTreeNode(PackageTreeNode parentNode, PackageInfo info) {
            this._parent = parentNode;
            this._info = info;
        }

        void addChildPackage(PackageInfo info) {
            this._children.add(new PackageTreeNode(this, info));
        }

        Map<String, String> getEffectiveTestData() {
            Map<String, String> data = this._parent != null ? this._parent.getEffectiveTestData() : new HashMap<String, String>();
            data.putAll(this._info.getTestData());
            return data;
        }
    }

    private static class DefaultHandler
    extends org.xml.sax.helpers.DefaultHandler {
        private final Document doc;
        final Stack<Element> elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();
        private int errors;
        private int warnings;

        private DefaultHandler(Document document) {
            this.doc = document;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.addTextIfNeeded();
            Element element = this.doc.createElement(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            this.elementStack.push(element);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.addTextIfNeeded();
            Element closedElement = this.elementStack.pop();
            if (this.elementStack.isEmpty()) {
                this.doc.appendChild(closedElement);
            } else {
                Element parentElement = this.elementStack.peek();
                parentElement.appendChild(closedElement);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textBuffer.append(ch, start, length);
        }

        private void addTextIfNeeded() {
            if (this.textBuffer.length() > 0) {
                Element element = this.elementStack.peek();
                Text textNode = this.doc.createTextNode(this.textBuffer.toString());
                element.appendChild(textNode);
                this.textBuffer.delete(0, this.textBuffer.length());
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOG.error(this.report(exception));
            ++this.errors;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOG.error(this.report(exception));
            ++this.errors;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOG.warn(this.report(exception));
            ++this.warnings;
        }

        private String report(SAXParseException exception) {
            return String.format("### %d:%d - %s\n", exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage());
        }
    }
}

