/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.docgen;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.xceptance.xlt.engine.scripting.docgen.BaseInfo;
import com.xceptance.xlt.engine.scripting.docgen.JavaModuleInfo;
import com.xceptance.xlt.engine.scripting.docgen.ModuleScriptInfo;
import com.xceptance.xlt.engine.scripting.docgen.TestScriptInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="package")
public class PackageInfo
implements Comparable<PackageInfo> {
    final String name;
    @XStreamAlias(value="test-data")
    private Map<String, String> testData;
    @XStreamOmitField
    private final Set<TestScriptInfo> tests = new HashSet<TestScriptInfo>();
    @XStreamOmitField
    private final Set<ModuleScriptInfo> scriptModules = new HashSet<ModuleScriptInfo>();
    @XStreamOmitField
    private final Set<JavaModuleInfo> javaModules = new HashSet<JavaModuleInfo>();

    PackageInfo() {
        this(null);
    }

    PackageInfo(String pkgName) {
        this.name = StringUtils.defaultString((String)pkgName);
    }

    public boolean isDefaultPackage() {
        return "".equals(this.name);
    }

    void setTestData(Map<String, String> data) {
        this.testData = data == null ? Collections.emptyMap() : new TreeMap<String, String>(data);
    }

    public Map<String, String> getTestData() {
        return this.testData;
    }

    public String getName() {
        return this.name;
    }

    public void addScript(BaseInfo script) {
        if (script instanceof TestScriptInfo) {
            this.tests.add((TestScriptInfo)script);
        } else if (script instanceof ModuleScriptInfo) {
            this.scriptModules.add((ModuleScriptInfo)script);
        } else if (script instanceof JavaModuleInfo) {
            this.javaModules.add((JavaModuleInfo)script);
        } else {
            throw new IllegalArgumentException("Don't know how to handle class: " + this.getClass().getCanonicalName());
        }
    }

    public Set<TestScriptInfo> getTests() {
        return Collections.unmodifiableSet(this.tests);
    }

    public Set<ModuleScriptInfo> getScriptModules() {
        return Collections.unmodifiableSet(this.scriptModules);
    }

    public Set<JavaModuleInfo> getJavaModules() {
        return Collections.unmodifiableSet(this.javaModules);
    }

    @Override
    public int compareTo(PackageInfo o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public Set<BaseInfo> getModules() {
        HashSet<BaseInfo> s = new HashSet<BaseInfo>();
        s.addAll(this.scriptModules);
        s.addAll(this.javaModules);
        return Collections.unmodifiableSet(s);
    }

    public int size() {
        return this.tests.size() + this.scriptModules.size() + this.javaModules.size();
    }
}

