/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.docgen;

import com.xceptance.xlt.engine.scripting.ScriptException;
import com.xceptance.xlt.engine.scripting.docgen.ScriptDocGenerator;
import com.xceptance.xlt.report.util.ReportUtils;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public final class Main {
    private static final String OUTPUT_OPTION = "o";
    private static final String PROG_NAME = "create_scriptdoc";
    private static final String PROPERTY_DEFINITION_OPTION = "D";

    public static void main(String[] args) throws Exception {
        File outputDir;
        Options opts = Main.makeOptions();
        CommandLine cli = null;
        try {
            cli = new DefaultParser().parse(opts, args);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            Main.printUsageAndExit(opts);
        }
        String outputDirName = cli.getOptionValue(OUTPUT_OPTION);
        String[] remainingArgs = cli.getArgs();
        if (remainingArgs.length == 0) {
            System.err.println("Please specify the path to your test suite.");
            Main.printUsageAndExit(opts);
        } else if (remainingArgs.length > 1) {
            System.err.println("Too many arguments.");
            Main.printUsageAndExit(opts);
        }
        File suiteDir = new File(remainingArgs[0]);
        if (cli.hasOption(OUTPUT_OPTION)) {
            if (StringUtils.isBlank((CharSequence)outputDirName)) {
                System.err.println("Please specify an output directory or omit option '-o'.");
                Main.printUsageAndExit(opts);
            }
            outputDir = new File(outputDirName);
        } else {
            outputDir = new File(suiteDir, "scriptdoc");
        }
        ScriptDocGenerator docGen = null;
        try {
            docGen = new ScriptDocGenerator(suiteDir, outputDir, cli.getOptionProperties(PROPERTY_DEFINITION_OPTION));
        }
        catch (Throwable t) {
            Main.handleFailure(t, opts);
        }
        System.out.print("Generating Script-Doc ... ");
        long startTime = System.currentTimeMillis();
        try {
            docGen.run();
        }
        catch (Throwable t) {
            System.out.println("FAILED!\n");
            Main.handleFailure(t, opts);
        }
        long endTime = System.currentTimeMillis();
        File indexFile = new File(outputDir, "index.html");
        System.out.printf("OK [took %d ms]\nURL: %s\n\n", endTime - startTime, ReportUtils.toString(indexFile));
        System.exit(0);
    }

    private static void handleFailure(Throwable t, Options opts) {
        System.err.println(t.getMessage());
        if (t instanceof ScriptException) {
            System.exit(1);
        }
        Main.printUsageAndExit(opts);
    }

    private static void printUsageAndExit(Options opts) {
        System.out.println();
        String progName = PROG_NAME + Main.getExtension();
        new HelpFormatter().printHelp(progName + " [-o <dir>] <test_suite>", opts);
        System.out.println();
        System.exit(2);
    }

    private static String getExtension() {
        return SystemUtils.IS_OS_WINDOWS ? ".cmd" : ".sh";
    }

    private static Options makeOptions() {
        Options opts = new Options();
        Option propertyDefinition = new Option(PROPERTY_DEFINITION_OPTION, true, "override a property with the given value");
        propertyDefinition.setValueSeparator('=');
        propertyDefinition.setArgName("property=value");
        propertyDefinition.setArgs(2);
        opts.addOption(propertyDefinition);
        Option o = new Option(OUTPUT_OPTION, "output-directory", true, "the output directory");
        o.setArgName("dir");
        opts.addOption(o);
        return opts;
    }
}

