/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.scripting.WebDriverCustomModule;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.scripting.Action;
import com.xceptance.xlt.engine.scripting.CallCondition;
import com.xceptance.xlt.engine.scripting.CodeComment;
import com.xceptance.xlt.engine.scripting.Command;
import com.xceptance.xlt.engine.scripting.CommandScript;
import com.xceptance.xlt.engine.scripting.JavaModule;
import com.xceptance.xlt.engine.scripting.LineNumberType;
import com.xceptance.xlt.engine.scripting.ModuleCall;
import com.xceptance.xlt.engine.scripting.Script;
import com.xceptance.xlt.engine.scripting.ScriptElement;
import com.xceptance.xlt.engine.scripting.ScriptException;
import com.xceptance.xlt.engine.scripting.TestCase;
import com.xceptance.xlt.engine.scripting.TestContext;
import com.xceptance.xlt.engine.scripting.WebDriverCommandProcessor;
import com.xceptance.xlt.engine.scripting.util.AbstractCommandAdapter;
import com.xceptance.xlt.engine.scripting.util.ReplayUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;

public abstract class AbstractScriptInterpreter {
    private static final Logger LOG = AbstractCommandAdapter.LOGGER;
    private static final Map<String, Script> moduleCache = new HashMap<String, Script>();
    private static final Map<String, Script> testCaseCache = new HashMap<String, Script>();
    private WebDriverCommandProcessor commandProcessor;
    private boolean noActionStartedYet = true;
    private final WebDriver webDriver;
    private final LineNumberType linenumberType;

    protected AbstractScriptInterpreter(WebDriver webDriver) {
        this.webDriver = webDriver;
        String linenumber_tmp = XltProperties.getInstance().getProperty("com.xceptance.xlt.scripting.lineNumberType");
        LineNumberType type_tmp = null;
        if (StringUtils.isNotBlank((CharSequence)linenumber_tmp)) {
            try {
                type_tmp = LineNumberType.get(linenumber_tmp);
            }
            catch (Exception e) {
                type_tmp = LineNumberType.scriptdeveloper;
            }
            this.linenumberType = type_tmp;
        } else {
            this.linenumberType = LineNumberType.scriptdeveloper;
        }
    }

    public void close() {
        if (this.commandProcessor != null) {
            this.commandProcessor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(String scriptName) throws Exception {
        TestCase testCaseScript = (TestCase)this.getTestCaseScript(scriptName);
        if (testCaseScript.isDisabled()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(String.format("Script test case '%s' is disabled but hasn't been annotated with @org.junit.Ignore", scriptName));
            }
            return;
        }
        TestContext.getCurrent().pushScope(testCaseScript);
        String baseUrl = TestContext.getCurrent().getBaseUrl();
        if (StringUtils.isBlank((CharSequence)baseUrl) && !StringUtils.isBlank((CharSequence)(baseUrl = testCaseScript.getBaseUrl()))) {
            TestContext.getCurrent().setBaseUrl(baseUrl);
        }
        AtomicInteger sdLinenumber = new AtomicInteger();
        try {
            Throwable throwable = null;
            try {
                this.executeScript(testCaseScript, null, sdLinenumber);
            }
            catch (Throwable t) {
                throwable = t;
            }
            try {
                this.executePostSteps(testCaseScript, sdLinenumber);
            }
            catch (Throwable t2) {
                if (throwable != null) {
                    throwable.addSuppressed(t2);
                }
                throwable = t2;
            }
            if (throwable != null) {
                if (!(throwable instanceof Exception)) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    Throwable[] suppressed = throwable.getSuppressed();
                    StackTraceElement[] trace = throwable.getStackTrace();
                    throwable = new ScriptException(throwable.getMessage(), throwable.getCause());
                    if (trace != null) {
                        throwable.setStackTrace(trace);
                    }
                    if (suppressed != null) {
                        for (Throwable suppressedThrowable : suppressed) {
                            throwable.addSuppressed(suppressedThrowable);
                        }
                    }
                }
                throw (Exception)throwable;
            }
        }
        finally {
            this.finishCurrentAction();
            TestContext.getCurrent().popScope();
        }
    }

    protected abstract Script parseModuleScriptFile(String var1) throws Exception;

    protected abstract Script parseTestCaseScriptFile(String var1) throws Exception;

    private WebDriverCommandProcessor getCommandProcessor() {
        if (this.commandProcessor == null) {
            this.commandProcessor = new WebDriverCommandProcessor(this.webDriver);
        }
        return this.commandProcessor;
    }

    private void executeScript(Script script, Map<String, String> parameters, AtomicInteger sdLinenumber) throws Exception {
        HashMap<String, String> params;
        int baseLineNumber = sdLinenumber.get();
        if (parameters != null) {
            params = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                params.put(entry.getKey(), this.resolve(entry.getValue()));
            }
        } else {
            params = null;
        }
        if (script instanceof CommandScript) {
            CommandScript commandScript = (CommandScript)script;
            for (ScriptElement scriptElement : commandScript.getScriptElements(params)) {
                this.executeScriptElement(commandScript, scriptElement, baseLineNumber, sdLinenumber);
            }
        } else if (script instanceof JavaModule) {
            JavaModule javaModule = (JavaModule)script;
            String string = javaModule.getClassName();
            try {
                Class<?> javaModuleClass = Class.forName(string);
                WebDriverCustomModule javaModuleObject = (WebDriverCustomModule)javaModuleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Executing Java module: %s", string));
                }
                List<String> formalParameters = javaModule.getParameterNames();
                String[] arguments = new String[formalParameters.size()];
                for (int i = 0; i < arguments.length; ++i) {
                    arguments[i] = params.get(formalParameters.get(i));
                }
                javaModuleObject.execute(this.webDriver, arguments);
            }
            catch (Exception e) {
                throw new ScriptException("Failed to execute Java module: " + string, e);
            }
        } else {
            throw new ScriptException("Don't know how to execute script: " + String.valueOf(script));
        }
    }

    private void executeScriptElement(CommandScript script, ScriptElement scriptElement, int baseLineNumber, AtomicInteger sdLinenumber) throws Exception {
        int lineNumber = sdLinenumber.incrementAndGet();
        if (scriptElement.isDisabled()) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Skipping disabled script element: %s", scriptElement));
            }
            if (scriptElement instanceof ModuleCall) {
                sdLinenumber.set(lineNumber + this.getModuleScript(scriptElement.getName()).getSize());
            }
        } else {
            String name = scriptElement.getName();
            if (scriptElement instanceof Command) {
                if (this.noActionStartedYet) {
                    Session.getCurrent().startAction("OpenStartPage");
                    this.noActionStartedYet = false;
                }
                Command command = (Command)scriptElement;
                try {
                    this.doCommand(command);
                }
                catch (Throwable t) {
                    int linenumber = this.linenumberType.equals((Object)LineNumberType.file) ? scriptElement.getLineNumber() : lineNumber - baseLineNumber;
                    t.setStackTrace(new StackTraceElement[]{this.getTraceElement(script, command, linenumber)});
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw (Exception)t;
                }
            }
            if (scriptElement instanceof Action) {
                if (!this.noActionStartedYet) {
                    this.finishCurrentAction();
                }
                Session.getCurrent().startAction(name);
                this.noActionStartedYet = false;
            } else if (scriptElement instanceof CodeComment) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Skipping comment: " + RegExUtils.replaceAll(name, "\\s+", " "));
                }
            } else {
                ModuleCall moduleCall = (ModuleCall)scriptElement;
                if (this.needToCallModule(moduleCall)) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Calling module: " + name);
                    }
                    Script moduleScript = this.getModuleScript(name);
                    TestContext.getCurrent().pushScope(moduleScript);
                    try {
                        this.executeScript(moduleScript, moduleCall.getParameters(), sdLinenumber);
                    }
                    catch (Throwable t) {
                        int linenumber = this.linenumberType.equals((Object)LineNumberType.file) ? scriptElement.getLineNumber() : lineNumber - baseLineNumber;
                        t.setStackTrace(this.appendLineNumberToStackTrace(t.getStackTrace(), script, moduleCall, linenumber));
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        throw (Exception)t;
                    }
                    finally {
                        TestContext.getCurrent().popScope();
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Returned from module: " + name);
                    }
                } else if (LOG.isInfoEnabled()) {
                    LOG.info("Skipping module: " + name);
                }
            }
        }
    }

    protected boolean needToCallModule(ModuleCall moduleCall) {
        if (moduleCall != null) {
            CallCondition cond = moduleCall.getCondition();
            if (cond != null && !cond.isDisabled()) {
                return this.evaluateCondition(this.resolve(cond.getConditionExpression()));
            }
            return true;
        }
        return false;
    }

    protected boolean evaluateCondition(String expression) {
        return this.getCommandProcessor().getAdapter().evaluatesToTrue(expression);
    }

    private int computeScriptSize(CommandScript script) throws Exception {
        int size = 0;
        for (ScriptElement el : script.getScriptElements()) {
            ++size;
            if (!(el instanceof ModuleCall)) continue;
            size += this.getModuleScript(el.getName()).getSize();
        }
        return size;
    }

    private void finishCurrentAction() {
        Session.getCurrent().stopAction();
    }

    private StackTraceElement getTraceElement(CommandScript commandScript, ScriptElement scriptElement, int elementPosition) throws Exception {
        String scriptsDir = this.getScriptsDirectory().getCanonicalPath();
        String scriptPath = commandScript.getScriptFile().getCanonicalPath();
        String relativeScriptPath = scriptPath.substring(scriptsDir.length());
        String scriptPackagePath = relativeScriptPath.replaceAll("[\\\\/]", ".");
        String scriptPackage = scriptPackagePath.startsWith(".") ? scriptPackagePath.substring(1, scriptPackagePath.length()) : scriptPackagePath;
        scriptPackage = scriptPackage.contains(".") ? scriptPackage.substring(0, scriptPackage.lastIndexOf(".")) : "";
        String scriptName = scriptElement.getName();
        scriptName = scriptName.contains(".") ? scriptName.substring(scriptName.lastIndexOf(".") + 1) : scriptName;
        return new StackTraceElement(scriptPackage, scriptName, commandScript.getScriptFile().getName(), elementPosition);
    }

    private StackTraceElement[] appendLineNumberToStackTrace(StackTraceElement[] origTrace, CommandScript script, ScriptElement element, int elementPosition) throws Exception {
        int traceLength = origTrace.length;
        StackTraceElement[] newTrace = new StackTraceElement[traceLength + 1];
        System.arraycopy(origTrace, 0, newTrace, 0, traceLength);
        newTrace[traceLength] = this.getTraceElement(script, element, elementPosition);
        return newTrace;
    }

    private void executePostSteps(TestCase testCase, AtomicInteger sdLineNumber) throws Exception {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        int afterStart = testCase.getSize();
        int offset = 0;
        for (ScriptElement scriptElement : testCase.getPostSteps()) {
            sdLineNumber.set(afterStart + offset);
            try {
                this.executeScriptElement(testCase, scriptElement, 0, sdLineNumber);
            }
            catch (Throwable t) {
                throwables.add(t);
            }
            ++offset;
            if (!(scriptElement instanceof ModuleCall)) continue;
            offset += this.getModuleScript(scriptElement.getName()).getSize();
        }
        if (!throwables.isEmpty()) {
            ScriptException ex = new ScriptException("Failed to execute post-steps of testcase: " + testCase.getScriptFile().getAbsolutePath());
            for (Throwable t : throwables) {
                ex.addSuppressed(t);
            }
            throw ex;
        }
    }

    public void doCommand(Command command) {
        String target = this.resolve(command.getTarget());
        String value = this.resolve(command.getValue());
        String name = command.getName();
        try {
            String realTarget = target;
            String realValue = value;
            if (ReplayUtils.isValueOnlyCommand(name)) {
                realTarget = value;
                realValue = null;
            }
            this.getCommandProcessor().doCommand(name, realTarget, realValue);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ScriptException(t.getMessage(), t.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script getModuleScript(String moduleName) throws Exception {
        Map<String, Script> map = moduleCache;
        synchronized (map) {
            Script script = moduleCache.get(moduleName);
            if (script == null) {
                script = this.parseModuleScriptFile(moduleName);
                moduleCache.put(moduleName, script);
                this.loadCalledModules(script);
            }
            return script;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Script getTestCaseScript(String testCaseName) throws Exception {
        Map<String, Script> map = testCaseCache;
        synchronized (map) {
            Script script = testCaseCache.get(testCaseName);
            if (script == null) {
                script = this.parseTestCaseScriptFile(testCaseName);
                testCaseCache.put(testCaseName, script);
                this.loadCalledModules(script);
            }
            return script;
        }
    }

    private void loadCalledModules(Script script) throws Exception {
        if (script instanceof CommandScript) {
            CommandScript commandScript = (CommandScript)script;
            for (ScriptElement scriptElement : commandScript.getScriptElements()) {
                if (!(scriptElement instanceof ModuleCall)) continue;
                ModuleCall moduleCall = (ModuleCall)scriptElement;
                this.getModuleScript(moduleCall.getName());
            }
            script.setSize(this.computeScriptSize(commandScript));
        }
    }

    private String resolve(String resolvable) {
        return TestContext.getCurrent().resolve(resolvable);
    }

    protected abstract File getScriptsDirectory();
}

