/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.xceptance.xlt.engine.har.model.HarBrowser;
import com.xceptance.xlt.engine.har.model.HarCreator;
import com.xceptance.xlt.engine.har.model.HarEntry;
import com.xceptance.xlt.engine.har.model.HarPage;
import java.util.ArrayList;
import java.util.List;

@JsonPropertyOrder(value={"version", "creator", "browser", "pages", "entries", "comment"})
public class HarLog {
    private final String version;
    private final HarCreator creator;
    private final HarBrowser browser;
    private final List<HarPage> pages;
    private final List<HarEntry> entries;
    private final String comment;

    @JsonCreator
    public HarLog(@JsonProperty(value="version") String version, @JsonProperty(value="creator") HarCreator creator, @JsonProperty(value="browser") HarBrowser browser, @JsonProperty(value="pages") List<HarPage> pages, @JsonProperty(value="entries") List<HarEntry> entries, @JsonProperty(value="comment") String comment) {
        this.version = version;
        this.creator = creator;
        this.browser = browser;
        this.pages = pages;
        this.entries = entries;
        this.comment = comment;
    }

    public String getVersion() {
        return this.version;
    }

    public HarCreator getCreator() {
        return this.creator;
    }

    public HarBrowser getBrowser() {
        return this.browser;
    }

    public List<HarPage> getPages() {
        return this.pages;
    }

    public List<HarEntry> getEntries() {
        return this.entries;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "HarLog [pages = " + String.valueOf(this.pages) + ", browser = " + String.valueOf(this.browser) + ", entries = " + String.valueOf(this.entries) + ", comment = " + this.comment + ", creator = " + String.valueOf(this.creator) + ", version = " + this.version + "]";
    }

    public static class Builder {
        private String version = "1.2";
        private HarCreator creator;
        private HarBrowser browser;
        private List<HarPage> pages;
        private List<HarEntry> entries = new ArrayList<HarEntry>();
        private String comment;

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withCreator(HarCreator creator) {
            this.creator = creator;
            return this;
        }

        public Builder withBrowser(HarBrowser browser) {
            this.browser = browser;
            return this;
        }

        public Builder withPages(List<HarPage> pages) {
            this.pages = pages;
            return this;
        }

        public Builder withEntries(List<HarEntry> entries) {
            this.entries = entries;
            return this;
        }

        public Builder addEntry(HarEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarLog build() {
            return new HarLog(this.version, this.creator, this.browser, this.pages, this.entries, this.comment);
        }
    }
}

