/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonPropertyOrder(value={"name", "value", "comment"})
public class HarHeader {
    private final String name;
    private final String value;
    private final String comment;

    @JsonCreator
    public HarHeader(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value, @JsonProperty(value="comment") String comment) {
        this.name = name;
        this.value = value;
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "HarHeader [name = " + this.name + ", value = " + this.value + ", comment = " + this.comment + "]";
    }

    public static class Builder {
        private String name;
        private List<String> values = new ArrayList<String>();
        private String comment;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withValue(String value) {
            this.values.add(value);
            return this;
        }

        public Builder withValues(List<String> values) {
            if (values != null) {
                this.values.addAll(values);
            }
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarHeader build() {
            return new HarHeader(this.name, StringUtils.join(this.values, (String)","), this.comment);
        }
    }
}

