/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Date;

@JsonPropertyOrder(value={"expires", "lastAccess", "eTag", "hitCount", "comment"})
public class HarCacheRequest {
    private final Date expires;
    private final Date lastAccess;
    private final String eTag;
    private final long hitCount;
    private final String comment;

    @JsonCreator
    public HarCacheRequest(@JsonProperty(value="expires") Date expires, @JsonProperty(value="lastAccess") Date lastAccess, @JsonProperty(value="eTag") String eTag, @JsonProperty(value="hitCount") long hitCount, @JsonProperty(value="comment") String comment) {
        this.expires = expires;
        this.lastAccess = lastAccess;
        this.eTag = eTag;
        this.hitCount = hitCount;
        this.comment = comment;
    }

    public String getETag() {
        return this.eTag;
    }

    public Date getExpires() {
        return this.expires;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "HarCacheRequest [eTag = " + this.eTag + ", expires = " + String.valueOf(this.expires) + ", hitCount = " + this.hitCount + ", lastAccess = " + String.valueOf(this.lastAccess) + ", comment = " + this.comment + "]";
    }

    public static class Builder {
        private Date expires;
        private Date lastAccess;
        private String eTag = "";
        private long hitCount;
        private String comment;

        public Builder withExpires(Date expires) {
            this.expires = expires;
            return this;
        }

        public Builder withLastAccess(Date lastAccess) {
            this.lastAccess = lastAccess;
            return this;
        }

        public Builder withEtag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder withHitCount(long hitCount) {
            this.hitCount = hitCount;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarCacheRequest build() {
            return new HarCacheRequest(this.expires, this.lastAccess, this.eTag, this.hitCount, this.comment);
        }
    }
}

