/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.dns;

import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.dns.HostNameResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;

class PlatformHostNameResolver
implements HostNameResolver {
    static final String PROVIDER_NAME = "platform";
    private static final String PROP_PREFIX = "xlt.dns.providers.platform.";

    PlatformHostNameResolver() {
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        return InetAddress.getAllByName(host);
    }

    static {
        XltProperties props = XltProperties.getInstance();
        int duration = props.getProperty("xlt.dns.providers.platform.cache.duration", 30);
        Security.setProperty("networkaddress.cache.ttl", String.valueOf(duration));
    }
}

