/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.api.util.XltException;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;

public final class XltExecutionContext {
    private static final XltExecutionContext context = new XltExecutionContext();
    private FileObject testSuiteConfigDir;
    private FileObject testSuiteHomeDir;
    private File xltConfigDir;
    private final File xltHomeDir;

    public static XltExecutionContext getCurrent() {
        return context;
    }

    private XltExecutionContext() {
        String xltHomeDirPath = this.getXltPropertyValue("home", "XLT_HOME", ".");
        this.xltHomeDir = new File(xltHomeDirPath);
        String configDirPath = this.getXltPropertyValue("configDir", "XLT_CONFIG_DIR", "config");
        this.xltConfigDir = new File(configDirPath);
        if (!this.xltConfigDir.isAbsolute()) {
            this.xltConfigDir = new File(this.xltHomeDir, configDirPath);
        }
        String testSuiteHomePath = this.getXltPropertyValue("testSuiteHomeDir", "XLT_TEST_SUITE_HOME_DIR", ".");
        File testSuiteHome = new File(testSuiteHomePath);
        this.setTestSuiteHomeDir(testSuiteHome);
        this.setTestSuiteConfigDir(new File(testSuiteHome, "config"));
    }

    public FileObject getTestSuiteConfigDir() {
        return this.testSuiteConfigDir;
    }

    public FileObject getTestSuiteHomeDir() {
        return this.testSuiteHomeDir;
    }

    public File getTestSuiteHomeDirAsFile() {
        return this.testSuiteHomeDir == null ? null : new File(this.testSuiteHomeDir.getName().getPath());
    }

    public File getXltConfigDir() {
        return this.xltConfigDir;
    }

    public File getXltHomeDir() {
        return this.xltHomeDir;
    }

    public void setTestSuiteConfigDir(File dir) {
        try {
            this.testSuiteConfigDir = VFS.getManager().resolveFile(dir.getAbsolutePath());
        }
        catch (FileSystemException e) {
            throw new XltException("Failed to resolve directory: " + String.valueOf(dir), e);
        }
    }

    public void setTestSuiteConfigDir(FileObject dir) {
        this.testSuiteConfigDir = dir;
    }

    public void setTestSuiteHomeDir(File dir) {
        try {
            this.testSuiteHomeDir = VFS.getManager().resolveFile(dir.getAbsolutePath());
        }
        catch (FileSystemException e) {
            throw new XltException("Failed to resolve directory: " + String.valueOf(dir), e);
        }
    }

    public void setTestSuiteHomeDir(FileObject dir) {
        this.testSuiteHomeDir = dir;
    }

    private String getXltPropertyValue(String systemPropertyName, String environmentPropertyName, String defaultValue) {
        String propertyValue = System.getProperty("com.xceptance.xlt." + systemPropertyName);
        if (StringUtils.isBlank((CharSequence)propertyValue) && StringUtils.isBlank((CharSequence)(propertyValue = System.getenv(environmentPropertyName)))) {
            propertyValue = defaultValue;
        }
        return propertyValue;
    }
}

