/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.api.engine.NetworkData;
import com.xceptance.xlt.api.engine.NetworkDataManager;
import com.xceptance.xlt.api.engine.RequestFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class NetworkDataManagerImpl
implements NetworkDataManager {
    private final List<NetworkData> data = Collections.synchronizedList(new ArrayList());

    @Override
    public void addData(NetworkData networkData) {
        if (networkData != null) {
            this.data.add(networkData);
        }
    }

    @Override
    public List<NetworkData> getData() {
        return this.getData(null);
    }

    @Override
    public List<NetworkData> getData(RequestFilter filter) {
        ArrayList<NetworkData> filteredData = new ArrayList<NetworkData>(this.data);
        if (filter != null) {
            Iterator it = filteredData.iterator();
            while (it.hasNext()) {
                NetworkData n = (NetworkData)it.next();
                if (filter.accepts(n.getRequest())) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableList(filteredData);
    }

    @Override
    public void clear() {
        this.data.clear();
    }
}

