/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.common.io.FileUtils;
import com.xceptance.xlt.api.engine.DataLogger;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class DataLoggerImpl
implements DataLogger {
    private final Session session;
    private volatile BufferedWriter logger;
    private String filename;
    private String extension;

    protected DataLoggerImpl(Session session, String scope) {
        this.session = session;
        this.filename = "custom_log_" + scope;
        this.extension = "log";
    }

    protected DataLoggerImpl(Session session, String scope, String extension) {
        this.session = session;
        this.filename = "custom_log_" + scope;
        this.extension = extension;
    }

    @Override
    public void setHeader(String header) {
        Path file = this.getLoggerFile();
        try {
            if (!Files.exists(file, new LinkOption[0]) || Files.size(file) == 0L) {
                BufferedWriter writer;
                BufferedWriter bufferedWriter = writer = this.logger != null ? this.logger : this.getTimerLogger();
                if (writer == null) {
                    return;
                }
                StringBuilder s = new StringBuilder(header);
                s = DataLoggerImpl.removeLineSeparators(s, ' ');
                s.append(System.lineSeparator());
                writer.write(s.toString());
                writer.flush();
            } else {
                XltLogger.runTimeLogger.warn("Did not write custom data header because logfile already contains data: " + String.valueOf(file));
            }
        }
        catch (IOException ex) {
            XltLogger.runTimeLogger.error("Failed to write custom data header:", (Throwable)ex);
        }
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public void log(String lineOfData) {
        BufferedWriter writer;
        BufferedWriter bufferedWriter = writer = this.logger != null ? this.logger : this.getTimerLogger();
        if (writer == null) {
            return;
        }
        try {
            StringBuilder s = new StringBuilder(lineOfData);
            s = DataLoggerImpl.removeLineSeparators(s, ' ');
            s.append(System.lineSeparator());
            writer.write(s.toString());
            writer.flush();
        }
        catch (IOException ex) {
            XltLogger.runTimeLogger.error("Failed to write data:", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedWriter getTimerLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        DataLoggerImpl dataLoggerImpl = this;
        synchronized (dataLoggerImpl) {
            if (this.logger != null) {
                return this.logger;
            }
            Path file = this.getLoggerFile();
            if (file == null) {
                return null;
            }
            try {
                this.logger = Files.newBufferedWriter(file, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Cannot create writer for file: " + file.toString(), (Throwable)e);
            }
        }
        return this.logger;
    }

    private Path getLoggerFile() {
        Path dir = this.session.getResultsDirectory();
        if (dir == null) {
            throw new RuntimeException("Missing result dir, see previous exceptions.");
        }
        Path file = dir.resolve(FileUtils.convertIllegalCharsInFileName((String)(this.extension == null ? this.filename : this.filename + "." + this.extension)));
        return file;
    }

    static StringBuilder removeLineSeparators(StringBuilder src, char replacementChar) {
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (c != '\n' && c != '\r') continue;
            src.setCharAt(i, replacementChar);
        }
        return src;
    }
}

