/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.common.collection.ConcurrentLRUCache;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.WebConnectionWrapper;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebConnection;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;

public class CachingHttpWebConnection
extends WebConnectionWrapper {
    static final FastDateFormat HEADER_DATE_FORMAT = FastDateFormat.getInstance((String)"EEE, d MMM yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.ENGLISH);
    private static final Pattern MAX_AGE_PATTERN = Pattern.compile(Pattern.quote("max-age") + "=(\\d+)");
    private final ConcurrentLRUCache<String, CacheEntry> cache;
    private final boolean useCache = XltProperties.getInstance().getProperty("com.xceptance.xlt.staticContentCache", false);

    public static long determineExpirationTime(WebResponse webResponse) {
        String expires;
        Matcher m;
        long date;
        String cacheControl;
        block19: {
            String pragma;
            cacheControl = webResponse.getResponseHeaderValue("Cache-Control");
            if (cacheControl != null && cacheControl.length() > 0) {
                if (cacheControl.contains("no-store")) {
                    return -1L;
                }
                if (cacheControl.contains("no-cache")) {
                    return 0L;
                }
            }
            if ((pragma = webResponse.getResponseHeaderValue("Pragma")) != null && pragma.length() > 0 && pragma.contains("no-cache")) {
                return 0L;
            }
            date = System.currentTimeMillis();
            String dateValue = webResponse.getResponseHeaderValue("Date");
            if (dateValue != null && dateValue.length() > 0) {
                try {
                    date = HEADER_DATE_FORMAT.parse(dateValue).getTime();
                }
                catch (ParseException ex) {
                    if (!XltLogger.runTimeLogger.isWarnEnabled()) break block19;
                    XltLogger.runTimeLogger.warn("Header Date does not match a valid date format. Check RFC 2616. Should be a valid RFC 1123 format, such as 'Thu, 01 Dec 1994 16:00:00 GMT', but was '" + dateValue + "'.");
                }
            }
        }
        if (cacheControl != null && cacheControl.length() > 0 && (m = MAX_AGE_PATTERN.matcher(cacheControl)).find() && m.groupCount() > 0) {
            try {
                long maxAge = Long.parseLong(m.group(1)) * 1000L;
                return date + maxAge;
            }
            catch (NumberFormatException maxAge) {
                // empty catch block
            }
        }
        if ((expires = webResponse.getResponseHeaderValue("Expires")) != null && expires.length() > 0) {
            if (expires.trim().equals("0")) {
                return 0L;
            }
            try {
                return HEADER_DATE_FORMAT.parse(expires).getTime();
            }
            catch (ParseException ex) {
                if (XltLogger.runTimeLogger.isWarnEnabled()) {
                    XltLogger.runTimeLogger.warn("Header Expires does not match a valid date format. Check RFC 2616. Should be a valid RFC 1123 format, such as 'Thu, 01 Dec 1994 16:00:00 GMT', but was '" + expires + "'.");
                }
                return 0L;
            }
        }
        String lastModified = webResponse.getResponseHeaderValue("Last-Modified");
        if (lastModified != null && lastModified.length() > 0) {
            try {
                long lastModifiedTime = HEADER_DATE_FORMAT.parse(lastModified).getTime();
                long age = Math.max(date - lastModifiedTime, 0L);
                return date + age / 10L;
            }
            catch (ParseException ex) {
                if (XltLogger.runTimeLogger.isWarnEnabled()) {
                    XltLogger.runTimeLogger.warn("Header Last-Modified does not match a valid date format. Check RFC 2616. Should be a valid RFC 1123 format, such as 'Thu, 01 Dec 1994 16:00:00 GMT', but was '" + expires + "'.");
                }
                return 0L;
            }
        }
        return 0L;
    }

    public CachingHttpWebConnection(WebConnection webConnection) {
        super(webConnection);
        if (this.useCache) {
            int cacheSize = XltProperties.getInstance().getProperty("com.xceptance.xlt.staticContentCache.size", 100);
            if (cacheSize < 10) {
                XltLogger.runTimeLogger.warn("Size of static content cache is lower than minimum size of 10. Will use the minimum size.");
            }
            this.cache = new ConcurrentLRUCache(Math.max(cacheSize, 10));
        } else {
            this.cache = null;
        }
    }

    @Override
    public WebResponse getResponse(WebRequest webRequest) throws IOException {
        if (!this.useCache || !webRequest.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return this.getResponse(webRequest, null, null);
        }
        String url = webRequest.getUrl().toExternalForm();
        CacheEntry cacheEntry = this.cache.get(url);
        if (cacheEntry == null) {
            WebResponse webResponse = this.getResponse(webRequest, null, null);
            long expires = CachingHttpWebConnection.determineExpirationTime(webResponse);
            if (webResponse.getStatusCode() == 200 && expires > -1L) {
                cacheEntry = new CacheEntry();
                cacheEntry.webResponse = webResponse;
                cacheEntry.expires = expires;
                cacheEntry.lastModified = webResponse.getResponseHeaderValue("Last-Modified");
                cacheEntry.etag = webResponse.getResponseHeaderValue("ETag");
                this.cache.put(url, cacheEntry);
            }
            return webResponse;
        }
        if (cacheEntry.expires < System.currentTimeMillis()) {
            WebResponse webResponse = this.getResponse(webRequest, cacheEntry.lastModified, cacheEntry.etag);
            long expires = CachingHttpWebConnection.determineExpirationTime(webResponse);
            if (expires > -1L) {
                cacheEntry.expires = expires;
                if (webResponse.getStatusCode() == 200) {
                    cacheEntry.webResponse = webResponse;
                    cacheEntry.lastModified = webResponse.getResponseHeaderValue("Last-Modified");
                    cacheEntry.etag = webResponse.getResponseHeaderValue("ETag");
                    return webResponse;
                }
            }
            if (webResponse.getStatusCode() == 304) {
                return cacheEntry.webResponse;
            }
            this.cache.remove(url);
            return webResponse;
        }
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info("Return cached response for " + String.valueOf(webRequest.getUrl()));
        }
        return cacheEntry.webResponse;
    }

    protected WebResponse getResponse(WebRequest webRequest, String lastModifiedHeader, String etag) throws IOException {
        if (lastModifiedHeader != null && lastModifiedHeader.length() > 0) {
            webRequest.setAdditionalHeader("If-Modified-Since", lastModifiedHeader);
        }
        if (StringUtils.isNotBlank((CharSequence)etag)) {
            webRequest.setAdditionalHeader("If-None-Match", etag);
        }
        return this.getWrappedWebConnection().getResponse(webRequest);
    }

    private static class CacheEntry {
        public long expires;
        public String lastModified;
        public String etag;
        public WebResponse webResponse;

        private CacheEntry() {
        }
    }
}

