/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.ec2;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.engine.XltExecutionContext;
import java.io.File;
import java.io.IOException;

public class AwsConfiguration
extends AbstractConfiguration {
    private static final String PROP_PREFIX = "aws.";
    private static final String PROP_PROXY_PREFIX = "aws.proxy.";
    private static final String PROP_ACCESS_KEY = "aws.accessKey";
    private static final String PROP_SECRET_KEY = "aws.secretKey";
    private static final String PROP_SESSION_TOKEN = "aws.sessionToken";
    private static final String PROP_SSH_KEY = "aws.keypair.";
    private static final String PROP_PROXY_PROTOCOL = "aws.proxy.protocol";
    private static final String PROP_PROXY_HOST = "aws.proxy.host";
    private static final String PROP_PROXY_PORT = "aws.proxy.port";
    private static final String PROP_PROXY_USER_NAME = "aws.proxy.userName";
    private static final String PROP_PROXY_PASSWORD = "aws.proxy.password";
    private static final String PROP_INSTANCE_CONNECT_TIMEOUT = "aws.instanceConnectTimeout";
    private final String accessKey;
    private final String protocol;
    private final String proxyHost;
    private final String proxyPassword;
    private final int proxyPort;
    private final String proxyUserName;
    private final String secretKey;
    private final String sessionToken;
    private final int instanceConnectTimeout;

    public AwsConfiguration() {
        try {
            File configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
            File propFile = new File(configDirectory, "ec2_admin.properties");
            this.loadProperties(propFile);
            this.accessKey = this.getStringProperty(PROP_ACCESS_KEY, null);
            this.secretKey = this.getStringProperty(PROP_SECRET_KEY, null);
            this.sessionToken = this.getStringProperty(PROP_SESSION_TOKEN, null);
            this.protocol = this.getStringProperty(PROP_PROXY_PROTOCOL, "http");
            this.proxyHost = this.getStringProperty(PROP_PROXY_HOST, null);
            this.proxyPort = this.getIntProperty(PROP_PROXY_PORT, 8888);
            this.proxyUserName = this.getStringProperty(PROP_PROXY_USER_NAME, null);
            this.proxyPassword = this.getStringProperty(PROP_PROXY_PASSWORD, null);
            this.instanceConnectTimeout = this.getIntProperty(PROP_INSTANCE_CONNECT_TIMEOUT, -1);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read AWS configuration", e);
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public int getInstanceConnectTimeout() {
        return this.instanceConnectTimeout;
    }

    public String getSshKey(String regionName) {
        return this.getStringProperty(PROP_SSH_KEY + regionName, null);
    }
}

