/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.ec2;

import com.xceptance.xlt.ec2.AwsConfiguration;
import com.xceptance.xlt.engine.TimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.ProxyConfiguration;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import software.amazon.awssdk.services.ec2.model.AvailabilityZone;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.Region;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RunInstancesResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagDescription;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Vpc;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public abstract class AbstractEC2Client {
    private static final String DEFAULT_REGION = software.amazon.awssdk.regions.Region.US_EAST_1.id();
    private final HashMap<String, Ec2Client> clientsByRegion = new HashMap();
    private final ProxyConfiguration proxyConfig;
    protected final AwsConfiguration awsConfiguration;
    private final AwsCredentialsProvider credentialsProvider;
    private static final long INSTANCE_STATE_POLLING_INTERVAL = 1000L;
    protected static final Logger log = LoggerFactory.getLogger(AbstractEC2Client.class);

    public AbstractEC2Client() throws Exception {
        try {
            this.awsConfiguration = new AwsConfiguration();
            if (this.awsConfiguration.getProxyHost() != null) {
                ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder();
                proxyConfigBuilder.endpoint(new URIBuilder().setScheme(this.awsConfiguration.getProtocol()).setHost(this.awsConfiguration.getProxyHost()).setPort(this.awsConfiguration.getProxyPort()).build());
                proxyConfigBuilder.username(this.awsConfiguration.getProxyUserName());
                proxyConfigBuilder.password(this.awsConfiguration.getProxyPassword());
                proxyConfigBuilder.useSystemPropertyValues(Boolean.FALSE);
                proxyConfigBuilder.useEnvironmentVariablesValues(Boolean.FALSE);
                this.proxyConfig = (ProxyConfiguration)proxyConfigBuilder.build();
            } else {
                this.proxyConfig = null;
            }
            this.credentialsProvider = this.getCredentialsProvider(this.awsConfiguration);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize AWS EC2 client: " + e.getMessage());
            log.error("Failed to initialize AWS EC2 client", (Throwable)e);
            throw e;
        }
    }

    private AwsCredentialsProvider getCredentialsProvider(AwsConfiguration awsConfiguration) throws Exception {
        String accessKey = awsConfiguration.getAccessKey();
        String secretKey = awsConfiguration.getSecretKey();
        String sessionToken = awsConfiguration.getSessionToken();
        if (accessKey != null && secretKey != null) {
            if (sessionToken != null) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey));
        }
        if (accessKey == null && secretKey == null && sessionToken == null) {
            return DefaultCredentialsProvider.create();
        }
        throw new Exception("Invalid credential configuration in 'ec2_admin.properties'.");
    }

    protected Ec2Client getClient(Region region) {
        return this.clientForRegion(region == null ? DEFAULT_REGION : region.regionName());
    }

    private Ec2Client clientForRegion(String regionName) {
        Ec2Client client = this.clientsByRegion.get(regionName);
        if (client == null) {
            UrlConnectionHttpClient.Builder httpClientBuilder = UrlConnectionHttpClient.builder();
            if (this.proxyConfig != null) {
                httpClientBuilder.proxyConfiguration(this.proxyConfig);
            }
            client = (Ec2Client)((Ec2ClientBuilder)((Ec2ClientBuilder)((Ec2ClientBuilder)Ec2Client.builder().httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder)).credentialsProvider(this.credentialsProvider)).region(software.amazon.awssdk.regions.Region.of((String)regionName))).build();
            this.clientsByRegion.put(regionName, client);
        }
        return client;
    }

    protected Instance waitForInstanceState(Region region, Instance instance, InstanceStateName state, long timeout) throws Exception {
        long deadline = System.currentTimeMillis() + timeout;
        String instanceId = instance.instanceId();
        while (System.currentTimeMillis() < deadline) {
            Instance foundInstance = this.getInstance(region, instanceId, new ArrayList<TagDescription>(), state);
            if (foundInstance != null) {
                return foundInstance;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        throw new Exception("Instance didn't achieve state '" + String.valueOf(state) + "' within " + timeout / 1000L + "s. Current state is '" + instance.state().name().toString() + "'");
    }

    protected List<AvailabilityZone> getAvailabilityZones(Region region) {
        return new ArrayList<AvailabilityZone>(this.getClient(region).describeAvailabilityZones().availabilityZones());
    }

    protected List<SecurityGroup> getSecurityGroupIDs(Region region) {
        ArrayList<SecurityGroup> secGroups = new ArrayList<SecurityGroup>(this.getClient(region).describeSecurityGroups().securityGroups());
        Collections.sort(secGroups, new Comparator<SecurityGroup>(this){

            @Override
            public int compare(SecurityGroup i1, SecurityGroup i2) {
                String d1 = StringUtils.defaultString((String)i1.groupName().toLowerCase());
                String d2 = StringUtils.defaultString((String)i2.groupName().toLowerCase());
                return d1.compareTo(d2);
            }
        });
        return secGroups;
    }

    protected List<Image> getImages(Region region, String ... imageIds) {
        DescribeImagesRequest describeImagesRequest = (DescribeImagesRequest)DescribeImagesRequest.builder().owners(new String[]{"self", "614612213257"}).filters(new Filter[]{(Filter)Filter.builder().name("architecture").values(new String[]{"x86_64"}).build()}).imageIds(imageIds).build();
        ArrayList<Image> images = new ArrayList<Image>(this.getClient(region).describeImages(describeImagesRequest).images());
        return images;
    }

    protected List<KeyPairInfo> getKeyPairs(Region region) {
        DescribeKeyPairsResponse describeKeyPairsResponse = this.getClient(region).describeKeyPairs();
        ArrayList<KeyPairInfo> keyPairInfos = new ArrayList<KeyPairInfo>(describeKeyPairsResponse.keyPairs());
        Collections.sort(keyPairInfos, new Comparator<KeyPairInfo>(this){

            @Override
            public int compare(KeyPairInfo i1, KeyPairInfo i2) {
                String d1 = StringUtils.defaultString((String)i1.keyName());
                String d2 = StringUtils.defaultString((String)i2.keyName());
                return d1.compareTo(d2);
            }
        });
        return keyPairInfos;
    }

    protected Image getImage(Region region, String imageId) {
        List<Image> images = this.getImages(region, imageId);
        Image image = null;
        for (Image img : images) {
            if (!img.imageId().equals(imageId)) continue;
            image = img;
            break;
        }
        return image;
    }

    protected List<String> getRunningInstanceIds(Region region, List<TagDescription> tags) {
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (Instance instance : this.getInstances(region, tags, InstanceStateName.RUNNING)) {
            instanceIds.add(instance.instanceId());
        }
        return instanceIds;
    }

    protected Instance getInstance(Region region, String instanceID, List<TagDescription> tags, InstanceStateName state) {
        List<Instance> instances = this.getInstances(region, new ArrayList<TagDescription>(), state);
        for (Instance instance : instances) {
            if (!instance.instanceId().equals(instanceID)) continue;
            return instance;
        }
        return null;
    }

    protected List<Instance> getInstances(Region region, List<TagDescription> tags, InstanceStateName state) {
        HashMap<String, Filter> filters = new HashMap<String, Filter>();
        HashMap<String, ArrayList<String>> tagKeyValueMap = new HashMap<String, ArrayList<String>>();
        for (TagDescription tag : tags) {
            String key = tag.key();
            ArrayList<String> values = (ArrayList<String>)tagKeyValueMap.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                tagKeyValueMap.put(key, values);
            }
            values.add(tag.value());
        }
        for (String key : tagKeyValueMap.keySet()) {
            filters.put(key, (Filter)Filter.builder().name("tag:" + key).values((Collection)tagKeyValueMap.get(key)).build());
        }
        if (state != null) {
            Filter stateFilter = (Filter)Filter.builder().name("instance-state-name").values(new String[]{state.toString()}).build();
            filters.put("instance-state", stateFilter);
        }
        ArrayList<Instance> instances = new ArrayList<Instance>();
        DescribeInstancesRequest describeInstancesRequest = (DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(filters.values()).build();
        DescribeInstancesResponse describeInstancesResponse = this.getClient(region).describeInstances(describeInstancesRequest);
        for (Reservation reservation : describeInstancesResponse.reservations()) {
            instances.addAll(reservation.instances());
        }
        return instances;
    }

    protected List<Instance> getInstances(Region region, List<TagDescription> tags) {
        return this.getInstances(region, tags, null);
    }

    protected List<Region> getRegions(String ... regionNames) {
        DescribeRegionsRequest.Builder describeRegionsRequestBuilder = DescribeRegionsRequest.builder();
        describeRegionsRequestBuilder.regionNames(Arrays.asList(regionNames));
        describeRegionsRequestBuilder.allRegions(Boolean.valueOf(false));
        DescribeRegionsResponse describeRegionsResponse = this.getClient(null).describeRegions((DescribeRegionsRequest)describeRegionsRequestBuilder.build());
        ArrayList<Region> regions = new ArrayList<Region>(describeRegionsResponse.regions());
        Collections.sort(regions, (r1, r2) -> {
            String s1 = StringUtils.defaultString((String)r1.regionName());
            String s2 = StringUtils.defaultString((String)r2.regionName());
            return s1.compareTo(s2);
        });
        return regions;
    }

    protected Region getRegion(String regionName) {
        List<Region> regions = this.getRegions(regionName);
        return regions.size() == 1 ? regions.get(0) : null;
    }

    protected static CommandLine parseCommandLine(Options options, String[] args) {
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException ex) {
            AbstractEC2Client.printUsageInfo(options);
            System.exit(2);
            return null;
        }
    }

    protected static void printUsageInfo(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        System.out.println("Simple front-end application to manage AWS EC2 instances.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("    ec2_admin [<options>]");
        System.out.println("      -> Run in interactive mode.\n");
        System.out.println("    ec2_admin run <region> <ami> <type> <count> <nameTag> [<options>]");
        System.out.println("      -> Start instances non-interactively.\n");
        System.out.println("    ec2_admin terminate <region> <nameTag>");
        System.out.println("      -> Terminate instances non-interactively.");
        formatter.setSyntaxPrefix("");
        formatter.setWidth(79);
        formatter.printHelp(" ", "Options:", options, "");
        System.out.println();
    }

    protected List<Subnet> getSubnets(Region region, AvailabilityZone availabilityZone, Vpc vpc) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (availabilityZone != null) {
            filters.add((Filter)Filter.builder().name("availability-zone").values(Arrays.asList(availabilityZone.zoneName())).build());
        }
        if (vpc != null) {
            filters.add((Filter)Filter.builder().name("vpc-id").values(Arrays.asList(vpc.vpcId())).build());
        }
        DescribeSubnetsRequest req = (DescribeSubnetsRequest)DescribeSubnetsRequest.builder().filters(filters).build();
        return new ArrayList<Subnet>(this.getClient(region).describeSubnets(req).subnets());
    }

    protected List<Vpc> getVpcs(Region region, List<String> vpcIds) {
        DescribeVpcsRequest.Builder vpcReqBuilder = DescribeVpcsRequest.builder();
        if (vpcIds != null && !vpcIds.isEmpty()) {
            vpcReqBuilder.filters(new Filter[]{(Filter)Filter.builder().name("vpc-id").values(vpcIds).build()});
        }
        return new ArrayList<Vpc>(this.getClient(region).describeVpcs((DescribeVpcsRequest)vpcReqBuilder.build()).vpcs());
    }

    protected List<Instance> runInstances(Region region, Subnet subnet, Image image, String instanceType, int count, Collection<String> securityGroupIds, String keyPairName, String userData) throws Exception {
        List<Subnet> subnets;
        RunInstancesRequest.Builder runInstancesRequestBuilder = RunInstancesRequest.builder();
        if (subnet == null && !(subnets = this.getSubnets(region, null, null)).isEmpty()) {
            subnet = subnets.parallelStream().filter(s -> s.defaultForAz()).findAny().orElse(subnets.get(0));
        }
        if (subnet == null) {
            throw new Exception("No subnet available to launch instances into");
        }
        runInstancesRequestBuilder.placement((Placement)Placement.builder().availabilityZone(subnet.availabilityZone()).build());
        runInstancesRequestBuilder.subnetId(subnet.subnetId());
        runInstancesRequestBuilder.imageId(image.imageId());
        runInstancesRequestBuilder.instanceType(instanceType);
        runInstancesRequestBuilder.minCount(Integer.valueOf(count));
        runInstancesRequestBuilder.maxCount(Integer.valueOf(count));
        if (StringUtils.isNotBlank((CharSequence)userData)) {
            runInstancesRequestBuilder.userData(BinaryUtils.toBase64((byte[])userData.getBytes()));
        }
        if (securityGroupIds != null) {
            runInstancesRequestBuilder.securityGroupIds(securityGroupIds);
        }
        if (StringUtils.isNotBlank((CharSequence)keyPairName)) {
            runInstancesRequestBuilder.keyName(keyPairName);
        }
        RunInstancesResponse response = this.getClient(region).runInstances((RunInstancesRequest)runInstancesRequestBuilder.build());
        ArrayList<Instance> instances = new ArrayList<Instance>(response.instances());
        return instances;
    }

    protected void terminateInstances(List<Region> regions, List<TagDescription> tags) {
        System.out.println();
        for (Region region : regions) {
            try {
                System.out.printf("Terminating %s instances in region '%s' ... ", tags.isEmpty() ? "all" : "the selected", region.regionName());
                TerminateInstancesRequest.Builder terminateInstancesRequestBuilder = TerminateInstancesRequest.builder();
                terminateInstancesRequestBuilder.instanceIds(this.getRunningInstanceIds(region, tags));
                this.getClient(region).terminateInstances((TerminateInstancesRequest)terminateInstancesRequestBuilder.build());
                System.out.println("OK.");
            }
            catch (SdkException e) {
                System.out.println("Failed: " + e.getMessage());
            }
        }
    }

    protected void terminateInstance(Region region, Instance instance) {
        TerminateInstancesRequest.Builder terminateInstancesRequestBuilder = TerminateInstancesRequest.builder();
        terminateInstancesRequestBuilder.instanceIds(new String[]{instance.instanceId()});
        this.getClient(region).terminateInstances((TerminateInstancesRequest)terminateInstancesRequestBuilder.build());
    }

    protected void setNameTag(Region region, List<String> ids, String name) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add((Tag)Tag.builder().key("Name").value(name).build());
        CreateTagsRequest.Builder createTagRequestBuilder = CreateTagsRequest.builder();
        createTagRequestBuilder.resources(ids);
        createTagRequestBuilder.tags(tags);
        this.getClient(region).createTags((CreateTagsRequest)createTagRequestBuilder.build());
    }

    protected void waitForInstancesToEventuallyExist(Region region, List<Instance> instances, long timeout) throws InterruptedException {
        List<String> instanceIds = this.getInstanceIds(instances);
        long deadline = System.currentTimeMillis() + timeout;
        while (true) {
            AwsServiceException lastException = null;
            try {
                DescribeInstancesRequest.Builder describeInstancesRequestBuilder = DescribeInstancesRequest.builder();
                describeInstancesRequestBuilder.instanceIds(instanceIds);
                this.getClient(region).describeInstances((DescribeInstancesRequest)describeInstancesRequestBuilder.build());
                return;
            }
            catch (AwsServiceException e) {
                if (!"InvalidInstanceID.NotFound".equals(e.awsErrorDetails().errorCode())) {
                    throw e;
                }
                lastException = e;
                log.debug("Not all previously created instances are alive yet: " + e.getMessage());
                if (System.currentTimeMillis() < deadline) {
                    Thread.sleep(1000L);
                    continue;
                }
                throw new TimeoutException("One or more instances did not become alive within " + timeout / 1000L + " seconds", lastException);
            }
            break;
        }
    }

    protected List<String> getInstanceIds(List<Instance> instances) {
        ArrayList<String> instanceIds = new ArrayList<String>(instances.size());
        for (Instance instance : instances) {
            instanceIds.add(instance.instanceId());
        }
        return instanceIds;
    }

    public void shutdown() {
        this.clientsByRegion.values().forEach(SdkAutoCloseable::close);
    }
}

