/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.clientperformance;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.engine.WebVitalData;
import com.xceptance.xlt.clientperformance.ClientPerformanceData;
import com.xceptance.xlt.clientperformance.ClientPerformanceRequest;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.resultbrowser.ActionInfo;
import com.xceptance.xlt.engine.resultbrowser.RequestInfo;
import com.xceptance.xlt.engine.util.UrlUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPerformanceMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(ClientPerformanceMetrics.class);

    public static void updatePerformanceData(SessionImpl session, List<ClientPerformanceData> dataList) {
        LOG.debug("Writing timer data file and reporting client performance metrics");
        for (ClientPerformanceData eachPerformanceData : dataList) {
            ClientPerformanceMetrics.updatePerformanceData(session, eachPerformanceData);
        }
    }

    private static void updatePerformanceData(SessionImpl session, ClientPerformanceData data) {
        for (ClientPerformanceRequest eachRequest : data.getRequestList()) {
            ClientPerformanceMetrics.updateAndLogRequestData(session, eachRequest);
        }
        for (PageLoadTimingData eachData : data.getCustomDataList()) {
            ClientPerformanceMetrics.updateAndLogPageLoadTimingData(session, eachData);
        }
        ClientPerformanceMetrics.postProcessAndLogWebVitalsData(data.getWebVitalsList(), session);
    }

    private static void updateAndLogRequestData(SessionImpl session, ClientPerformanceRequest request) {
        ActionInfo actionInfo = ClientPerformanceMetrics.getActionInfo(session, request.getRequestData().getTime());
        if (actionInfo != null) {
            actionInfo.requests.add(ClientPerformanceMetrics.getRequestInfo(request));
        }
        ClientPerformanceMetrics.logTimerData(session, actionInfo, request.getRequestData());
    }

    private static void updateAndLogPageLoadTimingData(SessionImpl session, PageLoadTimingData data) {
        ActionInfo actionInfo = ClientPerformanceMetrics.getActionInfo(session, data.getTime());
        if (actionInfo != null) {
            actionInfo.events.add(new ActionInfo.PageLoadEventInfo(data.getName(), data.getTime(), data.getRunTime()));
        }
        ClientPerformanceMetrics.logTimerData(session, actionInfo, data);
    }

    private static RequestInfo getRequestInfo(ClientPerformanceRequest request) {
        RequestInfo requestInfo = new RequestInfo();
        RequestData requestData = request.getRequestData();
        int statusCode = requestData.getResponseCode();
        String statusMessage = (String)StringUtils.defaultIfBlank((CharSequence)request.getStatusMessage(), (CharSequence)"n/a");
        requestInfo.loadTime = requestData.getRunTime();
        if (statusCode > 0) {
            requestInfo.status = String.valueOf(statusCode) + " - ";
        }
        requestInfo.status = requestInfo.status + statusMessage;
        requestInfo.mimeType = requestData.getContentType().toString();
        requestInfo.name = ClientPerformanceMetrics.getRequestName(requestData);
        requestInfo.requestMethod = request.getHttpMethod();
        requestInfo.responseCode = statusCode;
        requestInfo.startTime = requestData.getTime();
        requestInfo.url = requestData.getUrl().toString();
        requestInfo.requestHeaders.addAll(request.getRequestHeaders());
        requestInfo.responseHeaders.addAll(request.getResponseHeaders());
        requestInfo.requestParameters.addAll(request.getFormDataParameters());
        requestInfo.requestBodyRaw = request.getRawBody();
        requestInfo.formDataEncoding = request.getFormDataEncoding();
        requestInfo.setTimings(requestData);
        return requestInfo;
    }

    private static String getRequestName(RequestData requestData) {
        String urlPath = UrlUtils.parseUrlString(requestData.getUrl().toString()).getPath();
        String pathWithoutEndSeparator = StringUtils.removeEnd((String)urlPath, (String)"/");
        Object name = FilenameUtils.getName((String)pathWithoutEndSeparator);
        if (!StringUtils.equals((CharSequence)urlPath, (CharSequence)pathWithoutEndSeparator)) {
            name = (String)name + "/";
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "-";
        }
        return name;
    }

    private static void postProcessAndLogWebVitalsData(List<WebVitalData> webVitalList, SessionImpl session) {
        ClientPerformanceMetrics.logWebVitals("FCP", webVitalList, session);
        ClientPerformanceMetrics.logWebVitals("FID", webVitalList, session);
        ClientPerformanceMetrics.logWebVitals("TTFB", webVitalList, session);
        ClientPerformanceMetrics.postProcessAndLogWebVitals("CLS", webVitalList, session);
        ClientPerformanceMetrics.postProcessAndLogWebVitals("INP", webVitalList, session);
        ClientPerformanceMetrics.postProcessAndLogWebVitals("LCP", webVitalList, session);
    }

    private static void logWebVitals(String webVitalName, List<WebVitalData> webVitalDataList, SessionImpl session) {
        for (WebVitalData webVitalData : webVitalDataList) {
            if (!webVitalData.getName().equals(webVitalName)) continue;
            ActionInfo actionInfo = ClientPerformanceMetrics.getActionInfo(session, webVitalData.getTime());
            ClientPerformanceMetrics.logTimerData(session, actionInfo, webVitalData);
        }
    }

    private static void postProcessAndLogWebVitals(String webVitalName, List<WebVitalData> webVitalDataList, SessionImpl session) {
        ActionInfo lastActionInfo = null;
        WebVitalData lastWebVitalData = null;
        double lastMaxValue = 0.0;
        for (WebVitalData webVitalData : webVitalDataList) {
            if (!webVitalData.getName().equals(webVitalName)) continue;
            ActionInfo actionInfo = ClientPerformanceMetrics.getActionInfo(session, webVitalData.getTime());
            if (lastWebVitalData != null && lastActionInfo != actionInfo) {
                double value = lastWebVitalData.getValue();
                lastWebVitalData.setValue(value - lastMaxValue);
                ClientPerformanceMetrics.logTimerData(session, lastActionInfo, lastWebVitalData);
                lastMaxValue = value;
            }
            lastActionInfo = actionInfo;
            lastWebVitalData = webVitalData;
        }
        if (lastWebVitalData != null) {
            double value = lastWebVitalData.getValue();
            lastWebVitalData.setValue(value - lastMaxValue);
            ClientPerformanceMetrics.logTimerData(session, lastActionInfo, lastWebVitalData);
        }
    }

    private static void logTimerData(SessionImpl session, ActionInfo actionInfo, Data data) {
        String actionName = actionInfo != null ? actionInfo.name : "UnknownAction";
        String dName = data.getName();
        StringBuilder sb = new StringBuilder(actionName);
        if (StringUtils.isNotBlank((CharSequence)dName)) {
            if (data instanceof PageLoadTimingData || data instanceof WebVitalData) {
                sb.append(" [").append(dName).append("]");
            } else {
                int idx = dName.lastIndexOf(46);
                if (idx < dName.length()) {
                    sb.append('.').append(dName.substring(idx + 1));
                }
            }
        }
        data.setName(sb.toString());
        session.getDataManager().logDataRecord(data);
    }

    private static ActionInfo getActionInfo(SessionImpl session, long time) {
        Map.Entry<Long, ActionInfo> entry = session.getWebDriverActionStartTimes().floorEntry(time);
        ActionInfo actionInfo = entry != null ? entry.getValue() : null;
        return actionInfo;
    }
}

