/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine.scripting;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.tests.AbstractWebDriverTestCase;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.scripting.TestContext;
import com.xceptance.xlt.engine.scripting.XlteniumScriptInterpreter;
import com.xceptance.xlt.engine.scripting.junit.ScriptTestCaseRunner;
import com.xceptance.xlt.engine.util.ScriptingUtils;
import java.time.Duration;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;

@RunWith(value=ScriptTestCaseRunner.class)
public abstract class AbstractScriptTestCase
extends AbstractWebDriverTestCase {
    private static final int DEFAULT_IMPLICIT_WAIT_TIMEOUT = XltProperties.getInstance().getProperty("com.xceptance.xlt.scripting.defaultImplicitWaitTimeout", 1000);
    private String scriptName = ScriptingUtils.getScriptName(this.getClass());

    public String getBaseUrl() {
        return TestContext.getCurrent().getBaseUrl();
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setBaseUrl(String baseUrl) {
        TestContext.getCurrent().setBaseUrl(baseUrl);
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    @Override
    public void setWebDriver(WebDriver webDriver) {
        super.setWebDriver(webDriver);
        webDriver.manage().timeouts().implicitlyWait(Duration.ofMillis(DEFAULT_IMPLICIT_WAIT_TIMEOUT));
    }

    @Test
    public void test() throws Exception {
        this.executeScript(this.getScriptName());
    }

    protected void executeScript(String scriptName) throws Exception {
        ParameterCheckUtils.isNotNullOrEmpty(scriptName, "scriptName");
        try (XlteniumScriptInterpreter interpreter = new XlteniumScriptInterpreter(this.getWebDriver());){
            interpreter.executeScript(scriptName);
        }
    }

    @Before
    public final void __setUpAbstractScriptTestCase() {
        TestContext.getCurrent().pushScope(this);
    }

    @After
    public final void __cleanUpAbstractScriptTestCase() {
        TestContext.getCurrent().shutDown();
    }
}

