/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import java.net.URL;
import java.util.regex.Pattern;
import org.htmlunit.WebRequest;

public class RequestFilter {
    private String protocol = null;
    private String hostPattern = null;
    private int port = -1;
    private String pathPattern = null;
    private String queryPattern = null;
    private String urlPattern;

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHostPattern() {
        return this.hostPattern;
    }

    public void setHostPattern(String regex) {
        this.hostPattern = regex;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public void setPathPattern(String regex) {
        this.pathPattern = regex;
    }

    public String getQueryPattern() {
        return this.queryPattern;
    }

    public void setQueryPattern(String regex) {
        this.queryPattern = regex;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String regex) {
        this.urlPattern = regex;
    }

    public boolean accepts(WebRequest request) {
        if (request == null) {
            return false;
        }
        URL url = request.getUrl();
        if (this.urlPattern != null) {
            return Pattern.matches(this.urlPattern, url.toString());
        }
        if (this.protocol != null && !url.getProtocol().equalsIgnoreCase(this.protocol)) {
            return false;
        }
        if (this.hostPattern != null && !Pattern.matches(this.hostPattern, url.getHost())) {
            return false;
        }
        if (this.port > 0 && this.port != url.getPort()) {
            return false;
        }
        if (this.pathPattern != null && !Pattern.matches(this.pathPattern, url.getPath())) {
            return false;
        }
        return this.queryPattern == null || Pattern.matches(this.queryPattern, url.getQuery());
    }
}

