/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.common.util.zip.ZipUtils;
import com.xceptance.xlt.agent.AgentInfo;
import com.xceptance.xlt.agentcontroller.AgentImpl;
import com.xceptance.xlt.agentcontroller.AgentListener;
import com.xceptance.xlt.agentcontroller.AgentManager;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.util.FileReplicationIndex;
import com.xceptance.xlt.util.FileReplicationUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentManagerImpl
implements AgentManager,
AgentListener {
    private static final Logger log = LoggerFactory.getLogger(AgentManagerImpl.class);
    private static final IOFileFilter NO_RESULTBROWSER_FILTER = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.makeDirectoryOnly((IOFileFilter)new NameFileFilter("output")));
    private static final IOFileFilter NO_AGENTLOG_FILTER = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)new WildcardFileFilter("agent*.log")));
    private static final IOFileFilter NO_TIMERS_FILTER = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)new NameFileFilter("timers.csv")));
    private static final IOFileFilter NO_AGENTLOG_NO_RESULTBROWSER_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{NO_RESULTBROWSER_FILTER, NO_AGENTLOG_FILTER});
    private static final IOFileFilter NO_AGENTLOG_NO_TIMERS_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{NO_AGENTLOG_FILTER, NO_TIMERS_FILTER});
    private static final IOFileFilter NO_RESULTBROWSER_NO_TIMERS_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{NO_RESULTBROWSER_FILTER, NO_TIMERS_FILTER});
    private AgentImpl agent;
    private final AgentInfo agentInfo;
    private final String[] commandLine;
    private final AgentListener agentListener;
    private final AtomicInteger unexpectedAgentExitCode = new AtomicInteger(0);

    public AgentManagerImpl(AgentInfo agentInfo, String[] commandLine, AgentListener agentListener) {
        this.agentInfo = agentInfo;
        this.commandLine = commandLine;
        this.agentListener = agentListener;
    }

    @Override
    public void setupEnvironment() throws IOException {
        FileUtils.forceMkdir((File)this.agentInfo.getAgentDirectory());
    }

    @Override
    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    @Override
    public AgentImpl getAgent() {
        return this.agent;
    }

    @Override
    public String[] getCommandLine() {
        return this.commandLine;
    }

    @Override
    public void startAgent(List<TestUserConfiguration> loadProfile) throws Exception {
        this.unexpectedAgentExitCode.set(0);
        this.agent = new AgentImpl(this.getAgentInfo().getAgentID(), this.getCommandLine(), this.getAgentInfo().getResultsDirectory(), loadProfile, this, this.getAgentInfo().getAgentDirectory());
        this.verifyAgentRunning();
    }

    @Override
    public boolean archiveAgentResults(TestResultAmount testResultAmount, File zipFile) {
        return AgentManagerImpl.archiveAgentResults(this.getAgentInfo().getResultsDirectory(), testResultAmount, zipFile, this.agentInfo.getAgentID());
    }

    public static boolean archiveAgentResults(File directory, TestResultAmount testResultAmount, File zipFile, String marker) {
        boolean wasSuccessful = false;
        try {
            log.info(marker + ": Prepare zipping");
            IOFileFilter fileFilter = switch (testResultAmount) {
                case TestResultAmount.MEASUREMENTS_AND_RESULTBROWSER -> NO_AGENTLOG_FILTER;
                case TestResultAmount.MEASUREMENTS_ONLY -> NO_AGENTLOG_NO_RESULTBROWSER_FILTER;
                case TestResultAmount.MEASUREMENTS_AND_LOGS -> NO_RESULTBROWSER_FILTER;
                case TestResultAmount.RESULTBROWSER_AND_LOGS -> NO_TIMERS_FILTER;
                case TestResultAmount.RESULTBROWSER_ONLY -> NO_AGENTLOG_NO_TIMERS_FILTER;
                case TestResultAmount.LOGS_ONLY -> NO_RESULTBROWSER_NO_TIMERS_FILTER;
                default -> null;
            };
            if (directory.exists()) {
                log.debug(marker + ": Zip agent results '" + String.valueOf(directory) + "' to '" + String.valueOf(zipFile) + "' ...");
                ZipUtils.zipDirectory(directory, (FileFilter)fileFilter, zipFile);
                log.debug(marker + ": Zip finished.");
                wasSuccessful = true;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return wasSuccessful;
    }

    @Override
    public FileReplicationIndex getAgentFilesIndex() {
        if (this.getAgentInfo().getAgentDirectory().exists()) {
            return FileReplicationUtils.getIndex(this.getAgentInfo().getAgentDirectory(), (FileFilter)FileFilterUtils.makeSVNAware(null));
        }
        return null;
    }

    @Override
    public void removeResultsDirectory() {
        try {
            File agentResultsDir = this.getAgentInfo().getResultsDirectory();
            if (agentResultsDir.exists() && !com.xceptance.common.io.FileUtils.deleteDirectoryRelaxed(agentResultsDir)) {
                log.warn(this.agentInfo.getAgentID() + ": Unable to remove " + String.valueOf(agentResultsDir.getAbsoluteFile()));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setAgentStatus(AgentStatus status) {
        AgentImpl agent = this.getAgent();
        if (agent != null) {
            agent.setStatus(status);
        }
    }

    @Override
    public boolean isAgentRunning() {
        return this.agent != null ? this.agent.isRunning() : false;
    }

    @Override
    public List<TestUserConfiguration> getAgentLoadProfile() {
        return this.agent != null ? this.agent.getLoadProfile() : null;
    }

    @Override
    public AgentStatus getAgentStatus() {
        AgentStatus agentStatus = this.agent != null ? this.agent.getStatus() : null;
        int unexpectedExitCode = this.unexpectedAgentExitCode.get();
        if (unexpectedExitCode != 0) {
            if (agentStatus == null) {
                agentStatus = new AgentStatus();
                agentStatus.setAgentID(this.getAgentInfo().getAgentID());
                agentStatus.setHostName(this.commandLine[3]);
            }
            agentStatus.setErrorExitCode(unexpectedExitCode);
        }
        return agentStatus;
    }

    @Override
    public void resetAgentStatus() {
        if (this.agent != null && !this.agent.isRunning()) {
            this.agent.setStatus(null);
        }
    }

    @Override
    public void stopAgent() {
        if (this.isAgentRunning()) {
            log.debug(this.agentInfo.getAgentID() + ": Stopping ...");
            this.agent.stop();
            log.debug(this.agentInfo.getAgentID() + ": Stopped");
        }
    }

    @Override
    public void updateAgentFiles(File sourceDir) {
        try {
            String relativePath;
            FileReplicationIndex srcIndex = FileReplicationUtils.getIndex(sourceDir, (FileFilter)FileFilterUtils.makeSVNAware(null));
            FileReplicationIndex dstIndex = this.getAgentInfo().getAgentDirectory().exists() ? FileReplicationUtils.getIndex(this.getAgentInfo().getAgentDirectory(), (FileFilter)FileFilterUtils.makeSVNAware(null)) : new FileReplicationIndex();
            ArrayList<File> filesToBeDeleted = new ArrayList<File>();
            ArrayList<File> filesToBeUpdated = new ArrayList<File>();
            FileReplicationUtils.compareIndexes(srcIndex, dstIndex, filesToBeUpdated, filesToBeDeleted);
            log.info(this.agentInfo.getAgentID() + ": Deleting obsolete agent files");
            for (File file : filesToBeDeleted) {
                relativePath = file.getPath().replace('\\', '/');
                File absoluteFile = new File(this.getAgentInfo().getAgentDirectory(), relativePath);
                log.debug(this.agentInfo.getAgentID() + ": Deleting file '" + String.valueOf(absoluteFile) + "' ...");
                try {
                    com.xceptance.common.io.FileUtils.deleteDirectoryRelaxed(absoluteFile);
                }
                catch (IllegalArgumentException e) {
                    log.debug("Failed to delete directory", (Throwable)e);
                }
            }
            log.info(this.agentInfo.getAgentID() + ": Installing new and updated files");
            for (File file : filesToBeUpdated) {
                relativePath = file.getPath().replace('\\', '/');
                File srcFile = new File(sourceDir, relativePath);
                File dstFile = new File(this.getAgentInfo().getAgentDirectory(), relativePath);
                log.debug(this.agentInfo.getAgentID() + ": Installing file '" + String.valueOf(dstFile) + "' ...");
                if (srcFile.isDirectory()) {
                    FileUtils.forceMkdir((File)dstFile);
                    continue;
                }
                FileUtils.copyFile((File)srcFile, (File)dstFile);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void agentStopped(String agentID) {
        log.debug(this.agentInfo.getAgentID() + ": Agent stopped.");
    }

    @Override
    public void agentExitedUnexpectedly(String agentID, int exitCode) {
        this.unexpectedAgentExitCode.set(exitCode);
        log.debug(this.agentInfo.getAgentID() + ": Agent has unclear exit code: " + exitCode);
        this.agentListener.agentExitedUnexpectedly(agentID, exitCode);
    }

    @Override
    public void close() throws IOException {
        this.stopAgent();
        com.xceptance.common.io.FileUtils.deleteDirectoryRelaxed(this.agentInfo.getAgentDirectory());
    }

    @Override
    public void setTotalAgentCount(int totalAgentCount) {
        this.agentInfo.setTotalAgentCount(totalAgentCount);
        if (this.commandLine.length > 5) {
            this.commandLine[5] = String.valueOf(totalAgentCount);
        }
    }

    @Override
    public void setAgentNumber(int agentNumber) {
        this.agentInfo.setAgentNumber(agentNumber);
        if (this.commandLine.length > 4) {
            this.commandLine[4] = String.valueOf(agentNumber);
        }
    }

    protected void verifyAgentRunning() throws Exception {
        Duration timeout = Duration.ofMillis(5000L);
        AgentStatus status = this.waitForAgentStatus(timeout);
        if (status != null) {
            int exitCode = status.getErrorExitCode();
            if (exitCode > 0) {
                throw new Exception("Agent process terminated right after start with exit code '" + exitCode + "'");
            }
        } else if (!this.isAgentRunning()) {
            throw new Exception("Agent process is not running and did not report any status within " + timeout.getSeconds() + " seconds");
        }
    }

    private AgentStatus waitForAgentStatus(Duration maxWaitingTime) {
        AgentStatus status;
        Instant deadline = Instant.now().plus(maxWaitingTime);
        while ((status = this.getAgentStatus()) == null && !Instant.now().isAfter(deadline)) {
            ThreadUtils.sleep(250L);
        }
        return status;
    }
}

