/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.caucho.hessian.server.HessianServlet;
import com.xceptance.common.util.zip.ZipUtils;
import com.xceptance.xlt.agent.AgentInfo;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.AgentControllerConfiguration;
import com.xceptance.xlt.agentcontroller.AgentControllerStatus;
import com.xceptance.xlt.agentcontroller.AgentFileManager;
import com.xceptance.xlt.agentcontroller.AgentListener;
import com.xceptance.xlt.agentcontroller.AgentManager;
import com.xceptance.xlt.agentcontroller.AgentManagerImpl;
import com.xceptance.xlt.agentcontroller.AgentStatus;
import com.xceptance.xlt.agentcontroller.AgentStatusInfo;
import com.xceptance.xlt.agentcontroller.FileManager;
import com.xceptance.xlt.agentcontroller.FileManagerImpl;
import com.xceptance.xlt.agentcontroller.FileManagerServlet;
import com.xceptance.xlt.agentcontroller.ResultArchives;
import com.xceptance.xlt.agentcontroller.ScenarioStatus;
import com.xceptance.xlt.agentcontroller.SimpleLoginService;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.agentcontroller.TestUserStatus;
import com.xceptance.xlt.util.AgentControllerSystemInfo;
import com.xceptance.xlt.util.FileReplicationIndex;
import com.xceptance.xlt.util.StatusUtils;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipOutputStream;
import javax.servlet.Servlet;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentControllerImpl
implements AgentController {
    private static final Logger log = LoggerFactory.getLogger(AgentControllerImpl.class);
    private static final String LOCALHOST_NAME = "localhost";
    private static final String AGENT_RESULTS_FILE_PREFIX = "agentresults_";
    private static final String AGENT_RESULTS_FILE_EXTENSION = ".zip";
    private final Map<String, AgentManager> agentManagers = new ConcurrentHashMap<String, AgentManager>();
    private FileManager fileManager;
    private File agentsDirectory;
    private File transferDirectory;
    private long referenceTimeDifference = 0L;
    private String[] agentBaseCommandLine;
    private volatile String name;
    private volatile int weight = 0;
    private volatile int agentCount = 0;
    private volatile int agentBaseNumber = 0;
    private AgentFileManager agentFileManager;
    private volatile URL url;
    private File tempDir;
    private File tempConfigArchiveFile;
    private volatile Status status = Status.NEW;
    private volatile boolean runsClientPerformanceTests;
    private final ResultArchives archives = new ResultArchives();
    private final AgentControllerConfiguration agentControllerConfig;
    private volatile boolean isUpdateDone = false;
    private volatile Exception updateException;

    public AgentControllerImpl(Properties commandLineProperties) throws Exception {
        this.agentControllerConfig = new AgentControllerConfiguration(commandLineProperties);
        this.prepare();
        this.startServlet();
    }

    protected void prepare() throws IOException {
        this.agentsDirectory = this.agentControllerConfig.getAgentsDirectory();
        this.transferDirectory = this.tempDir = this.agentControllerConfig.getTempDir();
        FileUtils.forceMkdir((File)this.agentsDirectory);
        String[] agentCmdLine = this.agentControllerConfig.getAgentCommandLine();
        int argSize = agentCmdLine.length;
        this.agentBaseCommandLine = new String[argSize];
        System.arraycopy(agentCmdLine, 0, this.agentBaseCommandLine, 0, argSize);
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.fileManager = new FileManagerImpl(this.transferDirectory);
        File updateManagerDirectory = new File(this.getTransferDirectory(), "xltUpdate_" + UUID.randomUUID().toString());
        this.agentFileManager = new AgentFileManager(updateManagerDirectory);
    }

    @Override
    public void init(String name, URL url, int weight, int agentCount, int agentBaseNumber, boolean runsClientPerformanceTests) throws IOException {
        this.weight = weight;
        this.agentCount = agentCount;
        this.agentBaseNumber = agentBaseNumber;
        this.name = name;
        this.url = url;
        this.runsClientPerformanceTests = runsClientPerformanceTests;
    }

    @Override
    public void setTotalAgentCount(int totalAgentCount) {
        for (AgentManager agentManager : this.getAgentManagers().values()) {
            agentManager.setTotalAgentCount(totalAgentCount);
        }
    }

    protected void startServlet() throws Exception {
        log.info("start servlet");
        Server server = new Server();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(this.agentControllerConfig.getKeyStoreFile().getPath());
        sslContextFactory.setKeyStorePassword(this.agentControllerConfig.getKeyStorePassword());
        sslContextFactory.setKeyManagerPassword(this.agentControllerConfig.getKeyPassword());
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
        HttpConfiguration httpsConfiguration = new HttpConfiguration();
        httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpsConfiguration);
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory});
        sslConnector.setHost(this.agentControllerConfig.getHostName());
        sslConnector.setPort(this.agentControllerConfig.getPort());
        server.addConnector((Connector)sslConnector);
        ServletContextHandler context = new ServletContextHandler(1);
        FileManagerServlet fileManagerServlet = new FileManagerServlet(this.transferDirectory);
        context.addServlet(new ServletHolder((Servlet)fileManagerServlet), "/fileManager/*");
        HessianServlet hessianServlet = new HessianServlet();
        hessianServlet.setHome((Object)this);
        context.addServlet(new ServletHolder((Servlet)hessianServlet), "/" + AgentController.class.getName());
        server.setHandler((Handler)context);
        String userName = this.agentControllerConfig.getUserName();
        String password = this.agentControllerConfig.getPassword();
        if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
            String roleName = "user";
            String realmName = "XLT Agent Controller";
            Constraint constraint = new Constraint("BASIC", "user");
            constraint.setAuthenticate(true);
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setConstraint(constraint);
            constraintMapping.setPathSpec("/*");
            SimpleLoginService loginService = new SimpleLoginService();
            loginService.setName("XLT Agent Controller");
            loginService.putUser(userName, Credential.getCredential((String)password), new String[]{"user"});
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
            securityHandler.setRealmName("XLT Agent Controller");
            securityHandler.addConstraintMapping(constraintMapping);
            securityHandler.setLoginService((LoginService)loginService);
            context.setSecurityHandler((SecurityHandler)securityHandler);
        }
        try {
            server.start();
        }
        catch (Exception e) {
            try {
                server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.agentBaseCommandLine[1] = Integer.toString(sslConnector.getLocalPort());
    }

    protected void setupAgentManagers() {
        int realAgentCountLength = String.valueOf(this.getAgentCount() - 1).length();
        int usedAgentCountLength = realAgentCountLength > 2 ? realAgentCountLength : 2;
        int maxAgentNumber = this.getAgentBaseNumber() + this.getAgentCount() - 1;
        String[] baseCommandLine = this.getAgentBaseCommandLine();
        int commandSize = baseCommandLine != null ? baseCommandLine.length : 0;
        String agentHostname = this.getHostname();
        URL acUrl = this.getUrl();
        String acRemoteAddress = acUrl != null ? acUrl.getHost() + ":" + acUrl.getPort() : (baseCommandLine != null ? agentHostname + ":" + baseCommandLine[1] : null);
        HashSet<String> agentManagers2close = new HashSet<String>(this.getAgentManagers().keySet());
        for (int agentNumber = this.getAgentBaseNumber(); agentNumber <= maxAgentNumber; ++agentNumber) {
            String string = this.getName() + "_" + StringUtils.leftPad((String)String.valueOf(agentNumber - this.getAgentBaseNumber()), (int)usedAgentCountLength, (char)'0');
            if (!this.getAgentManagers().containsKey(string)) {
                File agentDirectory = new File(this.getAgentsDirectory(), string);
                AgentInfo agentInfo = new AgentInfo(string, agentDirectory);
                String[] currentCommandLine = new String[commandSize];
                if (commandSize >= 5) {
                    System.arraycopy(baseCommandLine, 0, currentCommandLine, 0, commandSize);
                    currentCommandLine[2] = string;
                    currentCommandLine[3] = agentHostname;
                    if (commandSize > 6) {
                        currentCommandLine[6] = acRemoteAddress;
                    }
                }
                try {
                    AgentListener listener = new AgentListener(){

                        @Override
                        public void agentExitedUnexpectedly(String agentID, int exitCode) {
                            if (!Status.ABORTED.equals((Object)AgentControllerImpl.this.status)) {
                                log.error("Agent " + agentID + "@" + AgentControllerImpl.this.getHostname() + " exited unexpectedly (exit code: " + exitCode + ").");
                            }
                        }

                        @Override
                        public void agentStopped(String agentID) {
                        }
                    };
                    AgentManagerImpl agentManager = new AgentManagerImpl(agentInfo, currentCommandLine, listener);
                    this.setupEnvironment(agentManager);
                    this.getAgentManagers().put(string, agentManager);
                }
                catch (Exception e) {
                    log.error("unable to create agent manager for agent ID " + string);
                }
            } else {
                agentManagers2close.remove(string);
            }
            this.getAgentManagers().get(string).setAgentNumber(agentNumber);
        }
        for (String string : agentManagers2close) {
            AgentManager agentManager = this.getAgentManagers().remove(string);
            try {
                agentManager.close();
            }
            catch (IOException e) {
                log.warn("unable to close agent manager for ID " + string);
            }
        }
    }

    protected void setupEnvironment(AgentManager agentManager) throws IOException {
        agentManager.setupEnvironment();
    }

    protected int getAgentBaseNumber() {
        return this.agentBaseNumber;
    }

    @Override
    public int getAgentCount() {
        return this.agentCount;
    }

    protected AgentManager getAgentManager(String agentID) {
        return this.getAgentManagers().get(agentID);
    }

    @Override
    public FileManager getFileManager() {
        return this.fileManager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public void setReferenceTime(long time) {
        this.referenceTimeDifference = time - System.currentTimeMillis();
        log.debug("Difference between master controller's time and local time: " + this.referenceTimeDifference);
    }

    @Override
    public long getReferenceTimeDifference() {
        return this.referenceTimeDifference;
    }

    public String toString() {
        return this.getName();
    }

    protected File getAgentsDirectory() {
        return this.agentsDirectory;
    }

    @Override
    public List<TestUserConfiguration> getAgentLoadProfile(String agentID) {
        AgentManager agentManager = this.getAgentManager(agentID);
        if (agentManager != null) {
            return agentManager.getAgentLoadProfile();
        }
        return null;
    }

    @Override
    public Set<AgentStatus> getAgentStatus() {
        HashSet<AgentStatus> result = new HashSet<AgentStatus>();
        for (AgentManager agentManager : this.getAgentManagers().values()) {
            AgentStatus status = agentManager.getAgentStatus();
            if (status == null) continue;
            result.add(status);
        }
        return result;
    }

    @Override
    public AgentControllerStatus getStatus() {
        ArrayList<AgentStatusInfo> agentStatusList = new ArrayList<AgentStatusInfo>();
        ArrayList<TestUserStatus> userStatusList = new ArrayList<TestUserStatus>();
        for (Map.Entry<String, AgentManager> agentManagerEntry : this.getAgentManagers().entrySet()) {
            AgentStatusInfo agentStatusInfo;
            String agentId = agentManagerEntry.getKey();
            AgentManager agentManager = agentManagerEntry.getValue();
            boolean isAgentRunning = agentManager.isAgentRunning();
            AgentStatus agentStatus = agentManager.getAgentStatus();
            if (agentStatus != null) {
                exitCode = isAgentRunning ? null : Integer.valueOf(agentStatus.getErrorExitCode());
                agentStatusInfo = new AgentStatusInfo(agentId, agentStatus.getHostName(), isAgentRunning, exitCode);
                userStatusList.addAll(agentStatus.getTestUserStatusList());
            } else {
                exitCode = isAgentRunning ? null : Integer.valueOf(0);
                agentStatusInfo = new AgentStatusInfo(agentId, "", isAgentRunning, exitCode);
            }
            agentStatusList.add(agentStatusInfo);
        }
        List<ScenarioStatus> scenarioStatusList = StatusUtils.aggregateUserStatusList(userStatusList);
        return new AgentControllerStatus(agentStatusList, scenarioStatusList);
    }

    protected File getTransferDirectory() {
        return this.transferDirectory;
    }

    @Override
    public boolean hasRunningAgent() {
        boolean result = false;
        for (AgentManager agentManager : this.getAgentManagers().values()) {
            if (!agentManager.isAgentRunning()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void startAgents(Map<String, List<TestUserConfiguration>> loadProfiles) {
        log.info("Start agents ...");
        for (Map.Entry<String, AgentManager> itemEntry : this.getAgentManagers().entrySet()) {
            String agentID = itemEntry.getKey();
            AgentManager agentManager = itemEntry.getValue();
            log.debug("Starting process: " + StringUtils.join((Object[])agentManager.getCommandLine(), (char)' '));
            List<TestUserConfiguration> loadProfile = loadProfiles.get(agentID);
            if (loadProfile == null || loadProfile.isEmpty()) continue;
            try {
                agentManager.startAgent(loadProfile);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.status = Status.RUNNING;
        log.info("Agents started");
    }

    @Override
    public void stopAgents() {
        log.info("Stopping agents ...");
        if (this.hasRunningAgent()) {
            this.status = Status.ABORTED;
        }
        for (AgentManager agentManager : this.getAgentManagers().values()) {
            agentManager.stopAgent();
        }
        log.info("Agents stopped");
    }

    @Override
    public void archiveAgentResults(final TestResultAmount testResultAmount) {
        final ResultArchives.ArchiveToken archiveToken = this.archives.requestCreating();
        if (archiveToken != null) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block10: {
                        log.info("Archive agent results ...");
                        try {
                            if (!AgentControllerImpl.this.getAgentIDs().isEmpty()) {
                                for (String agentID : AgentControllerImpl.this.getAgentIDs()) {
                                    try {
                                        File zipFile = AgentControllerImpl.this.getTempFile(agentID);
                                        zipFile.deleteOnExit();
                                        boolean success = AgentControllerImpl.this.getAgentManager(agentID).archiveAgentResults(testResultAmount, zipFile);
                                        if (!success || AgentControllerImpl.this.archives.update(agentID, zipFile, archiveToken)) continue;
                                        break block10;
                                    }
                                    catch (Exception e) {
                                        log.warn("Unable to provide results file for agent ID " + agentID, (Throwable)e);
                                    }
                                }
                                break block10;
                            }
                            File[] agentDirectories = AgentControllerImpl.this.agentsDirectory.listFiles((FileFilter)FileFilterUtils.directoryFileFilter());
                            if (agentDirectories == null) break block10;
                            for (File directory : agentDirectories) {
                                File resultsDirectory = new File(directory, "results");
                                if (!resultsDirectory.isDirectory()) continue;
                                String agentID = directory.getName();
                                try {
                                    File zipFile = AgentControllerImpl.this.getTempFile(agentID);
                                    boolean success = AgentManagerImpl.archiveAgentResults(resultsDirectory, testResultAmount, zipFile, agentID);
                                    if (!success || AgentControllerImpl.this.archives.update(agentID, zipFile, archiveToken)) continue;
                                    break;
                                }
                                catch (Exception e) {
                                    log.warn("Unable to provide results file for agent ID " + agentID, (Throwable)e);
                                }
                            }
                        }
                        finally {
                            log.debug("Remove old agent results archives");
                            AgentControllerImpl.this.archives.setReadyForDownload(archiveToken);
                        }
                    }
                }
            }.start();
        }
    }

    private File getTempFile(String coreName) throws IOException {
        return File.createTempFile(AGENT_RESULTS_FILE_PREFIX + coreName + "_", AGENT_RESULTS_FILE_EXTENSION, this.tempDir);
    }

    @Override
    public Set<String> getAgentIDs() {
        return this.getAgentManagers().keySet();
    }

    @Override
    public String getHostname() {
        return StringUtils.defaultString((String)this.agentControllerConfig.getHostName(), (String)LOCALHOST_NAME);
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    protected String[] getAgentBaseCommandLine() {
        return this.agentBaseCommandLine;
    }

    protected Map<String, AgentManager> getAgentManagers() {
        return this.agentManagers;
    }

    @Override
    public FileReplicationIndex getAgentFilesIndex() throws IOException {
        this.setupAgentManagers();
        for (String agentID : this.getAgentIDs()) {
            this.getAgentManager(agentID).removeResultsDirectory();
        }
        FileReplicationIndex fri = this.agentFileManager.getAgentFilesIndex();
        return fri != null ? fri : new FileReplicationIndex();
    }

    @Override
    public void updateAgentFiles(final String agentFilesZipFileName, final List<File> filesToBeDeleted) throws IOException {
        this.isUpdateDone = false;
        this.updateException = null;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    log.debug("Remove old agent results archives");
                    AgentControllerImpl.this.archives.clear();
                    if (AgentControllerImpl.this.tempConfigArchiveFile != null) {
                        FileUtils.deleteQuietly((File)AgentControllerImpl.this.tempConfigArchiveFile);
                    }
                    AgentControllerImpl.this.tempConfigArchiveFile = null;
                    File zipFile = new File(AgentControllerImpl.this.getTransferDirectory(), agentFilesZipFileName);
                    log.info("Update agent files ...");
                    AgentControllerImpl.this.agentFileManager.updateAgentFiles(zipFile, filesToBeDeleted, AgentControllerImpl.this.getAgentManagers().values());
                    log.info("Remove orphaned agent directories");
                    String[] filenames = AgentControllerImpl.this.getAgentsDirectory().list((FilenameFilter)FileFilterUtils.makeSVNAware(null));
                    if (filenames != null) {
                        for (String filename : filenames) {
                            if (AgentControllerImpl.this.getAgentIDs().contains(filename)) continue;
                            FileUtils.deleteQuietly((File)new File(AgentControllerImpl.this.getAgentsDirectory(), filename));
                        }
                    }
                    log.info("Update of agent files finished");
                    log.debug("Clean up agent files");
                    FileUtils.deleteQuietly((File)zipFile);
                    AgentControllerImpl.this.status = Status.UPLOADED;
                }
                catch (Exception e) {
                    log.error("Failed to update agent files", (Throwable)e);
                    AgentControllerImpl.this.updateException = e;
                }
                finally {
                    AgentControllerImpl.this.isUpdateDone = true;
                }
            }
        }.start();
    }

    @Override
    public boolean isUpdateDone() throws Exception {
        if (this.updateException != null) {
            throw this.updateException;
        }
        return this.isUpdateDone;
    }

    @Override
    public void setUpdateAcknowledged() {
        this.isUpdateDone = false;
    }

    @Override
    public void setAgentStatus(AgentStatus agentStatus) {
        this.getAgentManager(agentStatus.getAgentID()).setAgentStatus(agentStatus);
    }

    @Override
    public void resetAgentsStatus() {
        log.debug("Reset agent statuses");
        for (AgentManager agentManager : this.getAgentManagers().values()) {
            agentManager.resetAgentStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String archiveTestConfig() {
        if (this.tempConfigArchiveFile == null || !this.tempConfigArchiveFile.exists()) {
            String confDirPath = "./config";
            File[] agentDirectories = this.getAgentsDirectory().listFiles((FileFilter)FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.directoryFileFilter()));
            if (agentDirectories != null) {
                for (File directory : agentDirectories) {
                    File configDirectory = new File(directory, "config");
                    if (!configDirectory.isDirectory() || !configDirectory.canRead()) continue;
                    IOFileFilter propertiesFilesFilter = FileFilterUtils.suffixFileFilter((String)".properties");
                    IOFileFilter cfgFilesFilter = FileFilterUtils.suffixFileFilter((String)".cfg");
                    IOFileFilter xmlFilesFilter = FileFilterUtils.suffixFileFilter((String)".xml");
                    IOFileFilter jsonFilesFilter = FileFilterUtils.suffixFileFilter((String)".json");
                    IOFileFilter extensionFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{propertiesFilesFilter, cfgFilesFilter, xmlFilesFilter, jsonFilesFilter});
                    IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFileFilter.INSTANCE, extensionFilter});
                    ZipOutputStream out = null;
                    try {
                        File tempfile = File.createTempFile("testconfig-", AGENT_RESULTS_FILE_EXTENSION, this.getTransferDirectory());
                        tempfile.deleteOnExit();
                        out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tempfile)));
                        ZipUtils.addDirectoryEntry(out, "./config");
                        this.addMaskedDirectory(out, configDirectory, filter, new File("./config"));
                        this.addIncludedPropertyFiles(out, configDirectory, "./config");
                        this.tempConfigArchiveFile = tempfile;
                        IOUtils.closeQuietly((OutputStream)out);
                        break;
                    }
                    catch (Exception e) {
                        log.warn("Unable to archive test configuration", (Throwable)e);
                    }
                    finally {
                        IOUtils.closeQuietly(out);
                    }
                }
            }
        }
        return this.tempConfigArchiveFile != null ? this.tempConfigArchiveFile.getName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMaskedDirectory(ZipOutputStream out, File configDirectory, IOFileFilter filter, File configPath) throws IOException, ConfigurationException {
        File tempDir = Files.createTempDirectory("masked", new FileAttribute[0]).toFile();
        try {
            FileUtils.copyDirectory((File)configDirectory, (File)tempDir, (FileFilter)filter);
            for (File fileToMask : FileUtils.listFiles((File)tempDir, null, (boolean)true)) {
                if (!fileToMask.getAbsolutePath().endsWith(".properties")) continue;
                AgentControllerImpl.maskFile(fileToMask, fileToMask);
            }
            ZipUtils.zipDirectory(out, tempDir, (FileFilter)filter, configPath);
        }
        finally {
            FileUtils.deleteDirectory((File)tempDir);
        }
    }

    private static void maskFile(File inputFile, File outputFile) throws ConfigurationException, IOException {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory());
        try (FileReader reader = new FileReader(inputFile);){
            config.read((Reader)reader);
        }
        config = AgentControllerImpl.mask(config, inputFile.getName().equals("secret.properties"));
        StringWriter writer = new StringWriter();
        config.write((Writer)writer);
        FileUtils.writeStringToFile((File)outputFile, (String)writer.toString(), (Charset)StandardCharsets.ISO_8859_1);
    }

    private static PropertiesConfiguration mask(PropertiesConfiguration config, boolean maskAll) {
        Iterator keys = config.getKeys();
        PropertiesConfiguration output = (PropertiesConfiguration)config.clone();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!maskAll && !key.startsWith("secret.")) continue;
            output.setProperty(key, (Object)"******");
        }
        return output;
    }

    private void addIncludedPropertyFiles(ZipOutputStream out, File configDirectory, String confDirPath) throws IOException {
        List<String> resolvedPropertyFiles;
        try {
            FileObject configDir = VFS.getManager().resolveFile(configDirectory.getAbsolutePath());
            XltPropertiesImpl props = new XltPropertiesImpl(configDir.getParent(), configDir, false, true);
            resolvedPropertyFiles = props.getUsedPropertyFilesByRelativeName();
        }
        catch (Throwable ex) {
            log.error("Failed to determine resolved property includes", ex);
            return;
        }
        int confDirAncestors = com.xceptance.common.io.FileUtils.getNumberOfAncestors(configDirectory);
        HashSet<String> added = new HashSet<String>();
        added.add(configDirectory.getCanonicalPath());
        for (int i = 0; i < resolvedPropertyFiles.size(); ++i) {
            String path = resolvedPropertyFiles.get(i);
            File current = new File(configDirectory, path);
            String currentCanonicalPath = current.getCanonicalPath();
            int currentAncestors = com.xceptance.common.io.FileUtils.getNumberOfAncestors(current);
            if (!current.exists() || added.contains(currentCanonicalPath) || current.getParentFile().equals(configDirectory) || confDirAncestors > currentAncestors) continue;
            this.addParentDirectories(current, confDirAncestors, added, out);
            added.add(currentCanonicalPath);
            ZipUtils.addRegularFile(out, current, confDirPath.concat("/").concat(path).replace('\\', '/'));
        }
    }

    private void addParentDirectories(File current, int topMostOnesToSkip, Set<String> added, ZipOutputStream out) throws IOException {
        List<File> parents = com.xceptance.common.io.FileUtils.getParents(current, topMostOnesToSkip);
        Object relPath = ".";
        for (int j = 0; j < parents.size(); ++j) {
            File fi = parents.get(j);
            relPath = (String)relPath + "/" + fi.getName();
            String fiCanonicalPath = fi.getCanonicalPath();
            if (added.contains(fiCanonicalPath)) continue;
            added.add(fiCanonicalPath);
            ZipUtils.addDirectoryEntry(out, ((String)relPath).replace('\\', '/'));
        }
    }

    @Override
    public void ping() {
    }

    @Override
    public AgentControllerSystemInfo info() {
        if (this.status.equals((Object)Status.RUNNING) && !this.hasRunningAgent()) {
            boolean hasAborted = false;
            Set<AgentStatus> agentStatuses = this.getAgentStatus();
            for (AgentStatus agentStatus : agentStatuses) {
                List<TestUserStatus> testUserStatuses = agentStatus.getTestUserStatusList();
                for (TestUserStatus testUserStatus : testUserStatuses) {
                    if (!testUserStatus.getState().equals((Object)TestUserStatus.State.Aborted)) continue;
                    hasAborted = true;
                    break;
                }
                if (!hasAborted) continue;
                break;
            }
            this.status = hasAborted ? Status.ABORTED : Status.FINISHED;
        }
        AgentControllerSystemInfo acSysInfo = new AgentControllerSystemInfo();
        acSysInfo.setStatus(this.status.toString());
        acSysInfo.setTime(System.currentTimeMillis());
        return acSysInfo;
    }

    @Override
    public Map<String, String> getAgentResultsArchives() {
        return this.archives.getArchives();
    }

    @Override
    public boolean isArchiveAvailable() {
        return this.archives.getState().equals((Object)ResultArchives.State.READY_FOR_DOWNLOAD);
    }

    @Override
    public void archiveDownloadDone() {
        log.debug("Clear agent results archives");
        this.archives.clear();
    }

    @Override
    public boolean runsClientPerformanceTests() {
        return this.runsClientPerformanceTests;
    }

    private static enum Status {
        NEW("Initialized"),
        UPLOADED("Uploaded"),
        RUNNING("Running"),
        FINISHED("Finished"),
        ABORTED("Aborted");

        private String s;

        private Status(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            for (AgentManager agentManager : AgentControllerImpl.this.getAgentManagers().values()) {
                agentManager.stopAgent();
            }
            if (AgentControllerImpl.this.agentFileManager != null) {
                try {
                    AgentControllerImpl.this.agentFileManager.clear();
                }
                catch (IOException e) {
                    log.error("Unable to delete agent file manager update directory", (Throwable)e);
                }
            }
        }
    }
}

