/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util.concurrent;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;

public class DaemonThreadFactory
implements ThreadFactory {
    private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
    private final AtomicInteger count = new AtomicInteger();
    private static final IntFunction<String> DEFAULT_NAME_GENERATOR = i -> "Thread-" + i;
    private final IntFunction<String> nameGenerator;
    private final int priority;

    public DaemonThreadFactory() {
        this(DEFAULT_NAME_GENERATOR, 5);
    }

    public DaemonThreadFactory(IntFunction<String> nameGenerator, int priority) {
        this.nameGenerator = nameGenerator == null ? DEFAULT_NAME_GENERATOR : nameGenerator;
        this.priority = priority;
    }

    public DaemonThreadFactory(IntFunction<String> nameGenerator) {
        this(nameGenerator, 5);
    }

    public DaemonThreadFactory(String threadNamePrefix) {
        this(i -> threadNamePrefix + i, 5);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.defaultThreadFactory.newThread(runnable);
        thread.setDaemon(true);
        thread.setPriority(this.priority);
        thread.setName(this.nameGenerator.apply(this.count.getAndIncrement()));
        return thread;
    }
}

