/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringMatcher {
    private final Pattern[] excludePatterns;
    private final Pattern[] includePatterns;
    private final boolean fullMatch;

    public StringMatcher(String includePatternsSpec, String excludePatternsSpec) {
        this(includePatternsSpec, excludePatternsSpec, false);
    }

    public StringMatcher(String includePatternsSpec, String excludePatternsSpec, boolean fullMatch) {
        this.includePatterns = this.buildPatternList(includePatternsSpec).toArray(new Pattern[0]);
        this.excludePatterns = this.buildPatternList(excludePatternsSpec).toArray(new Pattern[0]);
        this.fullMatch = fullMatch;
    }

    private List<Pattern> buildPatternList(String patternsString) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (patternsString != null) {
            for (String patternString : StringUtils.split((String)patternsString, (String)" ,;")) {
                Pattern pattern = Pattern.compile(patternString);
                patterns.add(pattern);
            }
        }
        return patterns;
    }

    public boolean isAccepted(String s) {
        Matcher matcher;
        Pattern pattern;
        int i;
        for (i = 0; i < this.excludePatterns.length; ++i) {
            pattern = this.excludePatterns[i];
            matcher = pattern.matcher(s);
            if ((this.fullMatch || !matcher.find()) && (!this.fullMatch || !matcher.matches())) continue;
            return false;
        }
        if (this.includePatterns.length == 0) {
            return true;
        }
        for (i = 0; i < this.includePatterns.length; ++i) {
            pattern = this.includePatterns[i];
            matcher = pattern.matcher(s);
            if ((this.fullMatch || !matcher.find()) && (!this.fullMatch || !matcher.matches())) continue;
            return true;
        }
        return false;
    }
}

