/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.collection.ConcurrentLRUCache;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class RegExUtils {
    private static final ConcurrentLRUCache<CacheKey, Pattern> patternCache = new ConcurrentLRUCache(5003);
    private static final ConcurrentLRUCache<String, String> resultCache = new ConcurrentLRUCache(1001);

    private RegExUtils() {
    }

    public static int getMatchingCount(String s, Pattern pattern) {
        int count = 0;
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static int getMatchingCount(String s, String regex) {
        return RegExUtils.getMatchingCount(s, RegExUtils.getPattern(regex));
    }

    public static Pattern getPattern(String regex) {
        return RegExUtils.getPattern(regex, 40);
    }

    public static Pattern getPattern(String regex, int flags) {
        CacheKey cacheKey = new CacheKey(regex, flags);
        Pattern pattern = patternCache.get(cacheKey);
        if (pattern == null) {
            pattern = Pattern.compile(regex, flags);
            patternCache.put(cacheKey, pattern);
        }
        return pattern;
    }

    public static boolean isMatching(String s, Pattern pattern) {
        Matcher matcher = pattern.matcher(s);
        return matcher.find();
    }

    public static boolean isMatching(String s, String regex) {
        return RegExUtils.isMatching(s, RegExUtils.getPattern(regex));
    }

    public static List<String> getAllMatches(String s, Pattern pattern) {
        return RegExUtils.getAllMatches(s, pattern, 0);
    }

    public static List<String> getAllMatches(String s, Pattern pattern, int matchingGroupIndex) {
        ArrayList<String> values = new ArrayList<String>();
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            String value = matcher.group(matchingGroupIndex);
            values.add(value);
        }
        return values;
    }

    public static List<String> getAllMatches(String s, String regex) {
        return RegExUtils.getAllMatches(s, RegExUtils.getPattern(regex), 0);
    }

    public static List<String> getAllMatches(String s, String regex, int matchingGroupIndex) {
        return RegExUtils.getAllMatches(s, RegExUtils.getPattern(regex), matchingGroupIndex);
    }

    public static String getFirstMatch(String s, Pattern pattern) {
        return RegExUtils.getFirstMatch(s, pattern, 0);
    }

    public static String getFirstMatch(String s, Pattern pattern, int matchingGroupIndex) {
        String value = null;
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            value = matcher.group(matchingGroupIndex);
        }
        return value;
    }

    public static String getFirstMatch(String s, String regex) {
        return RegExUtils.getFirstMatch(s, RegExUtils.getPattern(regex));
    }

    public static String getFirstMatch(String s, String regex, int matchingGroupIndex) {
        return RegExUtils.getFirstMatch(s, RegExUtils.getPattern(regex), matchingGroupIndex);
    }

    public static String replaceAll(String s, String regex, String replacement) {
        Pattern pattern = RegExUtils.getPattern(regex);
        Matcher matcher = pattern.matcher(s);
        return matcher.replaceAll(replacement);
    }

    public static String escape(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        String cachedVal = resultCache.get(s);
        if (cachedVal == null) {
            cachedVal = Pattern.quote(s);
            resultCache.put(s, cachedVal);
        }
        return cachedVal;
    }

    public static int getCaptureGroupCount(String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return -1;
        }
        pattern = RegExUtils.replaceAll(pattern, "\\\\.", "");
        pattern = RegExUtils.replaceAll(pattern, "\\[[^\\]]+\\]", "");
        return RegExUtils.getMatchingCount(pattern, "\\((?![?])");
    }

    public static String removeAll(String s, String regex) {
        return RegExUtils.removeAll(s, regex, 0);
    }

    public static String removeAll(String s, String regex, int group) {
        if (StringUtils.isEmpty((CharSequence)s) || StringUtils.isEmpty((CharSequence)regex)) {
            return s;
        }
        StringBuilder result = new StringBuilder(s);
        Matcher matcher = RegExUtils.getPattern(regex).matcher(s);
        int matchIndex = 0;
        while (matcher.find()) {
            String matching = matcher.group(0);
            String groupMatching = matcher.group(group);
            if (StringUtils.isEmpty((CharSequence)groupMatching)) break;
            String modifiedMatching = StringUtils.substringBefore((String)matching, (String)groupMatching) + StringUtils.substringAfter((String)matching, (String)groupMatching);
            result.replace(matcher.start() - matchIndex, matcher.end() - matchIndex, modifiedMatching);
            matchIndex += groupMatching.length();
            matcher.region(matcher.end(), s.length());
        }
        return result.toString();
    }

    static class CacheKey {
        private final String pattern;
        private final int flags;
        private final int hashCode;

        public CacheKey(String pattern, int flags) {
            this.pattern = pattern;
            this.flags = flags;
            int prime = 31;
            int result = 1;
            result = 31 * result + flags;
            this.hashCode = result = 31 * result + (pattern == null ? 0 : pattern.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.flags != other.flags) {
                return false;
            }
            return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern));
        }
    }
}

