/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.util.CsvParserException;
import com.xceptance.xlt.api.util.SimpleArrayList;
import com.xceptance.xlt.api.util.XltCharBuffer;

public final class CsvLineDecoder {
    private static final char COMMA = ',';
    private static final char QUOTE_CHAR = '\"';

    private CsvLineDecoder() {
    }

    public static SimpleArrayList<XltCharBuffer> parse(String s) {
        return CsvLineDecoder.parse(new SimpleArrayList<XltCharBuffer>(50), XltCharBuffer.valueOf(s));
    }

    public static SimpleArrayList<XltCharBuffer> parse(SimpleArrayList<XltCharBuffer> result, XltCharBuffer src) {
        int length = src.length();
        if (length == 0) {
            result.add(XltCharBuffer.EMPTY);
            return result;
        }
        int pos = 0;
        while (pos < length) {
            char c = src.charAt(pos);
            if (c == '\"') {
                pos = CsvLineDecoder.startQuotedCol(result, src, pos);
                continue;
            }
            pos = CsvLineDecoder.startCol(result, src, pos);
        }
        if (src.charAt(length - 1) == ',') {
            result.add(XltCharBuffer.EMPTY);
        }
        return result;
    }

    private static int startCol(SimpleArrayList<XltCharBuffer> result, XltCharBuffer src, int currentPos) {
        int pos;
        int length = src.length();
        int start = currentPos;
        for (pos = currentPos; pos < length; ++pos) {
            char c = src.charAt(pos);
            if (c != ',') continue;
            result.add(src.substring(start, pos));
            return pos + 1;
        }
        result.add(src.substring(start));
        return pos;
    }

    private static int startQuotedCol(SimpleArrayList<XltCharBuffer> result, XltCharBuffer src, int currentPos) {
        int pos;
        int length = src.length();
        int start = pos = currentPos + 1;
        while (pos < length) {
            char c = src.charAt(pos);
            if (c == '\"') {
                if (src.peakAhead(pos + 1) == '\"') {
                    pos = CsvLineDecoder.endQuotedQuotesCol(result, src, start, pos + 1);
                    return pos + 1;
                }
                result.add(src.substring(start, pos));
                char nextChar = src.peakAhead(++pos);
                if (nextChar != '\u0000' && nextChar != ',') {
                    throw new CsvParserException("Delimiter or end of line expected at pos: " + pos);
                }
                return pos + 1;
            }
            ++pos;
        }
        throw new CsvParserException("Quoted col has not been properly closed");
    }

    private static int endQuotedQuotesCol(SimpleArrayList<XltCharBuffer> result, XltCharBuffer src, int start, int currentPos) {
        int length = src.length();
        int pos = currentPos + 1;
        int offset = 1;
        while (pos < length) {
            char c = src.charAt(pos);
            src.put(pos - offset, c);
            if (c == '\"') {
                char nextChar = src.peakAhead(pos + 1);
                if (nextChar == '\"') {
                    ++offset;
                    pos += 2;
                    continue;
                }
                if (nextChar != '\u0000' && nextChar != ',') {
                    throw new CsvParserException("Delimiter or end of line expected at pos: " + pos);
                }
                result.add(src.substring(start, pos - offset));
                return pos + 1;
            }
            ++pos;
        }
        throw new CsvParserException("Quoted field with quotes was not ended properly at: " + pos);
    }
}

