/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.io;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoActionHandler {
    private static final Logger log = LoggerFactory.getLogger(IoActionHandler.class);
    private final int maxRetries;

    public IoActionHandler(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public <T> T run(IoAction<T> action) throws IOException {
        int remainingRetries = this.maxRetries;
        while (true) {
            try {
                return action.run();
            }
            catch (IOException e) {
                if (remainingRetries > 0) {
                    log.debug("Retry action because of: {}", (Object)e.toString());
                    --remainingRetries;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    @FunctionalInterface
    public static interface IoAction<T> {
        public T run() throws IOException;
    }
}

