/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.Serializable;
import java.util.function.Predicate;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(isJSObject=false)
public class RowContainer
extends HTMLElement {
    @JsxGetter
    public Object getRows() {
        HTMLCollection rows = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false);
        rows.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> node instanceof HtmlTableRow && this.isContainedRow((HtmlTableRow)node));
        return rows;
    }

    protected boolean isContainedRow(HtmlTableRow row) {
        return row.getParentNode() == this.getDomNodeOrDie();
    }

    @JsxFunction
    public void deleteRow(int rowIndex) {
        boolean rowIndexValid;
        HTMLCollection rows = (HTMLCollection)this.getRows();
        int rowCount = rows.getLength();
        if (rowIndex == -1) {
            rowIndex = rowCount - 1;
        }
        boolean bl = rowIndexValid = rowIndex >= 0 && rowIndex < rowCount;
        if (rowIndexValid) {
            HtmlUnitScriptable row = (HtmlUnitScriptable)rows.item(rowIndex);
            row.getDomNodeOrDie().remove();
        }
    }

    @JsxFunction
    public Object insertRow(Object index) {
        int rowIndex = -1;
        if (!JavaScriptEngine.isUndefined(index)) {
            rowIndex = (int)JavaScriptEngine.toNumber(index);
        }
        HTMLCollection rows = (HTMLCollection)this.getRows();
        int rowCount = rows.getLength();
        int r = rowIndex == -1 || rowIndex == rowCount ? Math.max(0, rowCount) : rowIndex;
        if (r < 0 || r > rowCount) {
            throw JavaScriptEngine.reportRuntimeError("Index or size is negative or greater than the allowed amount (index: " + rowIndex + ", " + rowCount + " rows)");
        }
        return this.insertRow(r);
    }

    public Object insertRow(int index) {
        HTMLCollection rows = (HTMLCollection)this.getRows();
        int rowCount = rows.getLength();
        DomElement newRow = ((HtmlPage)this.getDomNodeOrDie().getPage()).createElement("tr");
        if (rowCount == 0) {
            this.getDomNodeOrDie().appendChild(newRow);
        } else if (index == rowCount) {
            HtmlUnitScriptable row = (HtmlUnitScriptable)rows.item(index - 1);
            row.getDomNodeOrDie().getParentNode().appendChild(newRow);
        } else {
            HtmlUnitScriptable row = (HtmlUnitScriptable)rows.item(index);
            if (index > rowCount - 1) {
                row.getDomNodeOrDie().getParentNode().appendChild(newRow);
            } else {
                row.getDomNodeOrDie().insertBefore(newRow);
            }
        }
        return this.getScriptableFor(newRow);
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object moveRow(int sourceIndex, int targetIndex) {
        boolean targetIndexValid;
        HTMLCollection rows = (HTMLCollection)this.getRows();
        int rowCount = rows.getLength();
        boolean sourceIndexValid = sourceIndex >= 0 && sourceIndex < rowCount;
        boolean bl = targetIndexValid = targetIndex >= 0 && targetIndex < rowCount;
        if (sourceIndexValid && targetIndexValid) {
            HtmlUnitScriptable sourceRow = (HtmlUnitScriptable)rows.item(sourceIndex);
            HtmlUnitScriptable targetRow = (HtmlUnitScriptable)rows.item(targetIndex);
            targetRow.getDomNodeOrDie().insertBefore(sourceRow.getDomNodeOrDie());
            return sourceRow;
        }
        return null;
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }
}

