/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebAssert;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ES6Iterator;
import org.htmlunit.corejs.javascript.EvaluatorException;
import org.htmlunit.corejs.javascript.NativeArrayIterator;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.ElementFactory;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxClasses;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.html.HTMLOptionElement;
import org.htmlunit.javascript.host.html.HTMLSelectElement;

@JsxClasses(value={@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR}), @JsxClass(isJSObject=false, value={SupportedBrowser.IE})})
public class HTMLOptionsCollection
extends HtmlUnitScriptable {
    private HtmlSelect htmlSelect_;

    public HTMLOptionsCollection() {
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
    }

    public HTMLOptionsCollection(HtmlUnitScriptable parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @Override
    public String getClassName() {
        if (this.getWindow().getWebWindow() != null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_HAS_SELECT_CLASS_NAME)) {
            return "HTMLSelectElement";
        }
        return super.getClassName();
    }

    public void initialize(HtmlSelect select) {
        WebAssert.notNull("select", select);
        this.htmlSelect_ = select;
    }

    public Object get(int index, Scriptable start) {
        if (this.htmlSelect_ == null || index < 0) {
            return Undefined.instance;
        }
        if (index >= this.htmlSelect_.getOptionSize()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_NULL_FOR_OUTSIDE)) {
                return null;
            }
            return Undefined.instance;
        }
        return this.getScriptableFor(this.htmlSelect_.getOption(index));
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.htmlSelect_ == null) {
            super.put(name, start, value);
            return;
        }
        HTMLSelectElement parent = (HTMLSelectElement)this.htmlSelect_.getScriptableObject();
        if (!this.has(name, start) && ScriptableObject.hasProperty((Scriptable)parent, (String)name)) {
            ScriptableObject.putProperty((Scriptable)parent, (String)name, (Object)value);
        } else {
            super.put(name, start, value);
        }
    }

    @JsxFunction
    public Object item(int index) {
        return this.get(index, null);
    }

    public void put(int index, Scriptable start, Object newValue) {
        if (newValue == null) {
            this.htmlSelect_.removeOption(index);
        } else {
            HTMLOptionElement option = (HTMLOptionElement)newValue;
            HtmlOption htmlOption = (HtmlOption)option.getDomNodeOrNull();
            if (index >= this.getLength()) {
                this.setLength(index);
                this.htmlSelect_.appendOption(htmlOption);
            } else {
                this.htmlSelect_.replaceOption(index, htmlOption);
            }
        }
    }

    @JsxGetter
    public int getLength() {
        return this.htmlSelect_.getOptionSize();
    }

    @JsxSetter
    public void setLength(int newLength) {
        if (newLength < 0) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_IGNORE_NEGATIVE_LENGTH)) {
                return;
            }
            throw JavaScriptEngine.reportRuntimeError("Length is negative");
        }
        int currentLength = this.htmlSelect_.getOptionSize();
        if (currentLength > newLength) {
            this.htmlSelect_.setOptionSize(newLength);
        } else {
            SgmlPage page = this.htmlSelect_.getPage();
            ElementFactory factory = page.getWebClient().getPageCreator().getHtmlParser().getFactory("option");
            for (int i = currentLength; i < newLength; ++i) {
                HtmlOption option = (HtmlOption)factory.createElement(page, "option", null);
                this.htmlSelect_.appendOption(option);
            }
        }
    }

    @JsxFunction
    public void add(Object newOptionObject, Object beforeOptionObject) {
        HtmlOption htmlOption = (HtmlOption)((HTMLOptionElement)newOptionObject).getDomNodeOrNull();
        HtmlOption beforeOption = null;
        if (beforeOptionObject instanceof Number) {
            int index = (Integer)Context.jsToJava((Object)beforeOptionObject, Integer.class);
            if (index < 0 || index >= this.getLength()) {
                this.htmlSelect_.appendOption(htmlOption);
                return;
            }
            beforeOption = (HtmlOption)((HTMLOptionElement)this.item(index)).getDomNodeOrDie();
        } else if (beforeOptionObject instanceof HTMLOptionElement && (beforeOption = (HtmlOption)((HTMLOptionElement)beforeOptionObject).getDomNodeOrDie()).getParentNode() != this.htmlSelect_) {
            throw new EvaluatorException("Unknown option.");
        }
        if (null == beforeOption) {
            this.htmlSelect_.appendOption(htmlOption);
            return;
        }
        beforeOption.insertBefore(htmlOption);
    }

    @JsxFunction
    public void remove(int index) {
        int idx = index;
        BrowserVersion browser = this.getBrowserVersion();
        if (idx < 0) {
            if (browser.hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_REMOVE_IGNORE_IF_INDEX_NEGATIVE)) {
                return;
            }
            if (index < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_REMOVE_THROWS_IF_NEGATIV)) {
                throw JavaScriptEngine.reportRuntimeError("Invalid index for option collection: " + index);
            }
        }
        if ((idx = Math.max(idx, 0)) >= this.getLength()) {
            return;
        }
        this.htmlSelect_.removeOption(idx);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_IN_ALWAYS_TRUE)) {
            return true;
        }
        return super.has(index, start);
    }

    @JsxGetter
    public int getSelectedIndex() {
        return this.htmlSelect_.getSelectedIndex();
    }

    @JsxSetter
    public void setSelectedIndex(int index) {
        this.htmlSelect_.setSelectedIndex(index);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public NodeList getChildNodes() {
        NodeList childNodes = new NodeList((DomNode)this.htmlSelect_, false);
        childNodes.setElementsSupplier((Supplier<List> & Serializable)() -> {
            ArrayList<DomNode> response = new ArrayList<DomNode>();
            for (DomNode child : this.htmlSelect_.getChildren()) {
                response.add(child);
            }
            return response;
        });
        return childNodes;
    }

    @JsxSymbol(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator iterator() {
        return new NativeArrayIterator(this.getParentScope(), (Scriptable)this, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
    }
}

