/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlArea;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.DOMTokenList;
import org.htmlunit.javascript.host.html.HTMLAnchorElement;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlArea.class)
public class HTMLAreaElement
extends HTMLElement {
    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        HtmlElement element = this.getDomNodeOrNull();
        if (element == null) {
            return super.getDefaultValue(null);
        }
        return HTMLAnchorElement.getDefaultValue(element);
    }

    @JsxGetter
    public String getAlt() {
        return this.getDomNodeOrDie().getAttributeDirect("alt");
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter
    public String getRel() {
        return this.getDomNodeOrDie().getAttributeDirect("rel");
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DOMTokenList getRelList() {
        return new DOMTokenList(this, "rel");
    }

    @Override
    public void focus() {
        HtmlArea area = (HtmlArea)this.getDomNodeOrDie();
        String hrefAttr = area.getHrefAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED != hrefAttr || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_AREA_WITHOUT_HREF_FOCUSABLE)) {
            area.focus();
        }
    }

    @JsxGetter
    public String getCoords() {
        return this.getDomNodeOrDie().getAttributeDirect("coords");
    }

    @JsxSetter
    public void setCoords(String coords) {
        this.getDomNodeOrDie().setAttribute("coords", coords);
    }
}

