/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.NativeFunction;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.NativeFunctionPrefixResolver;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.XPathNSResolver;
import org.htmlunit.javascript.host.dom.XPathResult;
import org.htmlunit.xpath.xml.utils.PrefixResolver;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class XPathEvaluator
extends HtmlUnitScriptable {
    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxFunction
    public XPathNSResolver createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope((Scriptable)this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    @JsxFunction
    public XPathResult evaluate(String expression, Object contextNodeObj, Object resolver, int type, Object result) {
        try {
            XPathResult xPathResult = (XPathResult)result;
            if (xPathResult == null) {
                xPathResult = new XPathResult();
                xPathResult.setParentScope(this.getParentScope());
                xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
            }
            if (!(contextNodeObj instanceof Node)) {
                throw JavaScriptEngine.reportRuntimeError("Illegal value for parameter 'context'");
            }
            Node contextNode = (Node)contextNodeObj;
            PrefixResolver prefixResolver = null;
            if (resolver instanceof PrefixResolver) {
                prefixResolver = (PrefixResolver)resolver;
            } else if (resolver instanceof NativeFunction) {
                prefixResolver = new NativeFunctionPrefixResolver((NativeFunction)resolver, contextNode.getParentScope());
            }
            xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression, prefixResolver), type);
            return xPathResult;
        }
        catch (Exception e) {
            throw JavaScriptEngine.reportRuntimeError("Failed to execute 'evaluate': " + e.getMessage());
        }
    }
}

