/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript;

import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.javascript.FunctionWrapper;

public class NativeFunctionToStringFunction
extends FunctionWrapper {
    public static void installFix(Scriptable window, BrowserVersion browserVersion) {
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_NEW_LINE)) {
            ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"Function");
            Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, (String)"toString");
            NativeFunctionToStringFunction newToString = new NativeFunctionToStringFunction(originalToString);
            ScriptableObject.putProperty((Scriptable)fnPrototype, (String)"toString", (Object)newToString);
        } else if (browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_COMPACT)) {
            ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"Function");
            Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, (String)"toString");
            NativeFunctionToStringFunctionChrome newToString = new NativeFunctionToStringFunctionChrome(originalToString);
            ScriptableObject.putProperty((Scriptable)fnPrototype, (String)"toString", (Object)newToString);
        } else if (browserVersion.hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_NL)) {
            ScriptableObject fnPrototype = (ScriptableObject)ScriptableObject.getClassPrototype((Scriptable)window, (String)"Function");
            Function originalToString = (Function)ScriptableObject.getProperty((Scriptable)fnPrototype, (String)"toString");
            NativeFunctionToStringFunctionFF newToString = new NativeFunctionToStringFunctionFF(originalToString);
            ScriptableObject.putProperty((Scriptable)fnPrototype, (String)"toString", (Object)newToString);
        }
    }

    NativeFunctionToStringFunction(Function wrapped) {
        super(wrapped);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String s = (String)super.call(cx, scope, thisObj, args);
        if (thisObj instanceof BaseFunction && s.contains("[native code]")) {
            String functionName = ((BaseFunction)thisObj).getFunctionName();
            return "\nfunction " + functionName + "() {\n    [native code]\n}\n";
        }
        return s.replace("function anonymous() {", "function anonymous() {\n");
    }

    static class NativeFunctionToStringFunctionFF
    extends FunctionWrapper {
        NativeFunctionToStringFunctionFF(Function wrapped) {
            super(wrapped);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            String s = (String)super.call(cx, scope, thisObj, args);
            return s.replace("function anonymous() {", "function anonymous(\n) {\n");
        }
    }

    static class NativeFunctionToStringFunctionChrome
    extends FunctionWrapper {
        NativeFunctionToStringFunctionChrome(Function wrapped) {
            super(wrapped);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            String s = (String)super.call(cx, scope, thisObj, args);
            if (thisObj instanceof BaseFunction && s.contains("[native code]")) {
                String functionName = ((BaseFunction)thisObj).getFunctionName();
                return "function " + functionName + "() { [native code] }";
            }
            return s.replace("function anonymous() {", "function anonymous(\n) {\n");
        }
    }
}

