/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import java.util.Collections;
import java.util.Map;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.css.AbstractCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.css.StyleElement;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleDeclarationImpl;
import org.htmlunit.cssparser.parser.selector.SelectorSpecificity;

public class WrappedCssStyleDeclaration
extends AbstractCssStyleDeclaration {
    private final CSSStyleDeclarationImpl cssStyleDeclarationImpl_;
    private final BrowserVersion browserVersion_;

    public WrappedCssStyleDeclaration(CSSStyleDeclarationImpl cssStyleDeclarationImpl, BrowserVersion browserVersion) {
        this.cssStyleDeclarationImpl_ = cssStyleDeclarationImpl;
        this.browserVersion_ = browserVersion;
    }

    @Override
    public String getStylePriority(String name) {
        return this.cssStyleDeclarationImpl_.getPropertyPriority(name);
    }

    @Override
    public String getCssText() {
        String text = this.cssStyleDeclarationImpl_.getCssText();
        if (this.cssStyleDeclarationImpl_.getLength() > 0) {
            return text + ";";
        }
        return text;
    }

    @Override
    public String getStyleAttribute(String name) {
        return this.cssStyleDeclarationImpl_.getPropertyValue(name);
    }

    @Override
    public String getStyleAttribute(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty) {
        return this.getStyleAttribute(definition.getAttributeName());
    }

    @Override
    public void setCssText(String value) {
        this.cssStyleDeclarationImpl_.setCssText(value);
    }

    @Override
    public void setStyleAttribute(String name, String newValue, String important) {
        this.cssStyleDeclarationImpl_.setProperty(name, newValue, important);
    }

    @Override
    public String removeStyleAttribute(String name) {
        return this.cssStyleDeclarationImpl_.removeProperty(name);
    }

    @Override
    public int getLength() {
        return this.cssStyleDeclarationImpl_.getProperties().size();
    }

    @Override
    public Object item(int index) {
        return this.cssStyleDeclarationImpl_.getProperties().get(index);
    }

    @Override
    public AbstractCSSRuleImpl getParentRule() {
        return this.cssStyleDeclarationImpl_.getParentRule();
    }

    @Override
    public StyleElement getStyleElement(String name) {
        String value = this.cssStyleDeclarationImpl_.getPropertyValue(name);
        if (value.isEmpty()) {
            return null;
        }
        String priority = this.cssStyleDeclarationImpl_.getPropertyPriority(name);
        return new StyleElement(name, value, priority, SelectorSpecificity.FROM_STYLE_ATTRIBUTE);
    }

    @Override
    public StyleElement getStyleElementCaseInSensitive(String name) {
        return null;
    }

    @Override
    public Map<String, StyleElement> getStyleMap() {
        return Collections.emptyMap();
    }

    @Override
    public boolean hasFeature(BrowserVersionFeatures property) {
        return this.browserVersion_.hasFeature(property);
    }

    @Override
    public BrowserVersion getBrowserVersion() {
        return this.browserVersion_;
    }
}

