/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Cache;
import org.htmlunit.FailingHttpStatusCodeException;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSImportRuleImpl;
import org.htmlunit.cssparser.dom.CSSMediaRuleImpl;
import org.htmlunit.cssparser.dom.CSSRuleListImpl;
import org.htmlunit.cssparser.dom.CSSStyleDeclarationImpl;
import org.htmlunit.cssparser.dom.CSSStyleRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.dom.CSSValueImpl;
import org.htmlunit.cssparser.dom.MediaListImpl;
import org.htmlunit.cssparser.dom.Property;
import org.htmlunit.cssparser.parser.AbstractCSSParser;
import org.htmlunit.cssparser.parser.CSSErrorHandler;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.cssparser.parser.CSSOMParser;
import org.htmlunit.cssparser.parser.InputSource;
import org.htmlunit.cssparser.parser.LexicalUnit;
import org.htmlunit.cssparser.parser.condition.AttributeCondition;
import org.htmlunit.cssparser.parser.condition.Condition;
import org.htmlunit.cssparser.parser.condition.NotPseudoClassCondition;
import org.htmlunit.cssparser.parser.javacc.CSS3Parser;
import org.htmlunit.cssparser.parser.media.MediaQuery;
import org.htmlunit.cssparser.parser.selector.ChildSelector;
import org.htmlunit.cssparser.parser.selector.DescendantSelector;
import org.htmlunit.cssparser.parser.selector.DirectAdjacentSelector;
import org.htmlunit.cssparser.parser.selector.ElementSelector;
import org.htmlunit.cssparser.parser.selector.GeneralAdjacentSelector;
import org.htmlunit.cssparser.parser.selector.PseudoElementSelector;
import org.htmlunit.cssparser.parser.selector.Selector;
import org.htmlunit.cssparser.parser.selector.SelectorList;
import org.htmlunit.cssparser.parser.selector.SimpleSelector;
import org.htmlunit.html.DisabledElement;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.ValidatableElement;
import org.htmlunit.javascript.host.html.HTMLDocument;
import org.htmlunit.util.EncodingSniffer;
import org.htmlunit.util.StringUtils;
import org.htmlunit.util.UrlUtils;

public class CssStyleSheet
implements Serializable {
    public static final String NONE = "none";
    public static final String AUTO = "auto";
    public static final String STATIC = "static";
    public static final String INHERIT = "inherit";
    public static final String INITIAL = "initial";
    public static final String RELATIVE = "relative";
    public static final String FIXED = "fixed";
    public static final String ABSOLUTE = "absolute";
    public static final String REPEAT = "repeat";
    public static final String BLOCK = "block";
    public static final String INLINE = "inline";
    public static final String SCROLL = "scroll";
    private static final Log LOG = LogFactory.getLog(CssStyleSheet.class);
    private static final Pattern NTH_NUMERIC = Pattern.compile("\\d+");
    private static final Pattern NTH_COMPLEX = Pattern.compile("[+-]?\\d*n\\w*([+-]\\w\\d*)?");
    private static final Pattern UNESCAPE_SELECTOR = Pattern.compile("\\\\([\\[\\].:])");
    private final CSSStyleSheetImpl wrapped_;
    private final HtmlElement owner_;
    private final Map<CSSImportRuleImpl, CssStyleSheet> imports_ = new HashMap<CSSImportRuleImpl, CssStyleSheet>();
    private static final transient Map<String, MediaListImpl> media_ = new HashMap<String, MediaListImpl>();
    private final String uri_;
    private boolean enabled_ = true;
    public static final Set<String> CSS2_PSEUDO_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("link", "visited", "hover", "active", "focus", "lang", "first-child")));
    private static final Set<String> CSS3_PSEUDO_CLASSES;
    public static final Set<String> CSS4_PSEUDO_CLASSES;

    public CssStyleSheet(HtmlElement element, InputSource source, String uri) {
        if (source == null) {
            this.wrapped_ = new CSSStyleSheetImpl();
        } else {
            source.setURI(uri);
            this.wrapped_ = CssStyleSheet.parseCSS(source, element.getPage().getWebClient());
        }
        this.uri_ = uri;
        this.owner_ = element;
    }

    public CssStyleSheet(HtmlElement element, String styleSheet, String uri) {
        CSSStyleSheetImpl css = null;
        try (InputSource source = new InputSource((Reader)new StringReader(styleSheet));){
            source.setURI(uri);
            css = CssStyleSheet.parseCSS(source, element.getPage().getWebClient());
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.wrapped_ = css;
        this.uri_ = uri;
        this.owner_ = element;
    }

    public CssStyleSheet(HtmlElement element, CSSStyleSheetImpl wrapped, String uri) {
        this.wrapped_ = wrapped;
        this.uri_ = uri;
        this.owner_ = element;
    }

    public CSSStyleSheetImpl getWrappedSheet() {
        return this.wrapped_;
    }

    public String getUri() {
        return this.uri_;
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CssStyleSheet loadStylesheet(HtmlElement element, HtmlLink link, String url) {
        HtmlPage page = (HtmlPage)element.getPage();
        String uri = page.getUrl().toExternalForm();
        try {
            CssStyleSheet sheet;
            Cache cache;
            WebResponse response;
            WebRequest request;
            block31: {
                WebClient client = page.getWebClient();
                if (!client.isLoadStaticContent() && !client.getOptions().isCssEnabled()) {
                    return new CssStyleSheet(element, "", uri);
                }
                if (link == null) {
                    BrowserVersion browser = client.getBrowserVersion();
                    request = new WebRequest(new URL(url), browser.getCssAcceptHeader(), browser.getAcceptEncodingHeader());
                    request.setRefererlHeader(page.getUrl());
                    response = client.loadWebResponse(request);
                } else {
                    String type;
                    request = link.getWebRequest();
                    if (client.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLLINK_CHECK_TYPE_FOR_STYLESHEET) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(type = link.getTypeAttribute())) && !"text/css".equals(type)) {
                        return new CssStyleSheet(element, "", uri);
                    }
                    response = link.getWebResponse(true, request);
                }
                cache = client.getCache();
                Object fromCache = cache.getCachedObject(request);
                if (fromCache instanceof CSSStyleSheetImpl) {
                    uri = request.getUrl().toExternalForm();
                    return new CssStyleSheet(element, (CSSStyleSheetImpl)fromCache, uri);
                }
                uri = response.getWebRequest().getUrl().toExternalForm();
                client.printContentIfNecessary(response);
                client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
                String contentType = response.getContentType();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)contentType) || "text/css".equals(contentType)) {
                    InputStream in = response.getContentAsStreamWithBomIfApplicable();
                    if (in == null) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Loading stylesheet for url '" + uri + "' returns empty responseData"));
                        }
                        return new CssStyleSheet(element, "", uri);
                    }
                    try {
                        BOMInputStream bomIn;
                        Charset cssEncoding = Charset.forName("windows-1252");
                        Charset contentCharset = EncodingSniffer.sniffEncodingFromHttpHeaders(response.getResponseHeaders());
                        if (contentCharset == null && request.getCharset() != null) {
                            cssEncoding = request.getCharset();
                        } else if (contentCharset != null) {
                            cssEncoding = contentCharset;
                        }
                        if (in instanceof BOMInputStream && (bomIn = (BOMInputStream)in).hasBOM()) {
                            if (bomIn.hasBOM(ByteOrderMark.UTF_8)) {
                                cssEncoding = StandardCharsets.UTF_8;
                            } else if (bomIn.hasBOM(ByteOrderMark.UTF_16BE)) {
                                cssEncoding = StandardCharsets.UTF_16BE;
                            } else if (bomIn.hasBOM(ByteOrderMark.UTF_16LE)) {
                                cssEncoding = StandardCharsets.UTF_16LE;
                            }
                        }
                        try (InputSource source = new InputSource((Reader)new InputStreamReader(in, cssEncoding));){
                            source.setURI(uri);
                            sheet = new CssStyleSheet(element, source, uri);
                            break block31;
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                sheet = new CssStyleSheet(element, "", uri);
            }
            if (!cache.cacheIfPossible(request, response, sheet.getWrappedSheet())) {
                // empty if block
            }
            return sheet;
        }
        catch (FailingHttpStatusCodeException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Exception loading " + uri), (Throwable)e);
            }
            return new CssStyleSheet(element, "", uri);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("IOException loading " + uri), (Throwable)e);
            }
            return new CssStyleSheet(element, "", uri);
        }
    }

    public static boolean selects(BrowserVersion browserVersion, Selector selector, DomElement element, String pseudoElement, boolean fromQuerySelectorAll, boolean throwOnSyntax) {
        switch (selector.getSelectorType()) {
            case ELEMENT_NODE_SELECTOR: {
                String elementName;
                String name;
                ElementSelector es = (ElementSelector)selector;
                if (element.getPage().hasCaseSensitiveTagNames()) {
                    name = es.getLocalName();
                    elementName = element.getLocalName();
                } else {
                    name = es.getLocalNameLowerCase();
                    elementName = element.getLowercaseName();
                }
                if (name == null || name.equals(elementName)) {
                    List conditions = es.getConditions();
                    if (conditions != null) {
                        for (Condition condition : conditions) {
                            if (CssStyleSheet.selects(browserVersion, condition, element, fromQuerySelectorAll, throwOnSyntax)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            case CHILD_SELECTOR: {
                DomNode parentNode = element.getParentNode();
                if (parentNode == element.getPage()) {
                    return false;
                }
                if (!(parentNode instanceof DomElement)) {
                    return false;
                }
                ChildSelector cs = (ChildSelector)selector;
                return CssStyleSheet.selects(browserVersion, (Selector)cs.getSimpleSelector(), element, pseudoElement, fromQuerySelectorAll, throwOnSyntax) && CssStyleSheet.selects(browserVersion, cs.getAncestorSelector(), (DomElement)parentNode, pseudoElement, fromQuerySelectorAll, throwOnSyntax);
            }
            case DESCENDANT_SELECTOR: {
                DescendantSelector ds = (DescendantSelector)selector;
                SimpleSelector simpleSelector = ds.getSimpleSelector();
                if (CssStyleSheet.selects(browserVersion, (Selector)simpleSelector, element, pseudoElement, fromQuerySelectorAll, throwOnSyntax)) {
                    DomNode ancestor = element;
                    if (simpleSelector.getSelectorType() != Selector.SelectorType.PSEUDO_ELEMENT_SELECTOR) {
                        ancestor = ancestor.getParentNode();
                    }
                    Selector dsAncestorSelector = ds.getAncestorSelector();
                    while (ancestor instanceof DomElement) {
                        if (CssStyleSheet.selects(browserVersion, dsAncestorSelector, (DomElement)ancestor, pseudoElement, fromQuerySelectorAll, throwOnSyntax)) {
                            return true;
                        }
                        ancestor = ancestor.getParentNode();
                    }
                }
                return false;
            }
            case DIRECT_ADJACENT_SELECTOR: {
                DirectAdjacentSelector das = (DirectAdjacentSelector)selector;
                if (CssStyleSheet.selects(browserVersion, (Selector)das.getSimpleSelector(), element, pseudoElement, fromQuerySelectorAll, throwOnSyntax)) {
                    DomNode prev;
                    for (prev = element.getPreviousSibling(); prev != null && !(prev instanceof DomElement); prev = prev.getPreviousSibling()) {
                    }
                    return prev != null && CssStyleSheet.selects(browserVersion, das.getSelector(), (DomElement)prev, pseudoElement, fromQuerySelectorAll, throwOnSyntax);
                }
                return false;
            }
            case GENERAL_ADJACENT_SELECTOR: {
                GeneralAdjacentSelector gas = (GeneralAdjacentSelector)selector;
                if (CssStyleSheet.selects(browserVersion, (Selector)gas.getSimpleSelector(), element, pseudoElement, fromQuerySelectorAll, throwOnSyntax)) {
                    for (DomNode prev1 = element.getPreviousSibling(); prev1 != null; prev1 = prev1.getPreviousSibling()) {
                        if (!(prev1 instanceof DomElement) || !CssStyleSheet.selects(browserVersion, gas.getSelector(), (DomElement)prev1, pseudoElement, fromQuerySelectorAll, throwOnSyntax)) continue;
                        return true;
                    }
                }
                return false;
            }
            case PSEUDO_ELEMENT_SELECTOR: {
                if (pseudoElement != null && pseudoElement.length() != 0 && pseudoElement.charAt(0) == ':') {
                    String pseudoName = ((PseudoElementSelector)selector).getLocalName();
                    return pseudoName.equals(pseudoElement.substring(1));
                }
                return false;
            }
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Unknown CSS selector type '" + selector.getSelectorType() + "'."));
        }
        return false;
    }

    static boolean selects(BrowserVersion browserVersion, Condition condition, DomElement element, boolean fromQuerySelectorAll, boolean throwOnSyntax) {
        switch (condition.getConditionType()) {
            case ID_CONDITION: {
                return condition.getValue().equals(element.getId());
            }
            case CLASS_CONDITION: {
                String v3 = condition.getValue();
                if (v3.indexOf(92) > -1) {
                    v3 = UNESCAPE_SELECTOR.matcher(v3).replaceAll("$1");
                }
                String a3 = element.getAttributeDirect("class");
                return CssStyleSheet.selectsWhitespaceSeparated(v3, a3);
            }
            case ATTRIBUTE_CONDITION: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                String value = attributeCondition.getValue();
                if (value != null) {
                    if (value.indexOf(92) > -1) {
                        value = UNESCAPE_SELECTOR.matcher(value).replaceAll("$1");
                    }
                    String name = attributeCondition.getLocalName();
                    String attrValue = element.getAttribute(name);
                    if (attributeCondition.isCaseInSensitive() || "type".equals(name)) {
                        return DomElement.ATTRIBUTE_NOT_DEFINED != attrValue && attrValue.equalsIgnoreCase(value);
                    }
                    return DomElement.ATTRIBUTE_NOT_DEFINED != attrValue && attrValue.equals(value);
                }
                return element.hasAttribute(condition.getLocalName());
            }
            case PREFIX_ATTRIBUTE_CONDITION: {
                AttributeCondition prefixAttributeCondition = (AttributeCondition)condition;
                String prefixValue = prefixAttributeCondition.getValue();
                if (prefixAttributeCondition.isCaseInSensitive()) {
                    return !"".equals(prefixValue) && org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)element.getAttribute(prefixAttributeCondition.getLocalName()), (CharSequence)prefixValue);
                }
                return !"".equals(prefixValue) && element.getAttribute(prefixAttributeCondition.getLocalName()).startsWith(prefixValue);
            }
            case SUFFIX_ATTRIBUTE_CONDITION: {
                AttributeCondition suffixAttributeCondition = (AttributeCondition)condition;
                String suffixValue = suffixAttributeCondition.getValue();
                if (suffixAttributeCondition.isCaseInSensitive()) {
                    return !"".equals(suffixValue) && org.apache.commons.lang3.StringUtils.endsWithIgnoreCase((CharSequence)element.getAttribute(suffixAttributeCondition.getLocalName()), (CharSequence)suffixValue);
                }
                return !"".equals(suffixValue) && element.getAttribute(suffixAttributeCondition.getLocalName()).endsWith(suffixValue);
            }
            case SUBSTRING_ATTRIBUTE_CONDITION: {
                AttributeCondition substringAttributeCondition = (AttributeCondition)condition;
                String substringValue = substringAttributeCondition.getValue();
                if (substringAttributeCondition.isCaseInSensitive()) {
                    return !"".equals(substringValue) && org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)element.getAttribute(substringAttributeCondition.getLocalName()), (CharSequence)substringValue);
                }
                return !"".equals(substringValue) && element.getAttribute(substringAttributeCondition.getLocalName()).contains(substringValue);
            }
            case BEGIN_HYPHEN_ATTRIBUTE_CONDITION: {
                AttributeCondition beginHyphenAttributeCondition = (AttributeCondition)condition;
                String v = beginHyphenAttributeCondition.getValue();
                String a = element.getAttribute(beginHyphenAttributeCondition.getLocalName());
                if (beginHyphenAttributeCondition.isCaseInSensitive()) {
                    return CssStyleSheet.selectsHyphenSeparated(StringUtils.toRootLowerCase(v), StringUtils.toRootLowerCase(a));
                }
                return CssStyleSheet.selectsHyphenSeparated(v, a);
            }
            case ONE_OF_ATTRIBUTE_CONDITION: {
                AttributeCondition oneOfAttributeCondition = (AttributeCondition)condition;
                String v2 = oneOfAttributeCondition.getValue();
                String a2 = element.getAttribute(oneOfAttributeCondition.getLocalName());
                if (oneOfAttributeCondition.isCaseInSensitive()) {
                    return CssStyleSheet.selectsOneOf(StringUtils.toRootLowerCase(v2), StringUtils.toRootLowerCase(a2));
                }
                return CssStyleSheet.selectsOneOf(v2, a2);
            }
            case LANG_CONDITION: {
                String lcLang = condition.getValue();
                int lcLangLength = lcLang.length();
                DomNode node = element;
                while (node instanceof HtmlElement) {
                    String nodeLang = ((HtmlElement)node).getAttributeDirect("lang");
                    if (DomElement.ATTRIBUTE_NOT_DEFINED != nodeLang) {
                        return nodeLang.startsWith(lcLang) && (nodeLang.length() == lcLangLength || '-' == nodeLang.charAt(lcLangLength));
                    }
                    node = node.getParentNode();
                }
                return false;
            }
            case NOT_PSEUDO_CLASS_CONDITION: {
                NotPseudoClassCondition notPseudoCondition = (NotPseudoClassCondition)condition;
                SelectorList selectorList = notPseudoCondition.getSelectors();
                for (Selector selector : selectorList) {
                    if (!CssStyleSheet.selects(browserVersion, selector, element, null, fromQuerySelectorAll, throwOnSyntax)) continue;
                    return false;
                }
                return true;
            }
            case PSEUDO_CLASS_CONDITION: {
                return CssStyleSheet.selectsPseudoClass(browserVersion, condition, element);
            }
        }
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)("Unknown CSS condition type '" + condition.getConditionType() + "'."));
        }
        return false;
    }

    private static boolean selectsOneOf(String condition, String attribute) {
        int conditionLength = condition.length();
        if (conditionLength < 1) {
            return false;
        }
        int attribLength = attribute.length();
        if (attribLength < conditionLength) {
            return false;
        }
        if (attribLength > conditionLength) {
            if (' ' == attribute.charAt(conditionLength) && attribute.startsWith(condition)) {
                return true;
            }
            if (' ' == attribute.charAt(attribLength - conditionLength - 1) && attribute.endsWith(condition)) {
                return true;
            }
            if (attribLength + 1 > conditionLength) {
                StringBuilder tmp = new StringBuilder(conditionLength + 2);
                tmp.append(' ').append(condition).append(' ');
                return attribute.contains(tmp);
            }
            return false;
        }
        return attribute.equals(condition);
    }

    private static boolean selectsHyphenSeparated(String condition, String attribute) {
        int conditionLength = condition.length();
        if (conditionLength < 1) {
            if (attribute != DomElement.ATTRIBUTE_NOT_DEFINED) {
                int attribLength = attribute.length();
                return attribLength == 0 || '-' == attribute.charAt(0);
            }
            return false;
        }
        int attribLength = attribute.length();
        if (attribLength < conditionLength) {
            return false;
        }
        if (attribLength > conditionLength) {
            return '-' == attribute.charAt(conditionLength) && attribute.startsWith(condition);
        }
        return attribute.equals(condition);
    }

    private static boolean selectsWhitespaceSeparated(String condition, String attribute) {
        int conditionLength = condition.length();
        if (conditionLength < 1) {
            return false;
        }
        int attribLength = attribute.length();
        if (attribLength < conditionLength) {
            return false;
        }
        int pos = attribute.indexOf(condition);
        while (pos != -1) {
            if (pos > 0 && !Character.isWhitespace(attribute.charAt(pos - 1))) {
                pos = attribute.indexOf(condition, pos + 1);
                continue;
            }
            int lastPos = pos + condition.length();
            if (lastPos >= attribLength || Character.isWhitespace(attribute.charAt(lastPos))) {
                return true;
            }
            pos = attribute.indexOf(condition, pos + 1);
        }
        return false;
    }

    private static boolean selectsPseudoClass(BrowserVersion browserVersion, Condition condition, DomElement element) {
        String value;
        Object sobj;
        if (browserVersion.hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && (sobj = element.getPage().getScriptableObject()) instanceof HTMLDocument && ((HTMLDocument)sobj).getDocumentMode() < 8) {
            return false;
        }
        switch (value = condition.getValue()) {
            case "root": {
                return element == element.getPage().getDocumentElement();
            }
            case "enabled": {
                return element instanceof DisabledElement && !((DisabledElement)((Object)element)).isDisabled();
            }
            case "disabled": {
                return element instanceof DisabledElement && ((DisabledElement)((Object)element)).isDisabled();
            }
            case "focus": {
                HtmlPage htmlPage = element.getHtmlPageOrNull();
                if (htmlPage != null) {
                    DomElement focus = htmlPage.getFocusedElement();
                    return element == focus;
                }
                return false;
            }
            case "focus-within": {
                HtmlPage htmlPage2 = element.getHtmlPageOrNull();
                if (htmlPage2 != null) {
                    DomElement focus = htmlPage2.getFocusedElement();
                    return element == focus || element.isAncestorOf(focus);
                }
                return false;
            }
            case "focus-visible": {
                HtmlPage htmlPage3 = element.getHtmlPageOrNull();
                if (htmlPage3 != null) {
                    DomElement focus = htmlPage3.getFocusedElement();
                    return element == focus && (element instanceof HtmlInput && !((HtmlInput)element).isReadOnly() || element instanceof HtmlTextArea && !((HtmlTextArea)element).isReadOnly());
                }
                return false;
            }
            case "checked": {
                return element instanceof HtmlCheckBoxInput && ((HtmlCheckBoxInput)element).isChecked() || element instanceof HtmlRadioButtonInput && ((HtmlRadioButtonInput)element).isChecked() || element instanceof HtmlOption && ((HtmlOption)element).isSelected();
            }
            case "required": {
                return element instanceof HtmlElement && ((HtmlElement)element).isRequired();
            }
            case "optional": {
                return element instanceof HtmlElement && ((HtmlElement)element).isOptional();
            }
            case "first-child": {
                for (DomNode n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "last-child": {
                for (DomNode n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "first-of-type": {
                String firstType = element.getNodeName();
                for (DomNode n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(firstType)) continue;
                    return false;
                }
                return true;
            }
            case "last-of-type": {
                String lastType = element.getNodeName();
                for (DomNode n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(lastType)) continue;
                    return false;
                }
                return true;
            }
            case "only-child": {
                DomNode n;
                for (n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                for (n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement)) continue;
                    return false;
                }
                return true;
            }
            case "only-of-type": {
                DomNode n;
                String type = element.getNodeName();
                for (n = element.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(type)) continue;
                    return false;
                }
                for (n = element.getNextSibling(); n != null; n = n.getNextSibling()) {
                    if (!(n instanceof DomElement) || !n.getNodeName().equals(type)) continue;
                    return false;
                }
                return true;
            }
            case "valid": {
                if (element instanceof HtmlForm || element instanceof ValidatableElement) {
                    return ((HtmlElement)element).isValid();
                }
                return false;
            }
            case "invalid": {
                if (element instanceof HtmlForm || element instanceof ValidatableElement) {
                    return !((HtmlElement)element).isValid();
                }
                return false;
            }
            case "empty": {
                return CssStyleSheet.isEmpty(element);
            }
            case "target": {
                String ref = element.getPage().getUrl().getRef();
                return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ref) && ref.equals(element.getId());
            }
            case "hover": {
                return element.isMouseOver();
            }
            case "placeholder-shown": {
                if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_PSEUDO_SELECTOR_PLACEHOLDER_SHOWN)) {
                    return element instanceof HtmlInput && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((HtmlInput)element).getValue()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((HtmlInput)element).getPlaceholder());
                }
            }
            case "-ms-input-placeholder": {
                if (!browserVersion.hasFeature(BrowserVersionFeatures.CSS_PSEUDO_SELECTOR_MS_PLACEHHOLDER)) break;
                return element instanceof HtmlInput && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((HtmlInput)element).getValue()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((HtmlInput)element).getPlaceholder());
            }
        }
        if (value.startsWith("nth-child(")) {
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getPreviousSibling()) {
                if (!(n instanceof DomElement)) continue;
                ++index;
            }
            return CssStyleSheet.getNthElement(nth, index);
        }
        if (value.startsWith("nth-last-child(")) {
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getNextSibling()) {
                if (!(n instanceof DomElement)) continue;
                ++index;
            }
            return CssStyleSheet.getNthElement(nth, index);
        }
        if (value.startsWith("nth-of-type(")) {
            String nthType = element.getNodeName();
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getPreviousSibling()) {
                if (!(n instanceof DomElement) || !n.getNodeName().equals(nthType)) continue;
                ++index;
            }
            return CssStyleSheet.getNthElement(nth, index);
        }
        if (value.startsWith("nth-last-of-type(")) {
            String nthLastType = element.getNodeName();
            String nth = value.substring(value.indexOf(40) + 1, value.length() - 1);
            int index = 0;
            for (DomNode n = element; n != null; n = n.getNextSibling()) {
                if (!(n instanceof DomElement) || !n.getNodeName().equals(nthLastType)) continue;
                ++index;
            }
            return CssStyleSheet.getNthElement(nth, index);
        }
        return false;
    }

    private static boolean isEmpty(DomElement element) {
        for (DomNode n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof DomElement) && !(n instanceof DomText)) continue;
            return false;
        }
        return true;
    }

    private static boolean getNthElement(String nth, int index) {
        String value;
        if ("odd".equalsIgnoreCase(nth)) {
            return index % 2 != 0;
        }
        if ("even".equalsIgnoreCase(nth)) {
            return index % 2 == 0;
        }
        int nIndex = nth.indexOf(110);
        int denominator = 0;
        if (nIndex != -1) {
            value = nth.substring(0, nIndex).trim();
            if ("-".equals(value)) {
                denominator = -1;
            } else {
                if (value.length() > 0 && value.charAt(0) == '+') {
                    value = value.substring(1);
                }
                denominator = NumberUtils.toInt((String)value, (int)1);
            }
        }
        if ((value = nth.substring(nIndex + 1).trim()).length() > 0 && value.charAt(0) == '+') {
            value = value.substring(1);
        }
        int numerator = NumberUtils.toInt((String)value, (int)0);
        if (denominator == 0) {
            return index == numerator && numerator > 0;
        }
        double n = (double)(index - numerator) / (double)denominator;
        return n >= 0.0 && n % 1.0 == 0.0;
    }

    private static CSSStyleSheetImpl parseCSS(InputSource source, WebClient client) {
        CSSStyleSheetImpl ss;
        try (WebClient.PooledCSS3Parser pooledParser = client.getCSS3Parser();){
            CSSErrorHandler errorHandler = client.getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser((AbstractCSSParser)pooledParser);
            parser.setErrorHandler(errorHandler);
            ss = parser.parseStyleSheet(source, null);
        }
        catch (Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error parsing CSS from '" + CssStyleSheet.toString(source) + "': " + t.getMessage()), t);
            }
            ss = new CSSStyleSheetImpl();
        }
        return ss;
    }

    public static MediaListImpl parseMedia(String mediaString, WebClient webClient) {
        MediaListImpl media = media_.get(mediaString);
        if (media != null) {
            return media;
        }
        WebClient.PooledCSS3Parser pooledParser = webClient.getCSS3Parser();
        try {
            CSSOMParser parser = new CSSOMParser((AbstractCSSParser)pooledParser);
            parser.setErrorHandler(webClient.getCssErrorHandler());
            media = new MediaListImpl(parser.parseMedia(mediaString));
            media_.put(mediaString, media);
            MediaListImpl mediaListImpl = media;
            if (pooledParser != null) {
                pooledParser.close();
            }
            return mediaListImpl;
        }
        catch (Throwable throwable) {
            try {
                if (pooledParser != null) {
                    try {
                        pooledParser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Error parsing CSS media from '" + mediaString + "': " + e.getMessage()), (Throwable)e);
                }
                media = new MediaListImpl(null);
                media_.put(mediaString, media);
                return media;
            }
        }
    }

    @Deprecated
    public static MediaListImpl parseMedia(CSSErrorHandler errorHandler, String mediaString) {
        MediaListImpl media = media_.get(mediaString);
        if (media != null) {
            return media;
        }
        try {
            CSSOMParser parser = new CSSOMParser((AbstractCSSParser)new CSS3Parser());
            parser.setErrorHandler(errorHandler);
            media = new MediaListImpl(parser.parseMedia(mediaString));
            media_.put(mediaString, media);
            return media;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error parsing CSS media from '" + mediaString + "': " + e.getMessage()), (Throwable)e);
            }
            media = new MediaListImpl(null);
            media_.put(mediaString, media);
            return media;
        }
    }

    private static String toString(InputSource source) {
        try {
            Reader reader = source.getReader();
            if (null != reader) {
                if (reader instanceof StringReader) {
                    StringReader sr = (StringReader)reader;
                    sr.reset();
                }
                return IOUtils.toString((Reader)reader);
            }
            return "";
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static void validateSelectors(SelectorList selectorList, int documentMode, DomNode domNode) throws CSSException {
        for (Selector selector : selectorList) {
            if (CssStyleSheet.isValidSelector(selector, documentMode, domNode)) continue;
            throw new CSSException("Invalid selector: " + selector);
        }
    }

    private static boolean isValidSelector(Selector selector, int documentMode, DomNode domNode) {
        switch (selector.getSelectorType()) {
            case ELEMENT_NODE_SELECTOR: {
                List conditions = ((ElementSelector)selector).getConditions();
                if (conditions != null) {
                    for (Condition condition : conditions) {
                        if (CssStyleSheet.isValidCondition(condition, documentMode, domNode)) continue;
                        return false;
                    }
                }
                return true;
            }
            case DESCENDANT_SELECTOR: {
                DescendantSelector ds = (DescendantSelector)selector;
                return CssStyleSheet.isValidSelector(ds.getAncestorSelector(), documentMode, domNode) && CssStyleSheet.isValidSelector((Selector)ds.getSimpleSelector(), documentMode, domNode);
            }
            case CHILD_SELECTOR: {
                ChildSelector cs = (ChildSelector)selector;
                return CssStyleSheet.isValidSelector(cs.getAncestorSelector(), documentMode, domNode) && CssStyleSheet.isValidSelector((Selector)cs.getSimpleSelector(), documentMode, domNode);
            }
            case DIRECT_ADJACENT_SELECTOR: {
                DirectAdjacentSelector das = (DirectAdjacentSelector)selector;
                return CssStyleSheet.isValidSelector(das.getSelector(), documentMode, domNode) && CssStyleSheet.isValidSelector((Selector)das.getSimpleSelector(), documentMode, domNode);
            }
            case GENERAL_ADJACENT_SELECTOR: {
                GeneralAdjacentSelector gas = (GeneralAdjacentSelector)selector;
                return CssStyleSheet.isValidSelector(gas.getSelector(), documentMode, domNode) && CssStyleSheet.isValidSelector((Selector)gas.getSimpleSelector(), documentMode, domNode);
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unhandled CSS selector type '" + selector.getSelectorType() + "'. Accepting it silently."));
        }
        return true;
    }

    private static boolean isValidCondition(Condition condition, int documentMode, DomNode domNode) {
        switch (condition.getConditionType()) {
            case ID_CONDITION: 
            case CLASS_CONDITION: 
            case ATTRIBUTE_CONDITION: 
            case PREFIX_ATTRIBUTE_CONDITION: 
            case SUFFIX_ATTRIBUTE_CONDITION: 
            case SUBSTRING_ATTRIBUTE_CONDITION: 
            case BEGIN_HYPHEN_ATTRIBUTE_CONDITION: 
            case ONE_OF_ATTRIBUTE_CONDITION: 
            case LANG_CONDITION: {
                return true;
            }
            case NOT_PSEUDO_CLASS_CONDITION: {
                NotPseudoClassCondition notPseudoCondition = (NotPseudoClassCondition)condition;
                SelectorList selectorList = notPseudoCondition.getSelectors();
                for (Selector selector : selectorList) {
                    if (CssStyleSheet.isValidSelector(selector, documentMode, domNode)) continue;
                    return false;
                }
                return true;
            }
            case PSEUDO_CLASS_CONDITION: {
                Object value = condition.getValue();
                if (((String)value).endsWith(")")) {
                    if (((String)value).endsWith("()")) {
                        return false;
                    }
                    value = ((String)value).substring(0, ((String)value).indexOf(40) + 1) + ")";
                }
                if (documentMode < 9) {
                    return CSS2_PSEUDO_CLASSES.contains(value);
                }
                if (!CSS2_PSEUDO_CLASSES.contains(value) && domNode.hasFeature(BrowserVersionFeatures.QUERYSELECTOR_CSS3_PSEUDO_REQUIRE_ATTACHED_NODE) && !domNode.isAttachedToPage() && !domNode.hasChildNodes()) {
                    throw new CSSException("Syntax Error");
                }
                if ("nth-child()".equals(value)) {
                    String arg = org.apache.commons.lang3.StringUtils.substringBetween((String)condition.getValue(), (String)"(", (String)")").trim();
                    return "even".equalsIgnoreCase(arg) || "odd".equalsIgnoreCase(arg) || NTH_NUMERIC.matcher(arg).matches() || NTH_COMPLEX.matcher(arg).matches();
                }
                if ("placeholder-shown".equals(value)) {
                    return domNode.hasFeature(BrowserVersionFeatures.CSS_PSEUDO_SELECTOR_PLACEHOLDER_SHOWN);
                }
                if ("-ms-input-placeholder".equals(value)) {
                    return domNode.hasFeature(BrowserVersionFeatures.CSS_PSEUDO_SELECTOR_MS_PLACEHHOLDER);
                }
                return CSS4_PSEUDO_CLASSES.contains(value);
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unhandled CSS condition type '" + condition.getConditionType() + "'. Accepting it silently."));
        }
        return true;
    }

    public CssStyleSheet getImportedStyleSheet(CSSImportRuleImpl importRule) {
        CssStyleSheet sheet = this.imports_.get(importRule);
        if (sheet == null) {
            String href = importRule.getHref();
            String url = UrlUtils.resolveUrl(this.getUri(), href);
            sheet = CssStyleSheet.loadStylesheet(this.owner_, null, url);
            this.imports_.put(importRule, sheet);
        }
        return sheet;
    }

    public boolean isActive() {
        String media;
        if (this.owner_ instanceof HtmlStyle) {
            HtmlStyle style = (HtmlStyle)this.owner_;
            media = style.getMediaAttribute();
        } else if (this.owner_ instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)this.owner_;
            media = link.getMediaAttribute();
        } else {
            return true;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)media)) {
            return true;
        }
        WebWindow webWindow = this.owner_.getPage().getEnclosingWindow();
        MediaListImpl mediaList = CssStyleSheet.parseMedia(media, webWindow.getWebClient());
        return CssStyleSheet.isActive(mediaList, webWindow);
    }

    public static boolean isActive(MediaListImpl mediaList, WebWindow webWindow) {
        if (mediaList.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < mediaList.getLength(); ++i) {
            MediaQuery mediaQuery = mediaList.mediaQuery(i);
            boolean isActive = CssStyleSheet.isActive(mediaQuery, webWindow);
            if (mediaQuery.isNot()) {
                boolean bl = isActive = !isActive;
            }
            if (!isActive) continue;
            return true;
        }
        return false;
    }

    private static boolean isActive(MediaQuery mediaQuery, WebWindow webWindow) {
        Page page;
        String mediaType = mediaQuery.getMedia();
        if ("screen".equalsIgnoreCase(mediaType) || "all".equalsIgnoreCase(mediaType)) {
            for (Property property : mediaQuery.getProperties()) {
                switch (property.getName()) {
                    case "max-width": {
                        double val = CssStyleSheet.pixelValue(property.getValue(), webWindow);
                        if (val != -1.0 && !(val < (double)webWindow.getInnerWidth())) break;
                        return false;
                    }
                    case "min-width": {
                        double val = CssStyleSheet.pixelValue(property.getValue(), webWindow);
                        if (val != -1.0 && !(val > (double)webWindow.getInnerWidth())) break;
                        return false;
                    }
                    case "max-device-width": {
                        double val = CssStyleSheet.pixelValue(property.getValue(), webWindow);
                        if (val != -1.0 && !(val < (double)webWindow.getScreen().getWidth())) break;
                        return false;
                    }
                    case "min-device-width": {
                        double val = CssStyleSheet.pixelValue(property.getValue(), webWindow);
                        if (val != -1.0 && !(val > (double)webWindow.getScreen().getWidth())) break;
                        return false;
                    }
                    case "max-height": {
                        double val = CssStyleSheet.pixelValue(property.getValue(), webWindow);
                        if (val != -1.0 && !(val < (double)webWindow.getInnerWidth())) break;
                        return false;
                    }
                    case "min-height": {
                        double val = CssStyleSheet.pixelValue(property.getValue(), webWindow);
                        if (val != -1.0 && !(val > (double)webWindow.getInnerWidth())) break;
                        return false;
                    }
                    case "max-device-height": {
                        double val = CssStyleSheet.pixelValue(property.getValue(), webWindow);
                        if (val != -1.0 && !(val < (double)webWindow.getScreen().getWidth())) break;
                        return false;
                    }
                    case "min-device-height": {
                        double val = CssStyleSheet.pixelValue(property.getValue(), webWindow);
                        if (val != -1.0 && !(val > (double)webWindow.getScreen().getWidth())) break;
                        return false;
                    }
                    case "resolution": {
                        CSSValueImpl propValue = property.getValue();
                        double val = CssStyleSheet.resolutionValue(propValue);
                        if (propValue == null) {
                            return true;
                        }
                        if (val != -1.0 && Math.round(val) == (long)webWindow.getScreen().getDeviceXDPI()) break;
                        return false;
                    }
                    case "max-resolution": {
                        double val = CssStyleSheet.resolutionValue(property.getValue());
                        if (val != -1.0 && !(val < (double)webWindow.getScreen().getDeviceXDPI())) break;
                        return false;
                    }
                    case "min-resolution": {
                        double val = CssStyleSheet.resolutionValue(property.getValue());
                        if (val != -1.0 && !(val > (double)webWindow.getScreen().getDeviceXDPI())) break;
                        return false;
                    }
                    case "orientation": {
                        CSSValueImpl cssValue = property.getValue();
                        if (cssValue == null) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)"CSSValue is null not supported for feature 'orientation'");
                            }
                            return true;
                        }
                        String orient = cssValue.getCssText();
                        if ("portrait".equals(orient)) {
                            if (webWindow.getInnerWidth() <= webWindow.getInnerHeight()) break;
                            return false;
                        }
                        if ("landscape".equals(orient)) {
                            if (webWindow.getInnerWidth() >= webWindow.getInnerHeight()) break;
                            return false;
                        }
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("CSSValue '" + property.getValue().getCssText() + "' not supported for feature 'orientation'."));
                        }
                        return false;
                    }
                }
            }
            return true;
        }
        if ("print".equalsIgnoreCase(mediaType) && (page = webWindow.getEnclosedPage()) instanceof SgmlPage) {
            return ((SgmlPage)page).isPrinting();
        }
        return false;
    }

    private static double pixelValue(CSSValueImpl cssValue, WebWindow webWindow) {
        if (cssValue == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"CSSValue is null but has to be a 'px', 'em', '%', 'ex', 'ch', 'vw', 'vh', 'vmin', 'vmax', 'rem', 'mm', 'cm', 'Q', or 'pt' value.");
            }
            return -1.0;
        }
        LexicalUnit.LexicalUnitType luType = cssValue.getLexicalUnitType();
        if (luType != null) {
            switch (luType) {
                case PIXEL: {
                    return cssValue.getDoubleValue();
                }
                case EM: {
                    return 16.0 * cssValue.getDoubleValue();
                }
                case PERCENTAGE: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case EX: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case CH: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case VW: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case VH: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case VMIN: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case VMAX: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case REM: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case MILLIMETER: {
                    int dpi = webWindow.getScreen().getDeviceXDPI();
                    return (double)((float)dpi / 25.4f) * cssValue.getDoubleValue();
                }
                case QUATER: {
                    int dpi = webWindow.getScreen().getDeviceXDPI();
                    return (double)((float)dpi / 25.4f) * cssValue.getDoubleValue() / 4.0;
                }
                case CENTIMETER: {
                    int dpi = webWindow.getScreen().getDeviceXDPI();
                    return (double)((float)dpi / 254.0f) * cssValue.getDoubleValue();
                }
                case POINT: {
                    int dpi = webWindow.getScreen().getDeviceXDPI();
                    return (double)((float)dpi / 72.0f) * cssValue.getDoubleValue();
                }
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSSValue '" + cssValue.getCssText() + "' has to be a 'px', 'em', '%', 'ex', 'ch', 'vw', 'vh', 'vmin', 'vmax', 'rem', 'mm', 'cm', 'Q', or 'pt' value."));
        }
        return -1.0;
    }

    private static double resolutionValue(CSSValueImpl cssValue) {
        if (cssValue == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"CSSValue is null but has to be a 'dpi', 'dpcm', or 'dppx' value.");
            }
            return -1.0;
        }
        if (cssValue.getPrimitiveType() == CSSValueImpl.CSSPrimitiveValueType.CSS_DIMENSION) {
            String text = cssValue.getCssText();
            if (text.endsWith("dpi")) {
                return cssValue.getDoubleValue();
            }
            if (text.endsWith("dpcm")) {
                return (double)2.54f * cssValue.getDoubleValue();
            }
            if (text.endsWith("dppx")) {
                return 96.0 * cssValue.getDoubleValue();
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSSValue '" + cssValue.getCssText() + "' has to be a 'dpi', 'dpcm', or 'dppx' value."));
        }
        return -1.0;
    }

    public void modifyIfNecessary(ComputedCssStyleDeclaration style, DomElement element, String pseudoElement) {
        BrowserVersion browser = element.getPage().getWebClient().getBrowserVersion();
        List<CSSStyleSheetImpl.SelectorEntry> matchingRules = this.selects(this.getRuleIndex(), browser, element, pseudoElement, false);
        for (CSSStyleSheetImpl.SelectorEntry entry : matchingRules) {
            CSSStyleDeclarationImpl dec = entry.getRule().getStyle();
            style.applyStyleFromSelector(dec, entry.getSelector());
        }
    }

    private CSSStyleSheetImpl.CSSStyleSheetRuleIndex getRuleIndex() {
        CSSStyleSheetImpl styleSheet = this.getWrappedSheet();
        CSSStyleSheetImpl.CSSStyleSheetRuleIndex index = styleSheet.getRuleIndex();
        if (index == null) {
            index = new CSSStyleSheetImpl.CSSStyleSheetRuleIndex();
            CSSRuleListImpl ruleList = styleSheet.getCssRules();
            this.index(index, ruleList, new HashSet<String>());
            styleSheet.setRuleIndex(index);
        }
        return index;
    }

    private void index(CSSStyleSheetImpl.CSSStyleSheetRuleIndex index, CSSRuleListImpl ruleList, Set<String> alreadyProcessing) {
        for (AbstractCSSRuleImpl rule : ruleList.getRules()) {
            if (rule instanceof CSSStyleRuleImpl) {
                CSSStyleRuleImpl styleRule = (CSSStyleRuleImpl)rule;
                SelectorList selectors = styleRule.getSelectors();
                for (Selector selector : selectors) {
                    SimpleSelector simpleSel = selector.getSimpleSelector();
                    if (Selector.SelectorType.ELEMENT_NODE_SELECTOR == simpleSel.getSelectorType()) {
                        Condition c;
                        ElementSelector es = (ElementSelector)simpleSel;
                        boolean wasClass = false;
                        List conds = es.getConditions();
                        if (conds != null && conds.size() == 1 && Condition.ConditionType.CLASS_CONDITION == (c = (Condition)conds.get(0)).getConditionType()) {
                            index.addClassSelector(es, c.getValue(), selector, styleRule);
                            wasClass = true;
                        }
                        if (wasClass) continue;
                        index.addElementSelector(es, selector, styleRule);
                        continue;
                    }
                    index.addOtherSelector(selector, styleRule);
                }
                continue;
            }
            if (rule instanceof CSSImportRuleImpl) {
                CSSImportRuleImpl importRule = (CSSImportRuleImpl)rule;
                CssStyleSheet sheet = this.getImportedStyleSheet(importRule);
                if (alreadyProcessing.contains(sheet.getUri())) continue;
                CSSRuleListImpl sheetRuleList = sheet.getWrappedSheet().getCssRules();
                alreadyProcessing.add(sheet.getUri());
                MediaListImpl mediaList = importRule.getMedia();
                if (mediaList.getLength() == 0 && index.getMediaList().getLength() == 0) {
                    this.index(index, sheetRuleList, alreadyProcessing);
                    continue;
                }
                this.index(index.addMedia(mediaList), sheetRuleList, alreadyProcessing);
                continue;
            }
            if (!(rule instanceof CSSMediaRuleImpl)) continue;
            CSSMediaRuleImpl mediaRule = (CSSMediaRuleImpl)rule;
            MediaListImpl mediaList = mediaRule.getMediaList();
            if (mediaList.getLength() == 0 && index.getMediaList().getLength() == 0) {
                this.index(index, mediaRule.getCssRules(), alreadyProcessing);
                continue;
            }
            this.index(index.addMedia(mediaList), mediaRule.getCssRules(), alreadyProcessing);
        }
    }

    private List<CSSStyleSheetImpl.SelectorEntry> selects(CSSStyleSheetImpl.CSSStyleSheetRuleIndex index, BrowserVersion browserVersion, DomElement element, String pseudoElement, boolean fromQuerySelectorAll) {
        ArrayList<CSSStyleSheetImpl.SelectorEntry> matchingRules = new ArrayList<CSSStyleSheetImpl.SelectorEntry>();
        if (CssStyleSheet.isActive(index.getMediaList(), element.getPage().getEnclosingWindow())) {
            String elementName = element.getLowercaseName();
            String[] classes = StringUtils.splitAtJavaWhitespace(element.getAttributeDirect("class"));
            Iterator iter = index.getSelectorEntriesIteratorFor(elementName, classes);
            CSSStyleSheetImpl.SelectorEntry entry = (CSSStyleSheetImpl.SelectorEntry)iter.next();
            while (null != entry) {
                if (CssStyleSheet.selects(browserVersion, entry.getSelector(), element, pseudoElement, fromQuerySelectorAll, false)) {
                    matchingRules.add(entry);
                }
                entry = (CSSStyleSheetImpl.SelectorEntry)iter.next();
            }
            for (CSSStyleSheetImpl.CSSStyleSheetRuleIndex child : index.getChildren()) {
                matchingRules.addAll(this.selects(child, browserVersion, element, pseudoElement, fromQuerySelectorAll));
            }
        }
        return matchingRules;
    }

    static {
        HashSet<String> css3 = new HashSet<String>(Arrays.asList("checked", "disabled", "enabled", "indeterminated", "root", "target", "not()", "nth-child()", "nth-last-child()", "nth-of-type()", "nth-last-of-type()", "last-child", "first-of-type", "last-of-type", "only-child", "only-of-type", "empty", "optional", "required", "valid", "invalid"));
        css3.addAll(CSS2_PSEUDO_CLASSES);
        CSS3_PSEUDO_CLASSES = Collections.unmodifiableSet(css3);
        HashSet<String> css4 = new HashSet<String>(Arrays.asList("focus-within", "focus-visible"));
        css4.addAll(CSS3_PSEUDO_CLASSES);
        CSS4_PSEUDO_CLASSES = Collections.unmodifiableSet(css4);
    }
}

