/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import java.io.Serializable;

public class SplitMix64RandomGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final long PHI = -7046029254386353131L;
    private long x;

    public SplitMix64RandomGenerator(long seed) {
        this.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.x = SplitMix64RandomGenerator.murmurHash3(seed);
    }

    public static long murmurHash3(long x) {
        x ^= x >>> 33;
        x *= -49064778989728563L;
        x ^= x >>> 33;
        x *= -4265267296055464877L;
        x ^= x >>> 33;
        return x;
    }

    private static long staffordMix13(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    private static int staffordMix4Upper32(long z) {
        z = (z ^ z >>> 33) * 7109453100751455733L;
        return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
    }

    public long nextLong() {
        return SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L);
    }

    public int nextInt() {
        return SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L);
    }

    public int nextInt(int n) {
        return (int)this.nextLong(n);
    }

    public long nextLong(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("illegal bound " + n + " (must be positive)");
        }
        long t = SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L);
        long nMinus1 = n - 1L;
        if ((n & nMinus1) == 0L) {
            return t & nMinus1;
        }
        long u = t >>> 1;
        while (u + nMinus1 - (t = u % n) < 0L) {
            u = SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L) >>> 1;
        }
        return t;
    }

    public double nextDouble() {
        return (double)(SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L) >>> 11) * (double)1.110223E-16f;
    }

    public float nextFloat() {
        return (float)(SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L) >>> 8) * 5.9604645E-8f;
    }

    public boolean nextBoolean() {
        return SplitMix64RandomGenerator.staffordMix4Upper32(this.x += -7046029254386353131L) < 0;
    }

    public void nextBytes(byte[] bytes) {
        int i = bytes.length;
        int n = 0;
        while (i != 0) {
            n = Math.min(i, 8);
            long bits = SplitMix64RandomGenerator.staffordMix13(this.x += -7046029254386353131L);
            while (n-- != 0) {
                bytes[--i] = (byte)bits;
                bits >>= 8;
            }
        }
    }
}

