/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyHierarchy {
    public final String VALUE_SEPARATOR = "\n";
    private final String KEY_SEPARATOR = ".";
    private final Map<String, PropertyHierarchy> subs = new HashMap<String, PropertyHierarchy>();
    private final String key;
    private final String domain;
    private String value;

    public PropertyHierarchy(String key) {
        this(null, key);
    }

    public PropertyHierarchy(String domain, String key) {
        this.domain = domain != null ? domain : "";
        this.key = key;
    }

    public void set(Map<String, String> input) {
        if (input != null) {
            Set<Map.Entry<String, String>> entrySet = input.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    public void set(String key, String value) {
        if (key != null) {
            this.set(this.getKeyHierarchy(key), value);
        }
    }

    public void set(List<String> keyHierarchy, String value) {
        if (keyHierarchy != null && keyHierarchy.size() > 0) {
            String key = keyHierarchy.get(0);
            PropertyHierarchy sub = this.subs.get(key);
            if (sub == null) {
                sub = new PropertyHierarchy(this.getKey(), key);
                this.subs.put(key, sub);
            }
            if (keyHierarchy.size() > 1) {
                sub.set(keyHierarchy.subList(1, keyHierarchy.size()), value);
            } else {
                sub.setValue(value);
            }
        }
    }

    public PropertyHierarchy get(String key) {
        return this.get(this.getKeyHierarchy(key));
    }

    public PropertyHierarchy get(List<String> keyHierarchy) {
        String subKey;
        PropertyHierarchy sub;
        if (keyHierarchy != null && keyHierarchy.size() > 0 && (sub = this.subs.get(subKey = keyHierarchy.get(0))) != null) {
            if (keyHierarchy.size() > 1) {
                return sub.get(keyHierarchy.subList(1, keyHierarchy.size()));
            }
            return sub;
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String defaultValue) {
        return this.value != null ? this.value : defaultValue;
    }

    public String getKeyFragment() {
        return this.key;
    }

    public Set<String> getChildKeyFragments() {
        return this.subs.keySet();
    }

    public String getKey() {
        return this.domain.length() < 1 ? this.key : this.domain + "." + this.key;
    }

    public String getKeyValues() {
        StringBuilder sb = new StringBuilder();
        if (this.value != null) {
            sb.append(this.value).append("\n");
        }
        for (PropertyHierarchy sub : this.subs.values()) {
            sb.append(sub.getKeyValues());
        }
        return sb.toString();
    }

    public String getKeyValue(String key) {
        return this.getKeyValue(this.getKeyHierarchy(key));
    }

    public String getKeyValue(List<String> keyHierarchy) {
        PropertyHierarchy prop = this.get(keyHierarchy);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private String normalizeKey(String key) {
        if ((key = key.trim()).startsWith(".")) {
            key = key.substring(1);
        }
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }

    private List<String> getKeyHierarchy(String key) {
        List<String> keyHierarchy = null;
        if ((key = this.normalizeKey(key)).length() > 0) {
            if (key.contains(".")) {
                keyHierarchy = Arrays.asList(key.split("\\."));
            } else {
                keyHierarchy = new ArrayList<String>(1);
                keyHierarchy.add(key);
            }
        }
        if (keyHierarchy == null) {
            keyHierarchy = Collections.emptyList();
        }
        return keyHierarchy;
    }
}

