/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import com.xceptance.xlt.api.engine.Session;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class ExclusiveUtils<T> {
    public static <T> List<T> getExclusiveAgentPart(List<T> data) {
        int totalAgentcount = Session.getCurrent().getTotalAgentCount();
        int currentAgentNumber = Session.getCurrent().getAgentNumber();
        return ExclusiveUtils.getExclusivePart(data, totalAgentcount, currentAgentNumber);
    }

    public static <T> List<T> getExclusivePart(List<T> data, int numberOfParties, int currentPartyIndex) {
        int dataIndex;
        Assert.assertNotNull((String)"Data must not be <null>.", data);
        Assert.assertFalse((String)"There must be at least one party.", (numberOfParties < 1 ? 1 : 0) != 0);
        Assert.assertFalse((String)"Current party index out of range.", (currentPartyIndex < 0 || currentPartyIndex >= numberOfParties ? 1 : 0) != 0);
        int dataSize = data.size();
        Assert.assertTrue((String)"Not enough data available.", (dataSize >= numberOfParties ? 1 : 0) != 0);
        if (numberOfParties == 1) {
            return data;
        }
        ArrayList<T> partition = new ArrayList<T>();
        int blockSize = numberOfParties;
        int completeBlocks = dataSize / blockSize;
        int mod = dataSize % blockSize;
        int blocks = completeBlocks + (mod > 0 ? 1 : 0);
        for (int blockIndex = 0; blockIndex < blocks && (dataIndex = blockIndex * blockSize + currentPartyIndex) < dataSize; ++blockIndex) {
            partition.add(data.get(dataIndex));
        }
        return partition;
    }
}

