/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

public class RuntimeHistogram {
    private static final int DEFAULT_PRECISION = 1;
    private int[] countPerBucket;
    private int firstIndex;
    private int lastIndex;
    private final int precision;
    private int valueCount;

    public RuntimeHistogram() {
        this(1);
    }

    public RuntimeHistogram(int precision) {
        this.precision = precision;
    }

    public void addValue(int value) {
        int index = value / this.precision;
        if (this.valueCount == 0) {
            this.countPerBucket = new int[1];
            this.countPerBucket[0] = 1;
            this.firstIndex = this.lastIndex = index;
            this.valueCount = 1;
        } else {
            if (index < this.firstIndex) {
                int delta = this.firstIndex - index;
                this.grow(delta, true);
                this.firstIndex = index;
            } else if (index > this.lastIndex) {
                int delta = index - this.lastIndex;
                this.grow(delta, false);
                this.lastIndex = index;
            }
            int n = index - this.firstIndex;
            this.countPerBucket[n] = this.countPerBucket[n] + 1;
            ++this.valueCount;
        }
    }

    public double getMedianValue() {
        return this.getPercentile(50.0);
    }

    public double getPercentile(double p) {
        double value;
        if (p <= 0.0 || p > 100.0) {
            throw new IllegalArgumentException("Value of parameter 'p' must be in range (0, 100], but was " + p);
        }
        if (this.valueCount == 0) {
            value = 0.0;
        } else if (p == 100.0) {
            value = this.lastIndex * this.precision;
        } else {
            double np = (double)this.valueCount * p / 100.0;
            if (np % 1.0 == 0.0) {
                int i1 = (int)np;
                int i2 = i1 + 1;
                int value1 = this.getValue(i1);
                int value2 = this.getValue(i2);
                value = (double)(value1 + value2) / 2.0;
            } else {
                int i = (int)Math.ceil(np);
                value = this.getValue(i);
            }
        }
        return value;
    }

    private int getValue(int valueIndex) {
        int bucketIndex = -1;
        for (int count = 0; count < valueIndex; count += this.countPerBucket[++bucketIndex]) {
        }
        return (this.firstIndex + bucketIndex) * this.precision;
    }

    public int getNumberOfBuckets() {
        return this.countPerBucket.length;
    }

    private void grow(int delta, boolean shiftToRight) {
        int[] newCountPerBucket = new int[this.countPerBucket.length + delta];
        System.arraycopy(this.countPerBucket, 0, newCountPerBucket, shiftToRight ? delta : 0, this.countPerBucket.length);
        this.countPerBucket = newCountPerBucket;
    }
}

