/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.category.CategoryDataset;

public class CategoryItemRenderer
extends LineAndShapeRenderer
implements Serializable {
    private static final long serialVersionUID = -7793786349384231896L;

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (!this.getItemVisible(row, column)) {
            return;
        }
        if (!this.getItemLineVisible(row, column) && !this.getItemShapeVisible(row, column)) {
            return;
        }
        Number v = dataset.getValue(row, column);
        if (v == null) {
            return;
        }
        int visibleRow = state.getVisibleSeriesIndex(row);
        if (visibleRow < 0) {
            return;
        }
        int visibleRowCount = state.getVisibleSeriesCount();
        PlotOrientation orientation = plot.getOrientation();
        double x1 = this.getUseSeriesOffset() ? domainAxis.getCategorySeriesMiddle(column, dataset.getColumnCount(), visibleRow, visibleRowCount, this.getItemMargin(), dataArea, plot.getDomainAxisEdge()) : domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double value = v.doubleValue();
        double y1 = rangeAxis.valueToJava2D(value, dataArea, plot.getRangeAxisEdge());
        if (pass == 0 && this.getItemLineVisible(row, column) && column != 0) {
            Number previousValue = null;
            int previousValueColumn = column;
            while (previousValueColumn > 0 && previousValue == null) {
                previousValue = dataset.getValue(row, --previousValueColumn);
            }
            if (previousValue != null) {
                double previous = previousValue.doubleValue();
                double x0 = this.getUseSeriesOffset() ? domainAxis.getCategorySeriesMiddle(previousValueColumn, dataset.getColumnCount(), visibleRow, visibleRowCount, this.getItemMargin(), dataArea, plot.getDomainAxisEdge()) : domainAxis.getCategoryMiddle(previousValueColumn, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
                double y0 = rangeAxis.valueToJava2D(previous, dataArea, plot.getRangeAxisEdge());
                Line2D.Double line = null;
                if (orientation == PlotOrientation.HORIZONTAL) {
                    line = new Line2D.Double(y0, x0, y1, x1);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    line = new Line2D.Double(x0, y0, x1, y1);
                }
                g2.setPaint(this.getItemPaint(row, column));
                g2.setStroke(this.getItemStroke(row, column));
                g2.draw(line);
            }
        }
        if (pass == 1) {
            Shape shape = this.getItemShape(row, column);
            if (orientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtils.createTranslatedShape((Shape)shape, (double)y1, (double)x1);
            } else if (orientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtils.createTranslatedShape((Shape)shape, (double)x1, (double)y1);
            }
            if (this.getItemShapeVisible(row, column)) {
                if (this.getItemShapeFilled(row, column)) {
                    if (this.getUseFillPaint()) {
                        g2.setPaint(this.getItemFillPaint(row, column));
                    } else {
                        g2.setPaint(this.getItemPaint(row, column));
                    }
                    g2.fill(shape);
                }
                if (this.getDrawOutlines()) {
                    if (this.getUseOutlinePaint()) {
                        g2.setPaint(this.getItemOutlinePaint(row, column));
                    } else {
                        g2.setPaint(this.getItemPaint(row, column));
                    }
                    g2.setStroke(this.getItemOutlineStroke(row, column));
                    g2.draw(shape);
                }
            }
            if (this.isItemLabelVisible(row, column)) {
                if (orientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(g2, orientation, dataset, row, column, y1, x1, value < 0.0);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(g2, orientation, dataset, row, column, x1, y1, value < 0.0);
                }
            }
            int datasetIndex = plot.indexOf(dataset);
            this.updateCrosshairValues(state.getCrosshairState(), dataset.getRowKey(row), dataset.getColumnKey(column), value, datasetIndex, x1, y1, orientation);
            EntityCollection entities = state.getEntityCollection();
            if (entities != null) {
                this.addItemEntity(entities, dataset, row, column, shape);
            }
        }
    }
}

