/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.agent.JvmResourceUsageData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.report.providers.AbstractDataProcessorBasedReportProvider;
import com.xceptance.xlt.report.providers.AgentDataProcessor;
import com.xceptance.xlt.report.providers.AgentReport;
import com.xceptance.xlt.report.providers.AgentsReport;

public class AgentsReportProvider
extends AbstractDataProcessorBasedReportProvider<AgentDataProcessor> {
    public AgentsReportProvider() {
        super(AgentDataProcessor.class);
    }

    @Override
    public Object createReportFragment() {
        AgentsReport report = new AgentsReport();
        for (AgentDataProcessor processor : this.getProcessors()) {
            AgentReport agentReport = processor.createAgentReport();
            report.agents.add(agentReport);
        }
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof JvmResourceUsageData) {
            AgentDataProcessor processor = (AgentDataProcessor)this.getProcessor(data.getAgentName());
            processor.processDataRecord(data);
            processor.setName(data.getName());
        } else if (data instanceof TransactionData) {
            TransactionData transactionData = (TransactionData)data;
            AgentDataProcessor processor = (AgentDataProcessor)this.getProcessor(data.getAgentName());
            processor.incrementTransactionCounters(transactionData.hasFailed());
        }
    }
}

