/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.external.util;

import com.xceptance.xlt.report.external.util.ValueSet;
import com.xceptance.xlt.report.util.ReportUtils;
import java.math.BigDecimal;

public class StatsValueSet
extends ValueSet {
    protected double min = Double.MAX_VALUE;
    protected double max = -1.7976931348623157E308;
    protected double sum = 0.0;
    protected int count = 0;
    private double sumOfSquares;

    @Override
    public void addOrUpdate(long time, double value) {
        super.addOrUpdate(time, value);
        double v = value;
        this.min = Math.min(this.min, v);
        this.max = Math.max(this.max, v);
        this.sumOfSquares += v * v;
        this.sum += v;
        ++this.count;
    }

    public BigDecimal getMin() {
        return ReportUtils.convertToBigDecimal(this.count > 0 ? this.min : 0.0);
    }

    public BigDecimal getMax() {
        return ReportUtils.convertToBigDecimal(this.count > 0 ? this.max : 0.0);
    }

    public int getCount() {
        return this.count;
    }

    public BigDecimal getAvg() {
        return ReportUtils.convertToBigDecimal(this.calculateMean());
    }

    private double calculateMean() {
        return this.count > 0 ? this.sum / (double)this.count : 0.0;
    }

    public BigDecimal getStandardDeviation() {
        double mean = this.calculateMean();
        return ReportUtils.convertToBigDecimal(Math.sqrt(this.sumOfSquares / (double)this.count - mean * mean));
    }
}

