/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.criteria;

public final class CriterionResult {
    private final String id;
    private final Status status;
    private final String message;

    private CriterionResult(String id, Status status) {
        this(id, status, null);
    }

    private CriterionResult(String id, Status status, String message) {
        this.id = id;
        this.status = status;
        this.message = message;
    }

    public static CriterionResult passed(String criterionId) {
        return new CriterionResult(criterionId, Status.PASSED);
    }

    public static CriterionResult skipped(String criterionId) {
        return new CriterionResult(criterionId, Status.SKIPPED);
    }

    public static CriterionResult failed(String criterionId, String failureMessage) {
        return new CriterionResult(criterionId, Status.FAILED, failureMessage);
    }

    public static CriterionResult error(String criterionId, String errorMessage) {
        return new CriterionResult(criterionId, Status.ERROR, errorMessage);
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean hasPassed() {
        return this.status == Status.PASSED || this.status == Status.SKIPPED;
    }

    static enum Status {
        PASSED,
        FAILED,
        ERROR,
        SKIPPED;

    }
}

