/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.xlt.api.report.PostProcessedDataContainer;
import com.xceptance.xlt.api.report.ReportProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StatisticsProcessor {
    private static final Log LOG = LogFactory.getLog(StatisticsProcessor.class);
    private final ReentrantLock updateLock = new ReentrantLock();
    private long maximumTime = 0L;
    private long minimumTime = Long.MAX_VALUE;
    private final List<ReportProvider> reportProviders;

    public StatisticsProcessor(List<ReportProvider> reportProviders) {
        this.reportProviders = reportProviders.stream().filter(p -> p.wantsDataRecords()).collect(Collectors.toList());
    }

    public synchronized long getMaximumTime() {
        return this.maximumTime;
    }

    public synchronized long getMinimumTime() {
        return this.minimumTime == Long.MAX_VALUE ? 0L : this.minimumTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(PostProcessedDataContainer dataContainer) {
        if (dataContainer.data.size() == 0) {
            return;
        }
        ArrayList<ReportProvider> providerList = new ArrayList<ReportProvider>(this.reportProviders);
        while (!providerList.isEmpty()) {
            ReportProvider provider = null;
            for (int i = 0; i < providerList.size(); ++i) {
                boolean wasLocked = ((ReportProvider)providerList.get(i)).lock();
                if (!wasLocked) continue;
                provider = (ReportProvider)providerList.remove(i);
                break;
            }
            if (provider == null) continue;
            try {
                provider.processAll(dataContainer);
            }
            catch (Throwable t) {
                LOG.error((Object)"Failed to process data record, discarding full chunk", t);
            }
            finally {
                provider.unlock();
                Thread.yield();
            }
        }
        this.updateLock.lock();
        this.minimumTime = Math.min(this.minimumTime, dataContainer.getMinimumTime());
        this.maximumTime = Math.max(this.maximumTime, dataContainer.getMaximumTime());
        this.updateLock.unlock();
    }
}

