/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.Console;
import com.xceptance.common.util.ParseUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.XltEngine;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.report.ReportGenerator;
import com.xceptance.xlt.util.Timer;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGeneratorMain {
    private static final Logger log = LoggerFactory.getLogger(ReportGeneratorMain.class);
    private static final String OPTION_TIMEZONE = "timezone";
    private static final String OPTION_PROPERTY_DEFINITION = "D";
    private static final String OPTION_LINK2RESULTS = "linkToResults";
    private static final String OPTION_TEST_CASE_INCLUDES = "i";
    private static final String OPTION_TEST_CASE_EXCLUDES = "e";
    private static final String OPTION_AGENTS_INCLUDE = "ai";
    private static final String OPTION_AGENTS_EXCLUDE = "ae";
    private static final String OPTION_NO_AGENT_CHARTS = "noAgentCharts";
    private Boolean linkToResults;
    private boolean noCharts;
    private boolean noAgentCharts;
    private boolean noRampUp;
    private long fromTime;
    private boolean fromTimeRel;
    private long toTime;
    private boolean toTimeRel;
    private long duration;
    private FileObject inputDir;
    private File outputDir;
    private File overridePropertyFile;
    private String testCaseIncludePatternList;
    private String testCaseExcludePatternList;
    private String agentIncludePatternList;
    private String agentExcludePatternList;
    private Properties commandLineProperties;
    private final Options options = this.createCommandLineOptions();

    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("XLT Report Generation"));
        XltLogger.reportLogger.info(Console.endSection());
        ReportGeneratorMain main = new ReportGeneratorMain();
        try {
            XltLogger.reportLogger.info(Console.horizontalBar());
            XltLogger.reportLogger.info(Console.startSection("Initializing..."));
            Timer timer = Timer.start();
            main.init(args);
            XltLogger.reportLogger.info(timer.stop().get("...finished"));
            XltLogger.reportLogger.info(Console.endSection());
        }
        catch (Exception ex) {
            System.err.println("Failed to initialize report generator: " + ex.getMessage());
            log.error("Failed to initialize report generator.", (Throwable)ex);
            main.printUsageInfo();
            System.exit(2);
        }
        try {
            main.run();
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println("Failed to run report generator: " + ex.getMessage());
            log.error("Failed to run report generator.", (Throwable)ex);
            System.exit(1);
        }
    }

    private Options createCommandLineOptions() {
        Options options = new Options();
        Option targetDir = new Option("o", true, "the output directory");
        targetDir.setArgName("dir");
        options.addOption(targetDir);
        Option startTime = new Option("from", true, "ignore results generated before the given time");
        startTime.setArgName("time");
        options.addOption(startTime);
        Option endTime = new Option("to", true, "ignore results generated after the given time");
        endTime.setArgName("time");
        options.addOption(endTime);
        Option duration = new Option("l", true, "use results generated in the specified duration, must be used with option 'from' or option 'to'");
        duration.setArgName("duration");
        options.addOption(duration);
        Option propertyFilename = new Option("pf", true, "property file that overrides the basic properties");
        propertyFilename.setArgName("property file");
        options.addOption(propertyFilename);
        Option propertyDefinition = new Option(OPTION_PROPERTY_DEFINITION, true, "override a property from file");
        propertyDefinition.setValueSeparator('=');
        propertyDefinition.setArgName("property=value");
        propertyDefinition.setArgs(2);
        options.addOption(propertyDefinition);
        Option timeZone = new Option(OPTION_TIMEZONE, true, "override the default timezone");
        timeZone.setArgName("timezoneId");
        options.addOption(timeZone);
        Option link2Results = new Option(OPTION_LINK2RESULTS, true, "whether or not to link to result browsers");
        link2Results.setArgName("yes|no");
        options.addOption(link2Results);
        Option noRampUp = new Option("noRampUp", false, "whether or not to exclude ramp-up period");
        options.addOption(noRampUp);
        Option noCharts = new Option("noCharts", "no-charts", false, "disables generation of all charts");
        options.addOption(noCharts);
        Option noAgentCharts = new Option(OPTION_NO_AGENT_CHARTS, "no-agent-charts", false, "disables generation of agent charts");
        options.addOption(noAgentCharts);
        Option includeScenarios = new Option(OPTION_TEST_CASE_INCLUDES, "include-testcases", true, "comma-separated list of test cases to include");
        includeScenarios.setArgName("test cases");
        options.addOption(includeScenarios);
        Option excludeScenarios = new Option(OPTION_TEST_CASE_EXCLUDES, "exclude-testcases", true, "comma-separated list of test cases to exclude");
        excludeScenarios.setArgName("test cases");
        options.addOption(excludeScenarios);
        Option includeAgents = new Option(OPTION_AGENTS_INCLUDE, "include-agents", true, "comma-separated list of agents to include");
        includeAgents.setArgName("agents");
        options.addOption(includeAgents);
        Option excludeAgents = new Option(OPTION_AGENTS_EXCLUDE, "exclude-agents", true, "comma-separated list of agents to exclude");
        excludeAgents.setArgName("agents");
        options.addOption(excludeAgents);
        return options;
    }

    public void init(String[] args) throws Exception {
        FileObject configDir;
        FileObject[] childs;
        boolean isArchiveFile;
        String[] remainingArgs;
        TimeZone tz;
        XltEngine.get();
        CommandLine commandLine = new DefaultParser().parse(this.options, args);
        this.noCharts = commandLine.hasOption("noCharts");
        this.noAgentCharts = commandLine.hasOption(OPTION_NO_AGENT_CHARTS);
        this.noRampUp = commandLine.hasOption("noRampUp");
        this.linkToResults = commandLine.hasOption(OPTION_LINK2RESULTS) ? Boolean.valueOf("yes".equalsIgnoreCase(commandLine.getOptionValue(OPTION_LINK2RESULTS))) : null;
        String overridePropertyFileName = commandLine.getOptionValue("pf");
        String outputDirName = commandLine.getOptionValue("o");
        String timezone = commandLine.getOptionValue(OPTION_TIMEZONE);
        if (StringUtils.isNotBlank((CharSequence)timezone) && !(tz = TimeZone.getTimeZone(timezone)).equals(TimeZone.getDefault())) {
            TimeZone.setDefault(tz);
        }
        String fromOption = commandLine.getOptionValue("from");
        String toOption = commandLine.getOptionValue("to");
        String durationOption = commandLine.getOptionValue("l");
        this.fromTime = this.parseTimeOption(fromOption, "from", 0L);
        this.toTime = this.parseTimeOption(toOption, "to", Long.MAX_VALUE);
        if (durationOption != null) {
            if (!(fromOption != null ^ toOption != null)) {
                throw new IllegalArgumentException(String.format("The option '-%s' must be used with either '-%s' or '-%s'.", "l", "from", "to"));
            }
            this.duration = this.parseDurationOption(durationOption, 0L);
            if (this.duration < 0L) {
                throw new IllegalArgumentException("The specified duration '" + this.duration + "' must be a positive value.");
            }
        } else {
            this.duration = -1L;
        }
        if ((remainingArgs = commandLine.getArgs()).length != 1) {
            throw new IllegalArgumentException("Please specify a single input directory.");
        }
        String inputDirURI = this.getInputDirURI(remainingArgs[0]);
        this.inputDir = VFS.getManager().resolveFile(inputDirURI);
        boolean bl = isArchiveFile = !inputDirURI.startsWith("file:");
        if (isArchiveFile && (childs = this.inputDir.getChildren()).length == 1 && childs[0].getType() == FileType.FOLDER) {
            this.inputDir = childs[0];
        }
        XltExecutionContext.getCurrent().setTestSuiteHomeDir(new File(this.inputDir.getName().getPath()));
        if (outputDirName != null) {
            this.outputDir = new File(outputDirName);
        }
        if ((configDir = this.inputDir.getChild("config")) != null && configDir.exists() && configDir.isReadable() && configDir.getType().equals((Object)FileType.FOLDER)) {
            XltExecutionContext.getCurrent().setTestSuiteConfigDir(configDir);
        } else {
            XltExecutionContext.getCurrent().setTestSuiteConfigDir(this.inputDir);
        }
        if (StringUtils.isNotBlank((CharSequence)overridePropertyFileName)) {
            this.overridePropertyFile = new File(overridePropertyFileName);
        }
        this.commandLineProperties = commandLine.getOptionProperties(OPTION_PROPERTY_DEFINITION);
        if (this.linkToResults != null) {
            this.commandLineProperties.setProperty("com.xceptance.xlt.reportgenerator.linkToResultBrowsers", Boolean.toString(this.linkToResults));
        }
        this.testCaseIncludePatternList = commandLine.getOptionValue(OPTION_TEST_CASE_INCLUDES);
        this.testCaseExcludePatternList = commandLine.getOptionValue(OPTION_TEST_CASE_EXCLUDES);
        this.agentIncludePatternList = commandLine.getOptionValue(OPTION_AGENTS_INCLUDE);
        this.agentExcludePatternList = commandLine.getOptionValue(OPTION_AGENTS_EXCLUDE);
    }

    public void run() throws Exception {
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("Setup..."));
        Timer timer = Timer.start();
        ReportGenerator reportGenerator = new ReportGenerator(this.inputDir, this.outputDir, this.noCharts, this.noAgentCharts, this.overridePropertyFile, this.commandLineProperties, this.testCaseIncludePatternList, this.testCaseExcludePatternList, this.agentIncludePatternList, this.agentExcludePatternList);
        XltLogger.reportLogger.info(timer.stop().get("...finished"));
        XltLogger.reportLogger.info(Console.endSection());
        reportGenerator.generateReport(this.fromTime, this.toTime, this.duration, this.noRampUp, this.fromTimeRel, this.toTimeRel);
    }

    private long parseTimeOption(String optionValue, String optionName, long defaultValue) throws ParseException {
        if (optionValue == null) {
            return defaultValue;
        }
        optionValue = optionValue.trim();
        try {
            SimpleDateFormat dateParser = new SimpleDateFormat("yyyyMMdd-HHmmss");
            dateParser.setLenient(false);
            return dateParser.parse(optionValue).getTime();
        }
        catch (ParseException dateParser) {
            if (RegExUtils.isMatching(optionValue, "^[+-]") && !RegExUtils.isMatching(optionValue, "^[+-]\\d+$")) {
                try {
                    long time = (long)ParseUtils.parseRelativeTimePeriod(optionValue) * 1000L;
                    if (optionName.equals("from")) {
                        this.fromTimeRel = true;
                    } else if (optionName.equals("to")) {
                        this.toTimeRel = true;
                    }
                    return time;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            throw new ParseException(String.format("Unknown format of time period '%s'.\n\nPlease pass time in one of the following formats:\nAbsolute\n\tyyyyMMdd-HHmmss\nRelative:\n\t+1s, -2m, -3h, +1h2m3s, ...\n\t+1:00:00, -0:30:00\nPositive (+) marked time is added to test start time, negative (-) marked time is offset to test end time. ", optionValue), 0);
        }
    }

    private long parseDurationOption(String optionValue, long defaultValue) throws ParseException {
        if (optionValue == null) {
            return defaultValue;
        }
        return (long)ParseUtils.parseRelativeTimePeriod(optionValue) * 1000L;
    }

    private void printUsageInfo() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("Usage: ");
        formatter.setWidth(79);
        String usageInfo = "create_report [<options>] <inputdir>";
        System.out.println();
        formatter.printHelp("create_report [<options>] <inputdir>", "\nOptions:", this.options, "\nNotes:\n<time> is to be specified in the format 'yyyyMMdd-HHmmss'. Alternatively, a relative time value can be given, such as '+1h15m', '+1:15:00', or '-30m'. The +/- sign is mandatory here.\n<duration> is to be specified as a time period value, such as '1h15m' or '1:15:00'.\n<inputdir> can also be an archive of one of the following types: ZIP, JAR, TAR and compressed TAR (BZIP or GZIP).\n<test cases> is a comma-separated list of test case names, but regular expressions are supported as well.");
        System.out.println();
    }

    private String getInputDirURI(String input) {
        String inputDirectory = StringUtils.isEmpty((CharSequence)input) ? "." : input;
        String inputDirURI = new File(inputDirectory).toURI().toString();
        for (ArchiveType type : ArchiveType.values()) {
            if (!type.accept(inputDirURI)) continue;
            return type.getProtocol() + inputDirURI;
        }
        return inputDirURI;
    }

    long getFromTime() {
        return this.fromTime;
    }

    long getToTime() {
        return this.toTime;
    }

    long getDuration() {
        return this.duration;
    }

    boolean isFromTimeRel() {
        return this.fromTimeRel;
    }

    boolean isToTimeRel() {
        return this.toTimeRel;
    }

    private static enum ArchiveType {
        tbz2("tar.bz|tar.bz2|tbz2|tbz"),
        tgz("tar.gz|tgz"),
        tar,
        jar,
        zip;

        private final String fileSuffix;

        private ArchiveType() {
            this(null);
        }

        private ArchiveType(String suffix) {
            this.fileSuffix = suffix;
        }

        public String getProtocol() {
            return this.name() + ":";
        }

        public String getFileSuffixes() {
            return this.fileSuffix == null ? this.name() : this.fileSuffix;
        }

        public boolean accept(String fileName) {
            if (fileName != null && fileName.length() > 0) {
                String s = fileName.toLowerCase();
                for (String suffix : this.getFileSuffixes().split("\\|")) {
                    if (!s.endsWith("." + suffix)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

