/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.util.FailedAgentControllerCollection;
import com.xceptance.xlt.util.ProgressBar;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Poll {
    private static final Logger LOG = LoggerFactory.getLogger(Poll.class);
    private static final long POLL_INTERVAL = 1000L;

    public static boolean poll(final ThreadPoolExecutor executor, final AgentControllerPollingTask task, Collection<AgentController> controllers2Poll, final FailedAgentControllerCollection failedAgentControllers, final ProgressBar progress) {
        final CountDownLatch latch = new CountDownLatch(controllers2Poll.size());
        for (final AgentController agentController : controllers2Poll) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    boolean finishAc = false;
                    try {
                        finishAc = task.call(agentController);
                    }
                    catch (Exception ex) {
                        finishAc = true;
                        failedAgentControllers.add(agentController, ex);
                        LOG.error("Failed when polling " + agentController, (Throwable)ex);
                    }
                    finally {
                        if (finishAc) {
                            Poll.finishAgentControllerPolling(agentController, latch, progress);
                        } else {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            executor.execute(this);
                        }
                    }
                }
            });
        }
        boolean finished = true;
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting for polling threads coming to end failed", (Throwable)e);
            finished = false;
        }
        return finished;
    }

    private static void finishAgentControllerPolling(AgentController agentController, CountDownLatch latch, ProgressBar progress) {
        progress.increaseCount();
        latch.countDown();
    }

    public static interface AgentControllerPollingTask {
        public boolean call(AgentController var1) throws Exception;
    }
}

