/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.SessionImpl;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class XltTestRunner
extends BlockJUnit4ClassRunner {
    public XltTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        return new StatementWrapper(super.methodBlock(method));
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new InvokeMethod(method, test);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return befores == null || befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters == null || afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
    }

    private static class RunAfters
    extends Statement {
        private final Statement _next;
        private final List<FrameworkMethod> _afters;
        private final Object _target;

        private RunAfters(Statement next, List<FrameworkMethod> afters, Object target) {
            this._next = next;
            this._afters = afters;
            this._target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            try {
                this._next.evaluate();
            }
            catch (Throwable e) {
                errors.add(e);
            }
            finally {
                for (FrameworkMethod each : this._afters) {
                    try {
                        each.invokeExplosively(this._target, new Object[0]);
                    }
                    catch (Throwable e) {
                        Session.getCurrent().setFailed(true);
                        errors.add(e);
                    }
                    finally {
                        Session.getCurrent().stopAction();
                    }
                }
            }
            MultipleFailureException.assertEmpty(errors);
        }
    }

    private static class InvokeMethod
    extends Statement {
        private final FrameworkMethod testMethod;
        private final Object target;

        private InvokeMethod(FrameworkMethod testMethod, Object target) {
            this.testMethod = testMethod;
            this.target = target;
        }

        public void evaluate() throws Throwable {
            try {
                this.testMethod.invokeExplosively(this.target, new Object[0]);
            }
            catch (Throwable t) {
                Session.getCurrent().setFailed(true);
                throw t;
            }
            finally {
                Session.getCurrent().stopAction();
            }
        }
    }

    private static class RunBefores
    extends Statement {
        private final Statement next;
        private final Object target;
        private final List<FrameworkMethod> befores;

        public RunBefores(Statement next, List<FrameworkMethod> befores, Object target) {
            this.next = next;
            this.befores = befores;
            this.target = target;
        }

        public void evaluate() throws Throwable {
            for (FrameworkMethod before : this.befores) {
                try {
                    before.invokeExplosively(this.target, new Object[0]);
                }
                catch (Throwable t) {
                    Session.getCurrent().setFailed(true);
                    throw t;
                }
                finally {
                    Session.getCurrent().stopAction();
                }
            }
            this.next.evaluate();
        }
    }

    private static class StatementWrapper
    extends Statement {
        private final Statement statement;

        public StatementWrapper(Statement statement) {
            this.statement = statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            SessionImpl session = SessionImpl.getCurrent();
            session.transactionStarted();
            try {
                this.statement.evaluate();
                session.setFailed(false);
                session.setFailReason(null);
            }
            catch (Throwable t) {
                boolean sessionFailed = !session.wasMarkedAsExpired();
                session.setFailed(sessionFailed);
                if (sessionFailed) {
                    session.setFailReason(t);
                    throw t;
                }
            }
            finally {
                session.transactionFinished();
                XltLogger.runTimeLogger.info("Cleaning up ...");
                session.clear();
            }
        }
    }
}

