/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.engine.util.URLInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.htmlunit.httpclient.HttpClientConverter;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static URL rewriteUrl(String urlString, URLInfo urlOverride) throws MalformedURLException {
        URLInfo urlInfo = null;
        try {
            URL u = new URL(urlString);
            urlInfo = URLInfo.builder().proto(u.getProtocol()).userInfo(u.getUserInfo()).host(u.getHost()).port(u.getPort()).path(u.getPath()).query(u.getQuery()).fragment(u.getRef()).build();
        }
        catch (MalformedURLException mue) {
            urlInfo = UrlUtils.parseUrlString(urlString);
        }
        String proto = StringUtils.isEmpty((CharSequence)urlOverride.getProtocol()) ? urlInfo.getProtocol() : urlOverride.getProtocol();
        String uInfo = StringUtils.isEmpty((CharSequence)urlOverride.getUserInfo()) ? urlInfo.getUserInfo() : urlOverride.getUserInfo();
        String h = StringUtils.isEmpty((CharSequence)urlOverride.getHost()) ? urlInfo.getHost() : urlOverride.getHost();
        int p = urlOverride.getPort() < 0 ? urlInfo.getPort() : urlOverride.getPort();
        String pa = StringUtils.isEmpty((CharSequence)urlOverride.getPath()) ? urlInfo.getPath() : urlOverride.getPath();
        String q = StringUtils.isEmpty((CharSequence)urlOverride.getQuery()) ? urlInfo.getQuery() : urlOverride.getQuery();
        String frag = StringUtils.isEmpty((CharSequence)urlOverride.getFragment()) ? urlInfo.getFragment() : urlOverride.getFragment();
        StringBuilder sb = new StringBuilder();
        sb.append(proto).append("://");
        if (uInfo != null) {
            sb.append(uInfo).append('@');
        }
        sb.append(h);
        if (p > 0) {
            sb.append(':').append(p);
        }
        sb.append(pa);
        if (q != null) {
            sb.append('?').append(q);
        }
        if (frag != null) {
            sb.append('#').append(frag);
        }
        return new URL(sb.toString());
    }

    public static URLInfo parseUrlString(String urlString) {
        if (StringUtils.isEmpty((CharSequence)urlString)) {
            return null;
        }
        String[] parts = UrlUtils.split(urlString, "://", false);
        String protocol = parts[0];
        String authorityPathQueryFragment = parts[1];
        parts = UrlUtils.split(authorityPathQueryFragment, "#", true);
        String authorityPathQuery = parts[0];
        String fragment = parts[1];
        parts = UrlUtils.split(authorityPathQuery, "?", true);
        String authorityPath = parts[0];
        String query = parts[1];
        parts = UrlUtils.split(authorityPath, "/", true);
        String authority = parts[0];
        String path = parts[1] == null ? "" : "/" + parts[1];
        parts = UrlUtils.split(authority, "@", false);
        String userInfo = parts[0];
        String hostPort = parts[1];
        parts = UrlUtils.split(hostPort, ":", true);
        String host = parts[0];
        String port = parts[1];
        int p = -1;
        if (StringUtils.isNotBlank((CharSequence)port) && RegExUtils.isMatching(port, "\\d+")) {
            p = Integer.parseInt(port);
        }
        return URLInfo.builder().proto(protocol).userInfo(userInfo).host(host).port(p).path(path).query(query).fragment(fragment).build();
    }

    private static String[] split(String s, String sep, boolean returnAsFirst) {
        String[] parts = new String[2];
        int i = s.indexOf(sep);
        if (i == -1) {
            if (returnAsFirst) {
                parts[0] = s;
                parts[1] = null;
            } else {
                parts[0] = null;
                parts[1] = s;
            }
        } else {
            parts[0] = s.substring(0, i);
            parts[1] = s.substring(i + sep.length());
        }
        return parts;
    }

    public static String getUrlEncodedParameters(List<org.htmlunit.util.NameValuePair> parameters) {
        List<NameValuePair> httpClientPairs = HttpClientConverter.nameValuePairsToHttpClient(parameters);
        return URLEncodedUtils.format(httpClientPairs, (String)"UTF-8");
    }

    public static String removeUserInfo(String url) {
        URLInfo info;
        URLInfo uRLInfo = info = StringUtils.isNotBlank((CharSequence)url) ? UrlUtils.parseUrlString(url) : null;
        if (info != null) {
            StringBuilder sb = new StringBuilder();
            if (info.getProtocol() != null) {
                sb.append(info.getProtocol()).append("://");
            }
            sb.append(info.getHost());
            if (info.getPort() > -1) {
                sb.append(':').append(info.getPort());
            }
            sb.append(info.getPath());
            if (info.getQuery() != null) {
                sb.append('?').append(info.getQuery());
            }
            if (info.getFragment() != null) {
                sb.append('#').append(info.getFragment());
            }
            return sb.toString();
        }
        return null;
    }

    public static String removeUserInfo(URL url) {
        if (url != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(url.getProtocol()).append("://").append(url.getHost());
            if (url.getPort() > -1) {
                sb.append(':').append(url.getPort());
            }
            sb.append(url.getPath());
            if (url.getQuery() != null) {
                sb.append('?').append(url.getQuery());
            }
            if (url.getRef() != null) {
                sb.append('#').append(url.getRef());
            }
            return sb.toString();
        }
        return null;
    }

    public static URL getURLWithoutUserInfo(URL url) throws MalformedURLException {
        if (url != null) {
            Object file = url.getPath();
            if (url.getQuery() != null) {
                file = (String)file + "?" + url.getQuery();
            }
            if (url.getRef() != null) {
                file = (String)file + "#" + url.getRef();
            }
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), (String)file, null);
        }
        return null;
    }
}

