/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.htmlunit;

import com.xceptance.xlt.api.util.HtmlPageUtils;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.engine.scripting.CookieConstants;
import com.xceptance.xlt.engine.scripting.TestContext;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitElementUtils;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitFinder;
import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitScriptCommands;
import com.xceptance.xlt.engine.scripting.htmlunit.NoSuchWindowException;
import com.xceptance.xlt.engine.scripting.util.AbstractCommandAdapter;
import com.xceptance.xlt.engine.scripting.util.CommandsInvocationHandler;
import com.xceptance.xlt.engine.scripting.util.Condition;
import com.xceptance.xlt.engine.scripting.util.ReplayUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.CookieManager;
import org.htmlunit.DialogWindow;
import org.htmlunit.Page;
import org.htmlunit.TopLevelWindow;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.WebWindowEvent;
import org.htmlunit.WebWindowListener;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlFileInput;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.html.impl.SelectableTextInput;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import org.htmlunit.util.Cookie;
import org.htmlunit.util.UrlUtils;

public final class HtmlUnitCommandAdapter
extends AbstractCommandAdapter
implements HtmlUnitScriptCommands {
    private static final Integer ZERO = 0;
    private boolean initialized = false;
    private final HtmlUnitFinder finder = new HtmlUnitFinder();
    private WeakReference<WebWindow> _currWindow;

    @Override
    public HtmlPage addSelection(String selectLocator, String optionLocator) {
        this.checkElementLocator(selectLocator);
        HtmlPage page = this.getCurrentPage();
        HtmlElement element = this.finder.findElement(page, selectLocator);
        this.checkIsTrue("Element '" + selectLocator + "' is not a HTML select element", element instanceof HtmlSelect);
        HtmlSelect selectElement = (HtmlSelect)element;
        this.checkIsTrue("Select '" + selectLocator + "' does not support multiple selection", selectElement.isMultipleSelectEnabled());
        this.checkIsTrue("Select '" + selectLocator + "' is disabled", !selectElement.isDisabled());
        List<HtmlOption> options = this.finder.findOptions(selectElement, optionLocator);
        Page p = selectElement.getPage();
        for (HtmlOption o : options) {
            if (o.isDisabled()) continue;
            p = o.setSelected(true);
        }
        return (HtmlPage)p;
    }

    @Override
    public HtmlPage check(String elementLocator) throws IOException {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Element '" + elementLocator + "' is not a HTML input element", element instanceof HtmlInput);
        HtmlInput input = (HtmlInput)element;
        String typeAttribute = input.getTypeAttribute();
        this.checkIsTrue("Check is only allowed on radio/checkbox input elements", typeAttribute.equals("radio") || typeAttribute.equals("checkbox"));
        this.checkIsTrue("Radio/checkbox '" + elementLocator + "' is disabled", !input.isDisabled());
        if (!input.isChecked()) {
            return (HtmlPage)input.click();
        }
        return (HtmlPage)input.getPage();
    }

    @Override
    public HtmlPage checkAndWait(final String elementLocator) throws IOException {
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() throws Exception {
                return HtmlUnitCommandAdapter.this.check(elementLocator);
            }
        });
    }

    @Override
    public HtmlPage click(String elementLocator) throws IOException {
        this.checkElementLocator(elementLocator);
        HtmlElement e = this.finder.findElement(this.getCurrentPage(), elementLocator);
        return (HtmlPage)e.click();
    }

    @Override
    public HtmlPage clickAndWait(final String elementLocator) throws IOException {
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() throws Exception {
                return HtmlUnitCommandAdapter.this.click(elementLocator);
            }
        });
    }

    @Override
    public void close() {
        WebWindow w = this.getCurrentWindow();
        if (w != null && w instanceof TopLevelWindow) {
            ((TopLevelWindow)w).close();
        }
    }

    @Override
    public HtmlPage contextMenu(String elementLocator) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return (HtmlPage)element.rightClick();
    }

    @Override
    public HtmlPage contextMenuAt(String elementLocator, String coordinates) {
        int[] coords = ReplayUtils.parseCoordinates(coordinates);
        this.checkIsTrue("Invalid coordinates: " + coordinates, coords != null);
        return this.contextMenuAt(elementLocator, coords[0], coords[1]);
    }

    @Override
    public HtmlPage contextMenuAt(String elementLocator, int coordX, int coordY) {
        this.checkElementLocator(elementLocator);
        HtmlPage page = this.getCurrentPage();
        HtmlElement element = this.finder.findElement(page, elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        page = HtmlUnitElementUtils.fireMouseEvent(element, "mousedown", coordX, coordY, 2, 1);
        page = HtmlUnitElementUtils.fireMouseEvent(element, "mouseup", coordX, coordY, 2, 1);
        page = HtmlUnitElementUtils.fireMouseEvent(element, "contextmenu", coordX, coordY, 2, 0);
        return page;
    }

    @Override
    public void createCookie(String cookie) {
        this.createCookie(cookie, "");
    }

    @Override
    public void createCookie(String cookie, String options) {
        Matcher m = CookieConstants.NAME_VALUE_PAIR_PATTERN.matcher(cookie);
        this.checkIsTrue("Invalid cookie string: " + cookie, m.matches());
        String cookieName = m.group(1);
        String cookieValue = m.group(2);
        Matcher maxAgeMatcher = CookieConstants.MAX_AGE_PATTERN.matcher(options);
        Date maxAge = maxAgeMatcher.find() ? new Date(System.currentTimeMillis() + (long)(Integer.parseInt(maxAgeMatcher.group(1)) * 1000)) : null;
        String path = null;
        Matcher pathMatcher = CookieConstants.PATH_PATTERN.matcher(options);
        if (pathMatcher.find()) {
            path = pathMatcher.group(1);
            try {
                if (path.startsWith("http")) {
                    path = new URL(path).getPath();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String domain = this.getCurrentPage().getWebResponse().getWebRequest().getUrl().getHost();
        WebClient webClient = this.getWebClient();
        Cookie qookie = new Cookie(domain, cookieName, cookieValue, path, maxAge, false);
        webClient.getCookieManager().addCookie(qookie);
    }

    @Override
    public void deleteAllVisibleCookies() {
        WebClient webClient = this.getWebClient();
        CookieManager cookieMgr = webClient.getCookieManager();
        for (Cookie c : webClient.getCookies(this.getCurrentUrl())) {
            cookieMgr.removeCookie(c);
        }
    }

    @Override
    public void deleteCookie(String name) {
        this.deleteCookie(name, null);
    }

    @Override
    public void deleteCookie(String name, String options) {
        this.checkIsTrue("Invalid cookie name: " + name, CookieConstants.NAME_PATTERN.matcher(name).find());
        WebClient webClient = this.getWebClient();
        CookieManager cookieMgr = webClient.getCookieManager();
        for (Cookie cookie : webClient.getCookies(this.getCurrentUrl())) {
            if (!name.equals(cookie.getName())) continue;
            cookieMgr.removeCookie(cookie);
        }
    }

    @Override
    public HtmlPage doubleClick(String elementLocator) throws IOException {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        return (HtmlPage)element.dblClick();
    }

    @Override
    public HtmlPage doubleClickAndWait(final String elementLocator) throws IOException {
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() throws Exception {
                return HtmlUnitCommandAdapter.this.doubleClick(elementLocator);
            }
        });
    }

    @Override
    public HtmlPage mouseDown(String elementLocator) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return (HtmlPage)element.mouseDown();
    }

    @Override
    public HtmlPage mouseDownAt(String elementLocator, String coordinates) {
        int[] coords = ReplayUtils.parseCoordinates(coordinates);
        this.checkIsTrue("Invalid coordinates: " + coordinates, coords != null);
        return this.mouseDownAt(elementLocator, coords[0], coords[1]);
    }

    @Override
    public HtmlPage mouseDownAt(String elementLocator, int coordX, int coordY) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return HtmlUnitElementUtils.fireMouseEvent(element, "mousedown", coordX, coordY, 0, 1);
    }

    @Override
    public HtmlPage mouseMove(String elementLocator) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return (HtmlPage)element.mouseMove();
    }

    @Override
    public HtmlPage mouseMoveAt(String elementLocator, String coordinates) {
        int[] coords = ReplayUtils.parseCoordinates(coordinates);
        this.checkIsTrue("Invalid coordinates: " + coordinates, coords != null);
        return this.mouseMoveAt(elementLocator, coords[0], coords[1]);
    }

    @Override
    public HtmlPage mouseMoveAt(String elementLocator, int coordX, int coordY) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return HtmlUnitElementUtils.fireMouseEvent(element, "mousemove", coordX, coordY, 0, 0);
    }

    @Override
    public HtmlPage mouseOut(String elementLocator) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return (HtmlPage)element.mouseOut();
    }

    @Override
    public HtmlPage mouseOver(String elementLocator) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return (HtmlPage)element.mouseOver();
    }

    @Override
    public HtmlPage mouseUp(String elementLocator) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return (HtmlPage)element.mouseUp();
    }

    @Override
    public HtmlPage mouseUpAt(String elementLocator, String coordinates) {
        int[] coords = ReplayUtils.parseCoordinates(coordinates);
        this.checkIsTrue("Invalid coordinates: " + coordinates, coords != null);
        return this.mouseUpAt(elementLocator, coords[0], coords[1]);
    }

    @Override
    public HtmlPage mouseUpAt(String elementLocator, int coordX, int coordY) {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Cannot interact with invisible elements", HtmlUnitElementUtils.isVisible(element));
        return HtmlUnitElementUtils.fireMouseEvent(element, "mouseup", coordX, coordY, 0, 1);
    }

    @Override
    public HtmlPage open(final String url) throws Exception {
        this.initIfNecessary();
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() throws Exception {
                String baseUrl = TestContext.getCurrent().getBaseUrl();
                String urlString = baseUrl != null ? UrlUtils.resolveUrl(baseUrl, url) : url;
                URL rewrittenUrl = HtmlUnitCommandAdapter.this.rewriteUrl(urlString);
                HtmlUnitCommandAdapter.this.getWebClient().getPage(rewrittenUrl);
                return HtmlUnitCommandAdapter.this.getCurrentPage();
            }
        });
    }

    @Override
    public HtmlPage open(URL url) throws Exception {
        return this.open(url.toString());
    }

    @Override
    public HtmlPage pause(long waitingTime) {
        WebWindow w = this.getCurrentPage().getEnclosingWindow();
        try {
            Thread.sleep(waitingTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (HtmlPage)w.getEnclosedPage();
    }

    @Override
    public HtmlPage pause(String waitingTime) {
        return this.pause(Long.parseLong(waitingTime));
    }

    @Override
    public HtmlPage removeSelection(String selectLocator, String optionLocator) {
        this.checkElementLocator(selectLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), selectLocator);
        this.checkIsTrue("Element '" + selectLocator + "' is not a HTML select element", element instanceof HtmlSelect);
        HtmlSelect selectElement = (HtmlSelect)element;
        this.checkIsTrue("Select '" + selectLocator + "' does not support multiple selection", selectElement.isMultipleSelectEnabled());
        this.checkIsTrue("Select '" + selectLocator + "' is disabled", !selectElement.isDisabled());
        List<HtmlOption> options = this.finder.findOptions(selectElement, optionLocator);
        Page p = selectElement.getPage();
        for (HtmlOption o : options) {
            if (o.isDisabled()) continue;
            p = o.setSelected(false);
        }
        return (HtmlPage)p;
    }

    @Override
    public HtmlPage select(String selectLocator, String optionLocator) {
        this.checkElementLocator(selectLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), selectLocator);
        this.checkIsTrue("Element '" + selectLocator + "' is not a HTML select element", element instanceof HtmlSelect);
        HtmlSelect selectElement = (HtmlSelect)element;
        this.checkIsTrue("Select '" + selectLocator + "' is disabled", !selectElement.isDisabled());
        Page p = selectElement.getPage();
        if (selectElement.isMultipleSelectEnabled()) {
            for (HtmlOption o : selectElement.getSelectedOptions()) {
                if (o.isDisabled()) continue;
                o.setSelected(false);
            }
            List<HtmlOption> options = this.finder.findOptions(selectElement, optionLocator);
            for (HtmlOption o : options) {
                if (o.isDisabled()) continue;
                p = o.setSelected(true);
            }
        } else {
            HtmlOption option = this.finder.findOption(selectElement, optionLocator);
            if (!option.isDisabled()) {
                option.setSelected(true);
            }
        }
        return (HtmlPage)p;
    }

    @Override
    public HtmlPage selectAndWait(final String selectLocator, final String optionLocator) {
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() throws Exception {
                return HtmlUnitCommandAdapter.this.select(selectLocator, optionLocator);
            }
        });
    }

    @Override
    public HtmlPage selectFrame(String frameLocator) {
        this.checkIsTrue("Frame locator is empty", StringUtils.isNotBlank((CharSequence)frameLocator));
        WebClient webClient = this.getWebClient();
        if (frameLocator.startsWith("index=")) {
            this.checkIsTrue("Invalid frame locator: " + frameLocator, FRAME_INDEX_PATTERN.matcher(frameLocator).matches());
            String frameID = StringUtils.substring((String)frameLocator, (int)6);
            WebWindow frameWindow = this.getFrameWindowByIndex(webClient, frameID);
            webClient.setCurrentWindow(frameWindow);
        } else if (FRAME_NAME_LOCATOR_PATTERN.matcher(frameLocator).matches()) {
            String frameID = StringUtils.substring((String)frameLocator, (int)4);
            Matcher m = FRAME_NAME_PATTERN.matcher(frameID);
            while (m.find()) {
                WebWindow frameWindow = this.getFrameWindowByNameOrID(webClient, m.group(2));
                webClient.setCurrentWindow(frameWindow);
            }
        } else if (frameLocator.equals("relative=top")) {
            List<TopLevelWindow> topLevelWindows = webClient.getTopLevelWindows();
            if (topLevelWindows.size() == 1) {
                webClient.setCurrentWindow(topLevelWindows.get(0));
            } else {
                webClient.setCurrentWindow(webClient.getCurrentWindow().getTopWindow());
            }
        } else if (frameLocator.equals("relative=parent")) {
            webClient.setCurrentWindow(webClient.getCurrentWindow().getParentWindow());
        } else {
            WebWindow frameWindow = this.getFrameWindowByNameOrID(webClient, frameLocator);
            webClient.setCurrentWindow(frameWindow);
        }
        this.setCurrentWindow(webClient.getCurrentWindow());
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage selectWindow() {
        return this.selectWindow(null);
    }

    @Override
    public HtmlPage selectWindow(String windowLocator) {
        if (StringUtils.isBlank((CharSequence)windowLocator) || windowLocator.equals("null")) {
            windowLocator = "";
        }
        WebClient webClient = this.getWebClient();
        WebWindow window = this.finder.findWindow(webClient, windowLocator);
        webClient.setCurrentWindow(window);
        this.setCurrentWindow(window);
        return (HtmlPage)window.getEnclosedPage();
    }

    @Override
    public HtmlPage submit(String formLocator) throws Exception {
        this.checkElementLocator(formLocator);
        HtmlPage page = this.getCurrentPage();
        HtmlElement element = this.finder.findElement(page, formLocator);
        this.checkIsTrue("Element '" + formLocator + "' is not a HTML form element", element instanceof HtmlForm);
        HtmlForm formElement = (HtmlForm)element;
        Method m = HtmlForm.class.getDeclaredMethod("submit", SubmittableElement.class);
        m.setAccessible(true);
        m.invoke((Object)formElement, new Object[]{null});
        HtmlPage p = this.getCurrentPage();
        WebWindow w = p.getEnclosingWindow();
        page.getWebClient().getJavaScriptEngine().processPostponedActions();
        return (HtmlPage)w.getEnclosedPage();
    }

    @Override
    public HtmlPage submitAndWait(final String formLocator) {
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() throws Exception {
                return HtmlUnitCommandAdapter.this.submit(formLocator);
            }
        });
    }

    @Override
    public HtmlPage type(String elementLocator, String text) throws IOException {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("Text is null", text != null);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        if (element instanceof SelectableTextInput) {
            ((SelectableTextInput)((Object)element)).select();
        }
        if (text.length() > 0) {
            element.type(text);
        } else if (element instanceof SelectableTextInput) {
            element.type(" \b");
        }
        if (element instanceof HtmlHiddenInput) {
            ((HtmlHiddenInput)element).setValue(text);
        } else if (element instanceof HtmlFileInput) {
            ((HtmlFileInput)element).setValue(text);
        }
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage typeAndWait(final String elementLocator, final String text) {
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() throws Exception {
                return HtmlUnitCommandAdapter.this.type(elementLocator, text + "\n");
            }
        });
    }

    @Override
    public HtmlPage uncheck(String elementLocator) throws IOException {
        this.checkElementLocator(elementLocator);
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsTrue("Element '" + elementLocator + "' is not a HTML input element", element instanceof HtmlInput);
        HtmlInput input = (HtmlInput)element;
        String typeAttribute = input.getTypeAttribute();
        this.checkIsTrue("Only checkboxes/radio buttons can be unchecked", typeAttribute.equals("radio") || typeAttribute.equals("checkbox"));
        this.checkIsTrue("Checkbox '" + elementLocator + "' is disabled", !input.isDisabled());
        if (input.isChecked()) {
            return (HtmlPage)input.click();
        }
        return (HtmlPage)input.getPage();
    }

    @Override
    public HtmlPage uncheckAndWait(final String elementLocator) throws IOException {
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() throws Exception {
                return HtmlUnitCommandAdapter.this.uncheck(elementLocator);
            }
        });
    }

    @Override
    public HtmlPage waitForAttribute(String attributeLocator, String textPattern) {
        this.waitForCondition(this.attributeMatches(attributeLocator, textPattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForAttribute(String elementLocator, String attributeName, String textPattern) {
        this.waitForCondition(this.attributeMatches(elementLocator, attributeName, textPattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForChecked(String elementLocator) {
        this.waitForCondition(this.elementChecked(elementLocator, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForClass(String elementLocator, String clazzString) {
        this.waitForCondition(this.classMatches(elementLocator, clazzString, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForElementCount(String elementLocator, int count) {
        this.executeRunnable(count == 0, () -> this.waitForCondition(this.elementCountEqual(elementLocator, count, true)));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForElementCount(String elementLocator, String count) {
        return this.waitForElementCount(elementLocator, Integer.parseInt(count));
    }

    @Override
    public HtmlPage waitForElementPresent(String elementLocator) {
        this.waitForCondition(this.elementPresent(elementLocator, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForEval(String expression, String textPattern) {
        this.waitForCondition(this.evalMatches(expression, textPattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotAttribute(String attributeLocator, String textPattern) {
        this.waitForCondition(this.attributeMatches(attributeLocator, textPattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotAttribute(String elementLocator, String attributeName, String textPattern) {
        this.waitForCondition(this.attributeMatches(elementLocator, attributeName, textPattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotChecked(String elementLocator) {
        this.waitForCondition(this.elementChecked(elementLocator, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotClass(String elementLocator, String clazzString) {
        this.waitForCondition(this.classMatches(elementLocator, clazzString, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotElementCount(String elementLocator, int count) {
        this.executeRunnable(count != 0, () -> this.waitForCondition(this.elementCountEqual(elementLocator, count, false)));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotElementCount(String elementLocator, String count) {
        return this.waitForNotElementCount(elementLocator, Integer.parseInt(count));
    }

    @Override
    public HtmlPage waitForNotElementPresent(String elementLocator) {
        this.executeRunnable(true, () -> this.waitForCondition(this.elementPresent(elementLocator, false)));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotEval(String expression, String textPattern) {
        this.waitForCondition(this.evalMatches(expression, textPattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotStyle(String elementLocator, String styleText) {
        this.waitForCondition(this.styleMatches(elementLocator, styleText, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotText(String elementLocator, String textPattern) {
        this.waitForCondition(this.textMatches(elementLocator, textPattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotTextPresent(String textPattern) {
        this.waitForCondition(this.pageTextMatches(textPattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotTitle(String titlePattern) {
        this.waitForCondition(this.titleMatches(titlePattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotXpathCount(String xpath, int count) {
        this.executeRunnable(count != 0, () -> this.waitForCondition(this.xpathCountEqual(xpath, count, false)));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotXpathCount(String xpath, String count) {
        return this.waitForNotXpathCount(xpath, Integer.parseInt(count));
    }

    @Override
    public HtmlPage waitForPageToLoad() {
        return this.performActionAndWaitForPageLoad(new Callable<HtmlPage>(){

            @Override
            public HtmlPage call() {
                return HtmlUnitCommandAdapter.this.getCurrentPage();
            }
        });
    }

    @Override
    public HtmlPage waitForPopUp() {
        return this.waitForPopUp(null);
    }

    @Override
    public HtmlPage waitForPopUp(String windowID) {
        return this.waitForPopUp(windowID, TestContext.getCurrent().getTimeout());
    }

    @Override
    public HtmlPage waitForPopUp(final String windowID, long maxWaitingTime) {
        final WebClient webClient = this.getWebClient();
        this.waitForCondition(new Condition("WINDOW PRESENT"){

            @Override
            protected boolean evaluate() {
                boolean found = windowID == null ? webClient.getTopLevelWindows().size() > 1 : HtmlUnitCommandAdapter.this.finder.findWindow(webClient, windowID) != null;
                this.setReason((found ? "At least one" : "No such") + " window found");
                return found;
            }
        }, maxWaitingTime);
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForPopUp(String windowID, String maxWaitingTime) {
        return this.waitForPopUp(windowID, Long.parseLong(maxWaitingTime));
    }

    @Override
    public HtmlPage waitForStyle(String elementLocator, String styleText) {
        this.waitForCondition(this.styleMatches(elementLocator, styleText, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForText(String elementLocator, String textPattern) {
        this.waitForCondition(this.textMatches(elementLocator, textPattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForTextPresent(String textPattern) {
        this.waitForCondition(this.pageTextMatches(textPattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForValue(String elementLocator, String valuePattern) {
        this.waitForCondition(this.valueMatches(elementLocator, valuePattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotValue(String elementLocator, String valuePattern) {
        this.waitForCondition(this.valueMatches(elementLocator, valuePattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForTitle(String titlePattern) {
        this.waitForCondition(this.titleMatches(titlePattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForXpathCount(String xpath, int count) {
        this.executeRunnable(count == 0, () -> this.waitForCondition(this.xpathCountEqual(xpath, count, true)));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForXpathCount(String xpath, String count) {
        return this.waitForXpathCount(xpath, Integer.parseInt(count));
    }

    @Override
    public HtmlPage waitForSelectedId(String selectLocator, String idPattern) {
        this.waitForCondition(this.idSelected(selectLocator, idPattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotSelectedId(String selectLocator, String idPattern) {
        this.waitForCondition(this.idSelected(selectLocator, idPattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForSelectedIndex(String selectLocator, String indexPattern) {
        this.waitForCondition(this.indexSelected(selectLocator, indexPattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotSelectedIndex(String selectLocator, String indexPattern) {
        this.waitForCondition(this.indexSelected(selectLocator, indexPattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForSelectedLabel(String selectLocator, String labelPattern) {
        this.waitForCondition(this.labelSelected(selectLocator, labelPattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotSelectedLabel(String selectLocator, String labelPattern) {
        this.waitForCondition(this.labelSelected(selectLocator, labelPattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForSelectedValue(String selectLocator, String valuePattern) {
        this.waitForCondition(this.valueSelected(selectLocator, valuePattern, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotSelectedValue(String selectLocator, String valuePattern) {
        this.waitForCondition(this.valueSelected(selectLocator, valuePattern, false));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForVisible(String elementLocator) {
        this.waitForCondition(this.elementVisible(elementLocator, true));
        return this.getCurrentPage();
    }

    @Override
    public HtmlPage waitForNotVisible(String elementLocator) {
        this.waitForCondition(this.elementVisible(elementLocator, false));
        return this.getCurrentPage();
    }

    @Override
    protected String _getText(String elementLocator) {
        String type;
        HtmlElement e = this.finder.findElement(this.getCurrentPage(), elementLocator, false);
        String text = e instanceof HtmlInput ? ((type = e.getAttribute("type")).equals("radio") || type.equals("checkbox") ? "" : ((HtmlInput)e).getValue()) : this.getElementText(e);
        return text;
    }

    @Override
    protected String _getValue(String elementLocator) {
        HtmlElement e = this.finder.findElement(this.getCurrentPage(), elementLocator, false);
        if (e instanceof HtmlTextArea || e instanceof HtmlOption && !e.hasAttribute("value")) {
            return this.getElementText(e);
        }
        Object val = e.getScriptableObject().get((Object)"value");
        if (val instanceof String) {
            return (String)val;
        }
        return e.getAttribute("value");
    }

    @Override
    public String getPageText() {
        HtmlPage page = this.getCurrentPage();
        return this.getElementText(page.getDocumentElement());
    }

    @Override
    public String getTitle() {
        return this.getCurrentPage().getTitleText().trim();
    }

    @Override
    protected int _getXpathCount(String xpath) {
        return HtmlPageUtils.countElementsByXPath(this.getCurrentPage(), xpath);
    }

    @Override
    protected boolean _isElementPresent(String elementLocator) {
        return this.finder.isElementPresent(this.getCurrentPage(), elementLocator);
    }

    @Override
    protected String _evaluate(String expression) {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return null;
        }
        String script = "(function(){ return function(){ var r = null; try { r = this.eval(arguments[0]) } catch (e){ } return String(r) }})()";
        HtmlPage page = this.getCurrentPage();
        Function jsFunction = (Function)page.executeJavaScript("(function(){ return function(){ var r = null; try { r = this.eval(arguments[0]) } catch (e){ } return String(r) }})()").getJavaScriptResult();
        Object[] args = new Object[]{expression};
        Window w = (Window)page.getEnclosingWindow().getScriptableObject();
        return (String)page.executeJavaScriptFunction((Object)jsFunction, w, args, null).getJavaScriptResult();
    }

    @Override
    protected List<String> getSelectedIds(String elementLocator) {
        HtmlElement selectElement = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsEqual(String.format("Element '%s' is not a HTML select element", elementLocator), "select", selectElement.getTagName());
        HtmlSelect select = (HtmlSelect)selectElement;
        this.checkIsTrue(String.format("Select element '%s' does not contain any option", elementLocator), select.getOptionSize() > 0);
        ArrayList<String> ids = new ArrayList<String>();
        for (HtmlOption selectedOption : select.getSelectedOptions()) {
            ids.add(selectedOption.getId());
        }
        if (ids.isEmpty()) {
            ids.add(select.getOption(0).getId());
        }
        return ids;
    }

    @Override
    protected List<Integer> getSelectedIndices(String elementLocator) {
        HtmlElement selectElement = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsEqual(String.format("Element '%s' is not a HTML select element", elementLocator), "select", selectElement.getTagName());
        HtmlSelect select = (HtmlSelect)selectElement;
        this.checkIsTrue(String.format("Select element '%s' does not contain any option", elementLocator), select.getOptionSize() > 0);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        List<HtmlOption> options = select.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            if (!options.get(i).isSelected()) continue;
            indices.add(i);
        }
        if (indices.isEmpty()) {
            indices.add(ZERO);
        }
        return indices;
    }

    @Override
    protected List<String> getSelectedLabels(String elementLocator) {
        HtmlElement selectElement = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsEqual(String.format("Element '%s' is not a HTML select element", elementLocator), "select", selectElement.getTagName());
        HtmlSelect select = (HtmlSelect)selectElement;
        this.checkIsTrue(String.format("Select element '%s' does not contain any option", elementLocator), select.getOptionSize() > 0);
        ArrayList<String> labels = new ArrayList<String>();
        for (HtmlOption option : select.getSelectedOptions()) {
            labels.add(HtmlUnitElementUtils.computeText(option));
        }
        if (labels.isEmpty()) {
            labels.add(HtmlUnitElementUtils.computeText(select.getOption(0)));
        }
        return labels;
    }

    @Override
    protected List<String> getSelectedValues(String elementLocator) {
        HtmlElement selectElement = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsEqual(String.format("Element '%s' is not a HTML select element", elementLocator), "select", selectElement.getTagName());
        HtmlSelect select = (HtmlSelect)selectElement;
        this.checkIsTrue(String.format("Select element '%s' does not contain any option", elementLocator), select.getOptionSize() > 0);
        ArrayList<String> values = new ArrayList<String>();
        for (HtmlOption option : select.getSelectedOptions()) {
            values.add(option.getValueAttribute());
        }
        if (values.isEmpty()) {
            values.add(select.getOption(0).getValueAttribute());
        }
        return values;
    }

    @Override
    protected boolean _isChecked(String elementLocator) {
        HtmlElement checkboxOrRadio = this.finder.findElement(this.getCurrentPage(), elementLocator);
        this.checkIsEqual(String.format("Element '%s' is not a HTML input element", elementLocator), "input", checkboxOrRadio.getTagName());
        HtmlInput inputElement = (HtmlInput)checkboxOrRadio;
        String inputType = inputElement.getTypeAttribute();
        this.checkIsTrue(String.format("Input '%s' is neither a checkbox nor a radio button", elementLocator), "radio".equals(inputType) || "checkbox".equals(inputType));
        return inputElement.isChecked();
    }

    @Override
    protected boolean _isEnabled(String elementLocator) {
        return !this.finder.findElement(this.getCurrentPage(), elementLocator).hasAttribute("disabled");
    }

    @Override
    protected boolean _isVisible(String elementLocator) {
        return HtmlUnitElementUtils.isVisible(this.finder.findElement(this.getCurrentPage(), elementLocator));
    }

    @Override
    protected String _getAttribute(String elementLocator, String attributeName) {
        HtmlElement element = this.finder.findElement(this.getCurrentPage(), elementLocator);
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    @Override
    protected String _getEffectiveStyle(String elementLocator, String propertyName) {
        this.checkElementLocator(elementLocator);
        this.checkIsTrue("CSS property name is blank", StringUtils.isNotBlank((CharSequence)propertyName));
        HtmlPage page = this.getCurrentPage();
        HtmlElement element = this.finder.findElement(page, elementLocator);
        ComputedCSSStyleDeclaration style = ((Window)page.getEnclosingWindow().getScriptableObject()).getComputedStyle((Element)element.getScriptableObject(), null);
        return (String)StringUtils.defaultIfEmpty((CharSequence)style.getPropertyValue(propertyName), null);
    }

    @Override
    protected int _getElementCount(String elementLocator) {
        return this.finder.findElements(this.getCurrentPage(), elementLocator).size();
    }

    protected URL getCurrentUrl() {
        return this.getCurrentPage().getUrl();
    }

    private synchronized void setCurrentWindow(WebWindow w) {
        this._currWindow = new WeakReference<WebWindow>(w);
    }

    private synchronized WebWindow getCurrentWindow() {
        return (WebWindow)this._currWindow.get();
    }

    private HtmlPage getCurrentPage() {
        Page page;
        WebWindow current = this.getCurrentWindow();
        if (current == null) {
            this.setCurrentWindow(this.getWebClient().getCurrentWindow());
        }
        if ((page = this.getCurrentWindow().getEnclosedPage()) instanceof HtmlPage) {
            return (HtmlPage)page;
        }
        if (page == null) {
            throw new XltException("There is no current page.");
        }
        throw new XltException("The current page is not an HTML page.");
    }

    private String getElementText(HtmlElement element) {
        return HtmlUnitElementUtils.computeText(element);
    }

    private WebWindow getFrameWindowByIndex(WebClient webClient, String index) {
        try {
            int idx = Integer.parseInt(index);
            HtmlPage page = this.getCurrentPage();
            return page.getFrames().get(idx);
        }
        catch (Exception e) {
            throw new NoSuchWindowException("No frame window found with index: " + index, e);
        }
    }

    private WebWindow getFrameWindowByNameOrID(WebClient webClient, String nameOrID) {
        HtmlPage page = this.getCurrentPage();
        HtmlElement e = this.finder.findElement(page, nameOrID);
        if (e instanceof BaseFrameElement) {
            return ((BaseFrameElement)e).getEnclosedWindow();
        }
        throw new NoSuchWindowException("No frame window found with name or ID: " + nameOrID);
    }

    private WebClient getWebClient() {
        WebClient webClient = TestContext.getCurrent().getWebClient();
        if (webClient == null) {
            throw new XltException("There is no current web client.");
        }
        return webClient;
    }

    private HtmlPage performActionAndWaitForPageLoad(Callable<HtmlPage> action) {
        WebClient webClient = this.getWebClient();
        return TestContext.getCurrent().callAndWait(new WaitForPageLoadAction(action, webClient));
    }

    private synchronized void initIfNecessary() {
        if (!this.initialized) {
            WebClient wc = this.getWebClient();
            this.setCurrentWindow(wc.getCurrentWindow());
            wc.addWebWindowListener(new WebWindowListener(){

                @Override
                public void webWindowOpened(WebWindowEvent event) {
                }

                @Override
                public void webWindowContentChanged(WebWindowEvent event) {
                }

                @Override
                public void webWindowClosed(WebWindowEvent event) {
                    WebWindow curr = HtmlUnitCommandAdapter.this.getCurrentWindow();
                    do {
                        if (curr != event.getWebWindow()) continue;
                        HtmlUnitCommandAdapter.this.setCurrentWindow(HtmlUnitCommandAdapter.this.getCurrentWindow().getTopWindow());
                        return;
                    } while ((curr = curr.getParentWindow()) != HtmlUnitCommandAdapter.this.getCurrentWindow().getTopWindow());
                }
            });
            this.initialized = true;
        }
    }

    public static HtmlUnitScriptCommands createAdapter() {
        return (HtmlUnitScriptCommands)Proxy.newProxyInstance(HtmlUnitCommandAdapter.class.getClassLoader(), new Class[]{HtmlUnitScriptCommands.class}, new CommandsInvocationHandler<HtmlUnitCommandAdapter>(new HtmlUnitCommandAdapter(), AbstractCommandAdapter.LOGGER));
    }

    private static class WaitForPageLoadAction
    implements Callable<HtmlPage> {
        private final Callable<HtmlPage> action;
        private final WebClient webClient;

        private WaitForPageLoadAction(Callable<HtmlPage> loadAction, WebClient webClient) {
            this.action = loadAction;
            this.webClient = webClient;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HtmlPage call() throws Exception {
            WindowContentChangedListener windowListener = new WindowContentChangedListener();
            try {
                this.webClient.addWebWindowListener(windowListener);
                HtmlPage page = this.action.call();
                while (!windowListener.contentChanged) {
                    Thread.sleep(500L);
                }
                while (!"complete".equals(page.getReadyState())) {
                    Thread.sleep(500L);
                }
                HtmlPage htmlPage = page;
                return htmlPage;
            }
            finally {
                this.webClient.removeWebWindowListener(windowListener);
            }
        }
    }

    private static class WindowContentChangedListener
    implements WebWindowListener {
        private boolean contentChanged;

        private WindowContentChangedListener() {
        }

        @Override
        public void webWindowOpened(WebWindowEvent event) {
        }

        @Override
        public void webWindowContentChanged(WebWindowEvent event) {
            WebWindow window = event.getWebWindow();
            if (window instanceof TopLevelWindow || window instanceof DialogWindow) {
                Page oldPage = event.getOldPage();
                Page newPage = event.getNewPage();
                if ((oldPage == null || !oldPage.getUrl().toString().equals("about:blank")) && newPage.isHtmlPage() && newPage.getWebResponse().getResponseHeaderValue("refresh") == null) {
                    this.contentChanged = true;
                }
            }
        }

        @Override
        public void webWindowClosed(WebWindowEvent event) {
        }
    }
}

