/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.engine.scripting.MacroProcessor;
import com.xceptance.xlt.engine.scripting.ScriptException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class VariableScope {
    private static final Pattern VAR_NAME_PATTERN = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");
    private static final Pattern QUOTE_DOLLARSIGN_PATTERN = Pattern.compile("\\$\\$");
    private static final Pattern VAR_EXPR_PATTERN = Pattern.compile("(?<!\\$)\\$\\{[^\\s{}$]+\\}");
    private static final Pattern MACRO_EXPR_PATTERN = Pattern.compile("\\$\\$|\\$\\{[^\\s${}]+\\}");
    private static final int MAX_ITERATIONS = 1000;
    private final VariableScope _enclosingScope;
    private final Map<String, String> _testData;

    VariableScope(Map<String, String> testData, VariableScope enclosingScope) {
        this._enclosingScope = enclosingScope;
        this._testData = testData != null ? testData : Collections.emptyMap();
    }

    VariableScope(Map<String, String> testData) {
        this(testData, null);
    }

    VariableScope getEnclosingScope() {
        return this._enclosingScope;
    }

    boolean hasEnclosingScope() {
        return this._enclosingScope != null;
    }

    String resolve(String resolvable) {
        if (StringUtils.isBlank((CharSequence)resolvable)) {
            return resolvable;
        }
        String varResolved = this.resolveRecursively(resolvable, new HashSet<String>());
        return VariableScope.resolveMacros(varResolved);
    }

    String resolveKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return key;
        }
        Object resolveKey = RegExUtils.isMatching(key, VAR_EXPR_PATTERN) ? key : "${" + key + "}";
        String resolved = this.resolve((String)resolveKey);
        if (resolved.equals(resolveKey)) {
            return null;
        }
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeValue(String key, String value) {
        if (!VariableScope.isValidVariable(key)) {
            throw new ScriptException("Invalid variable name '" + key + "'");
        }
        if (value != null) {
            VariableScope variableScope = this;
            synchronized (variableScope) {
                this._testData.put(key, value);
            }
        }
    }

    private String resolveVariable(String variable) {
        String value = null;
        if (this._enclosingScope != null) {
            value = this._enclosingScope.resolveVariable(variable);
        }
        if (value == null) {
            value = this._testData.get(variable);
        }
        return value;
    }

    private String resolveRecursively(String value, HashSet<String> hashSet) {
        String s;
        block3: {
            String input;
            s = value;
            if (!StringUtils.isNotBlank((CharSequence)s)) break block3;
            int iterations = 0;
            do {
                if (iterations++ > 1000) {
                    throw new ScriptException("Failed to resolve '" + value + "'");
                }
                input = s;
                MacroProcessor macroProc = MacroProcessor.getInstance();
                for (String match : RegExUtils.getAllMatches(s, VAR_EXPR_PATTERN)) {
                    String exp = match.substring(2, match.length() - 1);
                    if (!VariableScope.isValidVariable(exp) || hashSet.contains(exp) || macroProc.isMacro(exp)) continue;
                    hashSet.add(exp);
                    String resolved = this.resolveVariable(exp);
                    if (resolved == null) continue;
                    String recResolved = this.resolveRecursively(resolved, new HashSet<String>(hashSet));
                    s = RegExUtils.replaceAll(s, "(?<!\\$)" + RegExUtils.escape(match), Matcher.quoteReplacement(recResolved));
                }
            } while (!s.equals(input));
        }
        return s;
    }

    private static String resolveMacros(String value) {
        String s;
        block4: {
            String input;
            StringBuilder result;
            s = value;
            if (StringUtils.isEmpty((CharSequence)s)) break block4;
            MacroProcessor macroProc = MacroProcessor.getInstance();
            int iterations = 0;
            do {
                if (iterations++ > 1000) {
                    throw new ScriptException("Failed to resolve macros for '" + value + "'");
                }
                input = s;
                result = new StringBuilder(s);
                Matcher m = MACRO_EXPR_PATTERN.matcher(s);
                int offset = 0;
                while (m.find()) {
                    String match;
                    String replacement = match = m.group();
                    if (match.length() == 2 && match.charAt(0) == match.charAt(1)) continue;
                    String variable = match.substring(2, match.length() - 1);
                    if (macroProc.isMacro(variable)) {
                        replacement = macroProc.executeMacro(variable);
                    }
                    result.replace(m.start() + offset, m.end() + offset, replacement);
                    offset += replacement.length() - match.length();
                }
            } while (!(s = result.toString()).equals(input));
        }
        return VariableScope.unescape(s);
    }

    private static boolean isValidVariable(String variable) {
        return RegExUtils.isMatching(variable, VAR_NAME_PATTERN);
    }

    private static String unescape(String value) {
        String s = value;
        if (!StringUtils.isEmpty((CharSequence)s)) {
            StringBuilder result = new StringBuilder(s);
            Matcher m = QUOTE_DOLLARSIGN_PATTERN.matcher(s);
            int offset = 0;
            while (m.find()) {
                result.replace(m.start() + offset, m.end() + offset, "$");
                --offset;
            }
            s = result.toString();
        }
        return s;
    }
}

